/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.service;

import com.nbcb.sdk.SDKRequestHead;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.param.ConfigFile;
import com.nbcb.sdk.aes.param.KeyStoreFactory;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class BussinessHTTPSAdapterService {
    private static Log log = NbczLogger.getLog(BussinessHTTPSAdapterService.class);

    public static byte[] post(String urlStr, byte[] reqJson, SDKRequestHead head) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("url=[" + urlStr + "]");
            log.debug("\u8bf7\u6c42\u62a5\u6587=[" + new String(reqJson) + "]");
        }
        urlStr = ConfigFile.MPUBLICURL + "/" + urlStr;
        HttpURLConnection urlConnection = null;
        byte[] resultData = null;
        OutputStream OutputStream2 = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(urlStr);
            if ("true".equalsIgnoreCase(ConfigFile.ISPROXY)) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ConfigFile.PROXYIP, Integer.parseInt(ConfigFile.PROXYPORT)));
                urlConnection = (HttpsURLConnection)url.openConnection(proxy);
            } else {
                urlConnection = (HttpsURLConnection)url.openConnection();
            }
            BussinessHTTPSAdapterService.addRequestHead(urlStr, head, (HttpsURLConnection)urlConnection);
            urlConnection.connect();
            OutputStream2 = urlConnection.getOutputStream();
            OutputStream2.write(reqJson);
            OutputStream2.flush();
            int code = urlConnection.getResponseCode();
            inputStream = urlConnection.getInputStream();
            resultData = BussinessHTTPSAdapterService.getResponse(inputStream);
            if (200 != code) {
                if (log.isErrorEnabled()) {
                    log.error("HTTP \u54cd\u5e94\u5f02\u5e38 ,ResponseCode=[" + code + "]");
                }
                throw new SDKException(SDKExceptionEnums.HTTPCONN_ERROR);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u54cd\u5e94\u62a5\u6587=[" + new String(resultData) + "]");
            }
        }
        catch (Exception e) {
            if (e instanceof SDKException) {
                throw e;
            }
            if (log.isErrorEnabled()) {
                log.error("\u901a\u8baf\u6a21\u5757\u5f02\u5e38,\u901a\u8baf\u5730\u5740=[" + urlStr + "]", e);
            }
            throw new SDKException(SDKExceptionEnums.POST_ERROR);
        }
        finally {
            block26: {
                block25: {
                    if (OutputStream2 != null) {
                        try {
                            OutputStream2.close();
                        }
                        catch (IOException e) {
                            if (!log.isErrorEnabled()) break block25;
                            log.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", e);
                        }
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block26;
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38", e);
                    }
                }
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return resultData;
    }

    public static byte[] post(String appkey, String urlStr, byte[] reqJson, SDKRequestHead head) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("url=[" + urlStr + "]");
            log.debug("\u8bf7\u6c42\u62a5\u6587=[" + new String(reqJson) + "]");
        }
        urlStr = ConfigFile.configMap.get(appkey).getMPUBLICURL() + "/" + urlStr;
        HttpsURLConnection urlConnection = null;
        byte[] resultData = null;
        OutputStream OutputStream2 = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(urlStr);
            urlConnection = (HttpsURLConnection)url.openConnection();
            BussinessHTTPSAdapterService.addRequestHead(urlStr, head, urlConnection);
            urlConnection.connect();
            OutputStream2 = urlConnection.getOutputStream();
            OutputStream2.write(reqJson);
            OutputStream2.flush();
            int code = urlConnection.getResponseCode();
            inputStream = urlConnection.getInputStream();
            resultData = BussinessHTTPSAdapterService.getResponse(inputStream);
            if (200 != code) {
                if (log.isErrorEnabled()) {
                    log.error("HTTP \u54cd\u5e94\u5f02\u5e38 ,ResponseCode=[" + code + "]");
                }
                throw new SDKException(SDKExceptionEnums.HTTPCONN_ERROR);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u54cd\u5e94\u62a5\u6587=[" + new String(resultData) + "]");
            }
        }
        catch (Exception e) {
            if (e instanceof SDKException) {
                throw e;
            }
            if (log.isErrorEnabled()) {
                log.error("\u901a\u8baf\u6a21\u5757\u5f02\u5e38,\u901a\u8baf\u5730\u5740=[" + urlStr + "]", e);
            }
            throw new SDKException(SDKExceptionEnums.POST_ERROR);
        }
        finally {
            block24: {
                block23: {
                    if (OutputStream2 != null) {
                        try {
                            OutputStream2.close();
                        }
                        catch (IOException e) {
                            if (!log.isErrorEnabled()) break block23;
                            log.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", e);
                        }
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block24;
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38", e);
                    }
                }
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return resultData;
    }

    public static byte[] post(String appkey, String urlStr, byte[] reqJson, SDKRequestHead head, Map<String, String> header) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("url=[" + urlStr + "]");
            log.debug("\u8bf7\u6c42\u62a5\u6587=[" + new String(reqJson) + "]");
        }
        urlStr = ConfigFile.configMap.get(appkey).getMPUBLICURL() + "/" + urlStr;
        HttpsURLConnection urlConnection = null;
        byte[] resultData = null;
        OutputStream OutputStream2 = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(urlStr);
            urlConnection = (HttpsURLConnection)url.openConnection();
            BussinessHTTPSAdapterService.addRequestHead(urlStr, head, urlConnection, header);
            urlConnection.connect();
            OutputStream2 = urlConnection.getOutputStream();
            OutputStream2.write(reqJson);
            OutputStream2.flush();
            int code = urlConnection.getResponseCode();
            inputStream = urlConnection.getInputStream();
            resultData = BussinessHTTPSAdapterService.getResponse(inputStream);
            if (200 != code) {
                if (log.isErrorEnabled()) {
                    log.error("HTTP \u54cd\u5e94\u5f02\u5e38 ,ResponseCode=[" + code + "]");
                }
                throw new SDKException(SDKExceptionEnums.HTTPCONN_ERROR);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u54cd\u5e94\u62a5\u6587=[" + new String(resultData) + "]");
            }
        }
        catch (Exception e) {
            if (e instanceof SDKException) {
                throw e;
            }
            if (log.isErrorEnabled()) {
                log.error("\u901a\u8baf\u6a21\u5757\u5f02\u5e38,\u901a\u8baf\u5730\u5740=[" + urlStr + "]", e);
            }
            throw new SDKException(SDKExceptionEnums.POST_ERROR);
        }
        finally {
            block24: {
                block23: {
                    if (OutputStream2 != null) {
                        try {
                            OutputStream2.close();
                        }
                        catch (IOException e) {
                            if (!log.isErrorEnabled()) break block23;
                            log.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", e);
                        }
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block24;
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38", e);
                    }
                }
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return resultData;
    }

    private static void addRequestHead(String urlStr, SDKRequestHead head, HttpsURLConnection mConnection) throws Exception {
        mConnection.setDoOutput(true);
        mConnection.setDoInput(true);
        mConnection.setConnectTimeout(ConfigFile.configMap.get(head.getAPP_Key()).getCONNECT_TIMEOUT());
        mConnection.setReadTimeout(ConfigFile.configMap.get(head.getAPP_Key()).getREAD_TIMEOUT());
        mConnection.setRequestMethod("POST");
        mConnection.setUseCaches(false);
        mConnection.addRequestProperty("APP_Key", head.getAPP_Key());
        mConnection.addRequestProperty("IP_Adr", head.getIP_Adr());
        mConnection.addRequestProperty("MAC_Adr", head.getMAC_Adr());
        mConnection.addRequestProperty("Txn_ModDsc", head.getTxn_ModDsc());
        mConnection.addRequestProperty("URI", urlStr);
        mConnection.addRequestProperty("Content-Type", "application/json");
        mConnection.setHostnameVerifier(KeyStoreFactory.getInstance().getTrustAnyHostnameVerifier());
        mConnection.setSSLSocketFactory(KeyStoreFactory.getInstance().getSslcontext().getSocketFactory());
        if (null != head.getAPP_Token() && !"".equals(head.getAPP_Token())) {
            mConnection.setRequestProperty("APP_Token", head.getAPP_Token());
        }
    }

    private static void addRequestHead(String urlStr, SDKRequestHead head, HttpsURLConnection mConnection, Map<String, String> header) throws Exception {
        mConnection.setDoOutput(true);
        mConnection.setDoInput(true);
        mConnection.setConnectTimeout(ConfigFile.configMap.get(head.getAPP_Key()).getCONNECT_TIMEOUT());
        mConnection.setReadTimeout(ConfigFile.configMap.get(head.getAPP_Key()).getREAD_TIMEOUT());
        mConnection.setRequestMethod("POST");
        mConnection.setUseCaches(false);
        if (header.size() > 0) {
            for (String key : header.keySet()) {
                mConnection.addRequestProperty(key, header.get(key));
            }
        }
        mConnection.addRequestProperty("APP_Key", head.getAPP_Key());
        mConnection.addRequestProperty("IP_Adr", head.getIP_Adr());
        mConnection.addRequestProperty("MAC_Adr", head.getMAC_Adr());
        mConnection.addRequestProperty("Txn_ModDsc", head.getTxn_ModDsc());
        mConnection.addRequestProperty("URI", urlStr);
        mConnection.addRequestProperty("Content-Type", "application/json");
        mConnection.setHostnameVerifier(KeyStoreFactory.getInstance().getTrustAnyHostnameVerifier());
        mConnection.setSSLSocketFactory(KeyStoreFactory.getInstance().getSslcontext().getSocketFactory());
        if (null != head.getAPP_Token() && !"".equals(head.getAPP_Token())) {
            mConnection.setRequestProperty("APP_Token", head.getAPP_Token());
        }
    }

    private static byte[] getResponse(InputStream in) throws IOException {
        byte[] rspBytes = null;
        ByteArrayOutputStream outt = new ByteArrayOutputStream();
        int n = 0;
        byte[] val = new byte[1024];
        while ((n = in.read(val)) > 0) {
            outt.write(val, 0, n);
        }
        rspBytes = outt.toByteArray();
        return rspBytes;
    }
}

