/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.service;

import com.nbcb.sdk.OpenSDK;
import com.nbcb.sdk.SDKRequestHead;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.param.ConfigFile;
import com.nbcb.sdk.aes.param.KeyStoreFactory;
import com.nbcb.sdk.aes.service.ApproveDevService;
import com.nbcb.sdk.aes.service.BuildErrorRespService;
import com.nbcb.sdk.aes.service.CheckTokenService;
import com.nbcb.sdk.aes.service.CommonSecurityService;
import com.nbcb.sdk.aes.service.CoverHeadService;
import com.nbcb.sdk.aes.service.PackHeadService;
import com.nbcb.sdk.aes.service.URLConnectionAdapter;
import com.nbcb.sdk.aes.utils.FileUtils;
import com.nbcb.sdk.aes.utils.RandomKey;
import com.nbcb.sdk.file.FileDownloadResponse;
import com.nbcb.sdk.file.FileResponse;
import com.nbcb.sdk.file.FileUploadRequest;
import com.nbcb.sdk.gm.SM3Utils;
import com.nbcb.sdk.json.JsonHelper;
import com.nbcb.sdk.json.JsonHelperFactory;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class OpenFileService {
    private static final Log log = NbczLogger.getLog(OpenFileService.class);
    public static final String SERVICE_BIG_FILE_UPLOAD = "bigFileUpload";
    public static final String SERVICE_BIG_FILE_DOWNLOAD = "bigFileDownload";
    private static final int BUSINESS_BYTE_LENGTH = 4096;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static String sendBigFile(String appkey, String channelNo, String filePath) throws Exception {
        String respValue = "";
        JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
        try {
            String token;
            Map<String, FileUploadRequest> requestMap = OpenFileService.getFileUploadRequest(channelNo, filePath);
            String json = jsonHelper.toJSONString(requestMap);
            File file = new File(filePath);
            Map<String, Object> localMap = ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getTokenMap();
            if (localMap == null || localMap.size() <= 0) {
                localMap = OpenSDK.approveDev(appkey);
            }
            if (null == (token = String.valueOf(localMap.get("APP_Token"))) || "".equals(token)) {
                localMap = OpenSDK.approveDev(appkey);
                token = String.valueOf(localMap.get("APP_Token"));
            }
            String expirein = String.valueOf(localMap.get("expirein"));
            String updatetime = String.valueOf(localMap.get("updatetime"));
            if (!KeyStoreFactory.getInstance().checkTokenVaild(expirein, updatetime)) {
                localMap = OpenSDK.approveDev(appkey);
                token = String.valueOf(localMap.get("APP_Token"));
            }
            if (!"000000".equalsIgnoreCase(localMap.get("Txn_Rsp_Cd_Dsc") + "") || !"000000".equalsIgnoreCase(localMap.get("SYS_RESP_CODE") + "")) {
                return BuildErrorRespService.buildErrorResp(OpenSDK.objToStr(localMap.get("SYS_RESP_CODE")), OpenSDK.objToStr(localMap.get("SYS_RESP_DESC")));
            }
            byte[] cntrKey = (byte[])localMap.get("CntrKey");
            byte[] syncKey = (byte[])localMap.get("SyncKey");
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByJson(appkey, "", json, token);
            json = CoverHeadService.cover(head, json);
            byte[] reqJson = CommonSecurityService.encryService(json, randomKey, cntrKey, syncKey);
            byte[] resp = null;
            Map<String, String> headerMap = ConfigFile.configMap.get(appkey).getOPEN_HEADER();
            log.info("\u8bf7\u6c42\u62a5\u6587\u5bc6\u6587\uff1a" + new String(reqJson, "UTF-8"));
            resp = OpenFileService.postFile(appkey, SERVICE_BIG_FILE_UPLOAD, reqJson, file, head, headerMap);
            log.info("\u54cd\u5e94\u62a5\u6587\u5bc6\u6587\uff1a" + new String(resp, "UTF-8"));
            String respStr = new String(resp, "UTF-8");
            if (!ApproveDevService.IsCliperText(respStr)) {
                return respStr;
            }
            if (OpenSDK.containsRetCode(respStr)) {
                return respStr;
            }
            Map<String, Object> decryMap = CommonSecurityService.decryService(resp, randomKey, cntrKey);
            respValue = (String)decryMap.get("respValue");
            boolean dev = (Boolean)decryMap.get("dev");
            CheckTokenService.refreshToken(dev, appkey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", e);
            }
            if (e instanceof SDKException) {
                respValue = BuildErrorRespService.buildErrorResp((SDKException)e);
            }
            throw e;
        }
        return respValue;
    }

    public static String sendBigFile(String channelNo, String filePath) throws Exception {
        String respValue = "";
        JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
        try {
            String token;
            Map<String, FileUploadRequest> requestMap = OpenFileService.getFileUploadRequest(channelNo, filePath);
            String json = jsonHelper.toJSONString(requestMap);
            File file = new File(filePath);
            Map<String, Object> localMap = KeyStoreFactory.getInstance().getTokenMap();
            if (localMap == null || localMap.size() <= 0) {
                localMap = OpenSDK.approveDev();
            }
            if (null == (token = String.valueOf(localMap.get("APP_Token"))) || "".equals(token)) {
                localMap = OpenSDK.approveDev();
                token = String.valueOf(localMap.get("APP_Token"));
            }
            String expirein = String.valueOf(localMap.get("expirein"));
            String updatetime = String.valueOf(localMap.get("updatetime"));
            if (!KeyStoreFactory.getInstance().checkTokenVaild(expirein, updatetime)) {
                localMap = OpenSDK.approveDev();
                token = String.valueOf(localMap.get("APP_Token"));
            }
            if (!"000000".equalsIgnoreCase(localMap.get("Txn_Rsp_Cd_Dsc") + "") || !"000000".equalsIgnoreCase(localMap.get("SYS_RESP_CODE") + "")) {
                return BuildErrorRespService.buildErrorResp(OpenSDK.objToStr(localMap.get("SYS_RESP_CODE")), OpenSDK.objToStr(localMap.get("SYS_RESP_DESC")));
            }
            byte[] cntrKey = (byte[])localMap.get("CntrKey");
            byte[] syncKey = (byte[])localMap.get("SyncKey");
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByJson("", json, token);
            json = CoverHeadService.cover(head, json);
            byte[] reqJson = CommonSecurityService.encryService(json, randomKey, cntrKey, syncKey);
            byte[] resp = null;
            log.info("\u8bf7\u6c42\u62a5\u6587\u5bc6\u6587\uff1a" + new String(reqJson, "UTF-8"));
            resp = OpenFileService.postFile(null, SERVICE_BIG_FILE_UPLOAD, reqJson, file, head, null);
            log.info("\u54cd\u5e94\u62a5\u6587\u5bc6\u6587\uff1a" + new String(resp, "UTF-8"));
            String respStr = new String(resp, "UTF-8");
            if (!ApproveDevService.IsCliperText(respStr)) {
                return respStr;
            }
            if (OpenSDK.containsRetCode(respStr)) {
                return respStr;
            }
            Map<String, Object> decryMap = CommonSecurityService.decryService(resp, randomKey, cntrKey);
            respValue = (String)decryMap.get("respValue");
            boolean dev = (Boolean)decryMap.get("dev");
            CheckTokenService.refreshToken(dev);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", e);
            }
            if (e instanceof SDKException) {
                respValue = BuildErrorRespService.buildErrorResp((SDKException)e);
            }
            throw e;
        }
        return respValue;
    }

    public static String sendBigFileDownload(String appkey, String channelNo, String fileId, String dirPath) throws Exception {
        String respValue = "";
        try {
            String token;
            String json = OpenSDK.getFileDownloadRequest(fileId, channelNo);
            Map<String, Object> localMap = ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getTokenMap();
            if (localMap == null || localMap.size() <= 0) {
                localMap = OpenSDK.approveDev(appkey);
            }
            if (null == (token = String.valueOf(localMap.get("APP_Token"))) || "".equals(token)) {
                localMap = OpenSDK.approveDev(appkey);
                token = String.valueOf(localMap.get("APP_Token"));
            }
            String expirein = String.valueOf(localMap.get("expirein"));
            String updatetime = String.valueOf(localMap.get("updatetime"));
            if (!KeyStoreFactory.getInstance().checkTokenVaild(expirein, updatetime)) {
                localMap = OpenSDK.approveDev(appkey);
                token = String.valueOf(localMap.get("APP_Token"));
            }
            if (!"000000".equalsIgnoreCase(localMap.get("Txn_Rsp_Cd_Dsc") + "") || !"000000".equalsIgnoreCase(localMap.get("SYS_RESP_CODE") + "")) {
                return BuildErrorRespService.buildErrorResp(OpenSDK.objToStr(localMap.get("SYS_RESP_CODE")), OpenSDK.objToStr(localMap.get("SYS_RESP_DESC")));
            }
            byte[] cntrKey = (byte[])localMap.get("CntrKey");
            byte[] syncKey = (byte[])localMap.get("SyncKey");
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByJson(appkey, "", json, token);
            json = CoverHeadService.cover(head, json);
            byte[] reqJson = CommonSecurityService.encryService(json, randomKey, cntrKey, syncKey);
            byte[] resp = null;
            Map<String, String> headerMap = ConfigFile.configMap.get(appkey).getOPEN_HEADER();
            log.info("\u8bf7\u6c42\u62a5\u6587\u5bc6\u6587\uff1a" + new String(reqJson, "UTF-8"));
            resp = OpenFileService.postDownFile(appkey, SERVICE_BIG_FILE_DOWNLOAD, reqJson, dirPath, head, headerMap, randomKey);
            log.info("\u54cd\u5e94\u62a5\u6587\u5bc6\u6587\uff1a" + new String(resp, "UTF-8"));
            String respStr = new String(resp, "UTF-8");
            if (!ApproveDevService.IsCliperText(respStr)) {
                return respStr;
            }
            if (OpenSDK.containsRetCode(respStr)) {
                return respStr;
            }
            Map<String, Object> decryMap = CommonSecurityService.decryService(resp, randomKey, cntrKey);
            respValue = (String)decryMap.get("respValue");
            boolean dev = (Boolean)decryMap.get("dev");
            CheckTokenService.refreshToken(dev, appkey);
            OpenFileService.handleFileDowloadRes(new String(randomKey, "utf-8"), dirPath, respValue);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", e);
            }
            if (e instanceof SDKException) {
                respValue = BuildErrorRespService.buildErrorResp((SDKException)e);
            }
            throw e;
        }
        return respValue;
    }

    public static String sendBigFileDownload(String channelNo, String fileId, String dirPath) throws Exception {
        String respValue = "";
        try {
            String token;
            String json = OpenSDK.getFileDownloadRequest(fileId, channelNo);
            Map<String, Object> localMap = KeyStoreFactory.getInstance().getTokenMap();
            if (localMap == null || localMap.size() <= 0) {
                localMap = OpenSDK.approveDev();
            }
            if (null == (token = String.valueOf(localMap.get("APP_Token"))) || "".equals(token)) {
                localMap = OpenSDK.approveDev();
                token = String.valueOf(localMap.get("APP_Token"));
            }
            String expirein = String.valueOf(localMap.get("expirein"));
            String updatetime = String.valueOf(localMap.get("updatetime"));
            if (!KeyStoreFactory.getInstance().checkTokenVaild(expirein, updatetime)) {
                localMap = OpenSDK.approveDev();
                token = String.valueOf(localMap.get("APP_Token"));
            }
            if (!"000000".equalsIgnoreCase(localMap.get("Txn_Rsp_Cd_Dsc") + "") || !"000000".equalsIgnoreCase(localMap.get("SYS_RESP_CODE") + "")) {
                return BuildErrorRespService.buildErrorResp(OpenSDK.objToStr(localMap.get("SYS_RESP_CODE")), OpenSDK.objToStr(localMap.get("SYS_RESP_DESC")));
            }
            byte[] cntrKey = (byte[])localMap.get("CntrKey");
            byte[] syncKey = (byte[])localMap.get("SyncKey");
            byte[] randomKey = RandomKey.getKey(16);
            SDKRequestHead head = PackHeadService.packReqHeadByJson("", json, token);
            json = CoverHeadService.cover(head, json);
            byte[] reqJson = CommonSecurityService.encryService(json, randomKey, cntrKey, syncKey);
            byte[] resp = null;
            log.info("\u8bf7\u6c42\u62a5\u6587\u5bc6\u6587\uff1a" + new String(reqJson, "UTF-8"));
            resp = OpenFileService.postDownFile(null, SERVICE_BIG_FILE_DOWNLOAD, reqJson, dirPath, head, null, randomKey);
            log.info("\u54cd\u5e94\u62a5\u6587\u5bc6\u6587\uff1a" + new String(resp, "UTF-8"));
            String respStr = new String(resp, "UTF-8");
            if (!ApproveDevService.IsCliperText(respStr)) {
                return respStr;
            }
            if (OpenSDK.containsRetCode(respStr)) {
                return respStr;
            }
            Map<String, Object> decryMap = CommonSecurityService.decryService(resp, randomKey, cntrKey);
            respValue = (String)decryMap.get("respValue");
            boolean dev = (Boolean)decryMap.get("dev");
            CheckTokenService.refreshToken(dev);
            OpenFileService.handleFileDowloadRes(new String(randomKey, "utf-8"), dirPath, respValue);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", e);
            }
            if (e instanceof SDKException) {
                respValue = BuildErrorRespService.buildErrorResp((SDKException)e);
            }
            throw e;
        }
        return respValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleFileDowloadRes(String randomKeyStr, String dirPath, String res) throws Exception {
        String localFilePath = dirPath + File.separator + randomKeyStr + "_tmp";
        JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
        try {
            FileResponse resJson = jsonHelper.parseObject(res, FileResponse.class);
            FileDownloadResponse fileDownloadResponse = resJson.getData();
            if (!"0000".equals(fileDownloadResponse.getRetCode())) {
                return;
            }
            if (dirPath == null) {
                return;
            }
            String nSign = SM3Utils.encryptStr(new File(localFilePath));
            if (!nSign.equals(fileDownloadResponse.getData().getSign())) {
                throw new SDKException(SDKExceptionEnums.FILE_SIGN_ERROR);
            }
            String originalFilename = fileDownloadResponse.getData().getOriginalFilename();
            File dirFile = new File(dirPath);
            if (dirFile.isFile()) {
                throw new RuntimeException("dirPath\u5fc5\u987b\u4e3a\u76ee\u5f55");
            }
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            new File(localFilePath).renameTo(new File(dirPath + File.separator + originalFilename));
        }
        finally {
            File f = new File(localFilePath);
            if (f.exists()) {
                f.delete();
            }
        }
    }

    private static Map<String, FileUploadRequest> getFileUploadRequest(String channelNo, String filename) throws Exception {
        if (null == filename || !filename.contains(".")) {
            throw new IllegalArgumentException("filename \u4e0d\u5408\u6cd5;");
        }
        if (channelNo == null || channelNo.trim().length() == 0) {
            throw new IllegalArgumentException("channelNo \u4e0d\u5408\u6cd5;");
        }
        File file = new File(filename);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("%s \u6587\u4ef6\u4e0d\u5b58\u5728", filename));
        }
        int index = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
        index = index >= 0 ? index + 1 : 0;
        filename = filename.substring(index);
        long fileLength = file.length();
        String sign = SM3Utils.encryptStr(file);
        HashMap<String, FileUploadRequest> map = new HashMap<String, FileUploadRequest>();
        map.put("Data", FileUploadRequest.builder().filename(filename).channelNo(channelNo).fileLength(fileLength).sign(sign).build());
        return map;
    }

    private static byte[] postFile(String appkey, String urlStr, byte[] reqJson, File file, SDKRequestHead head, Map<String, String> header) throws Exception {
        urlStr = appkey == null ? ConfigFile.MPUBLICURL + "/" + urlStr : ConfigFile.configMap.get(appkey).getMPUBLICURL() + "/" + urlStr;
        if (log.isDebugEnabled()) {
            log.debug("url=[" + urlStr + "]");
            log.debug("\u8bf7\u6c42\u62a5\u6587=[" + new String(reqJson) + "]");
        }
        URLConnectionAdapter urlConnectionAdapter = null;
        byte[] resultData = null;
        OutputStream OutputStream2 = null;
        InputStream inputStream = null;
        FileInputStream fileInputStream = null;
        try {
            int length;
            URL url = new URL(urlStr);
            URLConnection urlConnection = url.openConnection();
            urlConnectionAdapter = new URLConnectionAdapter(urlStr, urlConnection);
            OpenFileService.addRequestHead(urlStr, head, urlConnectionAdapter, header);
            urlConnectionAdapter.addRequestProperty("fileLength", String.valueOf(file.length()));
            urlConnection.connect();
            OutputStream2 = urlConnection.getOutputStream();
            byte[] reqArr = new byte[4096];
            System.arraycopy(reqJson, 0, reqArr, 0, reqJson.length);
            OutputStream2.write(reqArr);
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            while ((length = fileInputStream.read(buffer)) != -1) {
                OutputStream2.write(buffer, 0, length);
                OutputStream2.flush();
            }
            int code = urlConnectionAdapter.getResponseCode();
            inputStream = urlConnectionAdapter.getInputStream();
            resultData = OpenFileService.getResponse(inputStream);
            if (200 != code) {
                if (log.isErrorEnabled()) {
                    log.error("HTTP \u54cd\u5e94\u5f02\u5e38 ,ResponseCode=[" + code + "]");
                }
                throw new SDKException(SDKExceptionEnums.HTTPCONN_ERROR);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u54cd\u5e94\u62a5\u6587=[" + new String(resultData) + "]");
            }
        }
        catch (Exception e) {
            if (e instanceof SDKException) {
                throw e;
            }
            if (log.isErrorEnabled()) {
                log.error("\u901a\u8baf\u6a21\u5757\u5f02\u5e38,\u901a\u8baf\u5730\u5740=[" + urlStr + "]", e);
            }
            throw new SDKException(SDKExceptionEnums.POST_ERROR);
        }
        finally {
            block31: {
                block30: {
                    block29: {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException e) {
                                if (!log.isErrorEnabled()) break block29;
                                log.error("\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u5f02\u5e38", e);
                            }
                        }
                    }
                    if (OutputStream2 != null) {
                        try {
                            OutputStream2.close();
                        }
                        catch (IOException e) {
                            if (!log.isErrorEnabled()) break block30;
                            log.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", e);
                        }
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block31;
                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38", e);
                    }
                }
            }
            if (urlConnectionAdapter != null) {
                urlConnectionAdapter.disconnect();
            }
        }
        return resultData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] postDownFile(String appkey, String urlStr, byte[] reqJson, String dirPath, SDKRequestHead head, Map<String, String> header, byte[] randomKey) throws Exception {
        byte[] byArray;
        RandomAccessFile tmpAccessFile;
        RandomAccessFile randomAccessFile;
        String localFilePath;
        URLConnectionAdapter urlConnectionAdapter;
        block38: {
            InputStream inputStream;
            block37: {
                OutputStream OutputStream2;
                block33: {
                    urlStr = appkey == null ? ConfigFile.MPUBLICURL + "/" + urlStr : ConfigFile.configMap.get(appkey).getMPUBLICURL() + "/" + urlStr;
                    if (log.isDebugEnabled()) {
                        log.debug("url=[" + urlStr + "]");
                        log.debug("\u8bf7\u6c42\u62a5\u6587=[" + new String(reqJson) + "]");
                    }
                    urlConnectionAdapter = null;
                    OutputStream2 = null;
                    inputStream = null;
                    FileInputStream fileInputStream = null;
                    localFilePath = dirPath + File.separator + new String(randomKey, "utf-8");
                    randomAccessFile = null;
                    tmpAccessFile = null;
                    try {
                        URL url = new URL(urlStr);
                        URLConnection urlConnection = url.openConnection();
                        urlConnectionAdapter = new URLConnectionAdapter(urlStr, urlConnection);
                        OpenFileService.addRequestHead(urlStr, head, urlConnectionAdapter, header);
                        urlConnection.connect();
                        OutputStream2 = urlConnection.getOutputStream();
                        OutputStream2.write(reqJson);
                        OutputStream2.flush();
                        int code = urlConnectionAdapter.getResponseCode();
                        inputStream = urlConnectionAdapter.getInputStream();
                        byte[] orginalRespArr = new byte[4096];
                        File dirFile = new File(dirPath);
                        if (dirFile.isFile()) {
                            throw new RuntimeException("dirPath\u5fc5\u987b\u4e3a\u76ee\u5f55");
                        }
                        if (!dirFile.exists()) {
                            dirFile.mkdirs();
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(localFilePath);
                        FileUtils.copy(inputStream, fileOutputStream);
                        if (200 != code) {
                            if (log.isErrorEnabled()) {
                                log.error("HTTP \u54cd\u5e94\u5f02\u5e38 ,ResponseCode=[" + code + "]");
                            }
                            throw new SDKException(SDKExceptionEnums.HTTPCONN_ERROR);
                        }
                        randomAccessFile = new RandomAccessFile(localFilePath, "rw");
                        randomAccessFile.read(orginalRespArr);
                        byte[] respByteArr = OpenFileService.removeByteArrNull(orginalRespArr);
                        randomAccessFile.seek(4096L);
                        tmpAccessFile = new RandomAccessFile(localFilePath + "_tmp", "rw");
                        int byteCount = 0;
                        byte[] buffer = new byte[4096];
                        while ((byteCount = randomAccessFile.read(buffer)) != -1) {
                            tmpAccessFile.write(buffer, 0, byteCount);
                        }
                        byArray = respByteArr;
                        if (fileInputStream == null) break block33;
                    }
                    catch (Exception e) {
                        try {
                            if (e instanceof SDKException) {
                                throw e;
                            }
                            if (log.isErrorEnabled()) {
                                log.error("\u901a\u8baf\u6a21\u5757\u5f02\u5e38,\u901a\u8baf\u5730\u5740=[" + urlStr + "]", e);
                            }
                            throw new SDKException(SDKExceptionEnums.POST_ERROR);
                        }
                        catch (Throwable throwable) {
                            block36: {
                                block35: {
                                    block34: {
                                        if (fileInputStream != null) {
                                            try {
                                                fileInputStream.close();
                                            }
                                            catch (IOException e2) {
                                                if (!log.isErrorEnabled()) break block34;
                                                log.error("\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u5f02\u5e38", e2);
                                            }
                                        }
                                    }
                                    if (OutputStream2 != null) {
                                        try {
                                            OutputStream2.close();
                                        }
                                        catch (IOException e3) {
                                            if (!log.isErrorEnabled()) break block35;
                                            log.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", e3);
                                        }
                                    }
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException e4) {
                                        if (!log.isErrorEnabled()) break block36;
                                        log.error("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38", e4);
                                    }
                                }
                            }
                            if (urlConnectionAdapter != null) {
                                urlConnectionAdapter.disconnect();
                            }
                            FileUtils.closeRandomAccessFile(randomAccessFile, tmpAccessFile);
                            if (new File(localFilePath).exists()) {
                                new File(localFilePath).delete();
                            }
                            throw throwable;
                        }
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block33;
                        log.error("\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u5f02\u5e38", e);
                    }
                }
                if (OutputStream2 != null) {
                    try {
                        OutputStream2.close();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block37;
                        log.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", e);
                    }
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block38;
                    log.error("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38", e);
                }
            }
        }
        if (urlConnectionAdapter != null) {
            urlConnectionAdapter.disconnect();
        }
        FileUtils.closeRandomAccessFile(randomAccessFile, tmpAccessFile);
        if (new File(localFilePath).exists()) {
            new File(localFilePath).delete();
        }
        return byArray;
    }

    private static void addRequestHead(String urlStr, SDKRequestHead head, URLConnectionAdapter mConnection, Map<String, String> header) throws Exception {
        mConnection.setDoOutput(true);
        mConnection.setDoInput(true);
        mConnection.setConnectTimeout(ConfigFile.configMap.get(head.getAPP_Key()).getCONNECT_TIMEOUT());
        mConnection.setReadTimeout(ConfigFile.configMap.get(head.getAPP_Key()).getREAD_TIMEOUT());
        mConnection.setRequestMethod("POST");
        mConnection.setUseCaches(false);
        if (header != null && header.size() > 0) {
            for (String key : header.keySet()) {
                mConnection.addRequestProperty(key, header.get(key));
            }
        }
        mConnection.addRequestProperty("APP_Key", head.getAPP_Key());
        mConnection.addRequestProperty("APP_Token", head.getAPP_Token());
        mConnection.addRequestProperty("IP_Adr", head.getIP_Adr());
        mConnection.addRequestProperty("MAC_Adr", head.getMAC_Adr());
        mConnection.addRequestProperty("Content-Type", "application/json");
        mConnection.addRequestProperty("Txn_ModDsc", head.getTxn_ModDsc());
        mConnection.addRequestProperty("URI", urlStr);
    }

    private static byte[] getResponse(InputStream in) throws IOException {
        byte[] rspBytes = null;
        ByteArrayOutputStream outt = new ByteArrayOutputStream();
        int n = 0;
        byte[] val = new byte[1024];
        while ((n = in.read(val)) > 0) {
            outt.write(val, 0, n);
        }
        rspBytes = outt.toByteArray();
        return rspBytes;
    }

    public static byte[] removeByteArrNull(byte[] arr) {
        int nullStartIndex = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != 0 || arr.length <= i + 1 || arr[i + 1] != 0) continue;
            nullStartIndex = i;
            break;
        }
        return OpenFileService.subarray(arr, 0, nullStartIndex);
    }

    public static byte[] subarray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] subarray = new byte[newSize];
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }
}

