/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.utils;

import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.param.ConfigFile;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

public class CertUtil {
    private static Log log = NbczLogger.getLog(CertUtil.class);
    private static String certNo = "";

    private static X509Certificate getX509CerCate(String cerPath) throws Exception {
        X509Certificate x509Certificate = null;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        FileInputStream fileInputStream = new FileInputStream(cerPath);
        x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
        fileInputStream.close();
        return x509Certificate;
    }

    private static Map<String, Object> transStringToMap(String mapString, String separator, String pairSeparator) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] fSplit = mapString.split(separator);
        for (int i = 0; i < fSplit.length; ++i) {
            if (fSplit[i] == null || fSplit[i].length() == 0) continue;
            String[] sSplit = fSplit[i].split(pairSeparator);
            String value = fSplit[i].substring(fSplit[i].indexOf(61) + 1, fSplit[i].length());
            map.put(sSplit[0].trim(), value);
        }
        return map;
    }

    public static String getSubjectCN() throws SDKException {
        if (!"".equals(certNo)) {
            log.debug("certNo : " + certNo);
            return certNo;
        }
        String subjectDN = "";
        try {
            Map<String, Object> map;
            X509Certificate x509Certificate = CertUtil.getX509CerCate(ConfigFile.KEYPATH);
            if (null != x509Certificate) {
                subjectDN = x509Certificate.getSubjectDN().getName();
            }
            if (null != (map = CertUtil.transStringToMap(subjectDN, ",", "="))) {
                certNo = map.get("CN").toString();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bc1\u4e66\u7f16\u53f7\u5931\u8d25");
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
        return certNo;
    }
}

