/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.gm;

import cn.com.infosec.netsign.agent.NetSignAgent;
import com.nbcb.bouncycastle.jce.provider.BouncyCastleProvider;
import com.nbcb.bouncycastle.util.encoders.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyUtils {
    public static String[] generateKey() throws Exception {
        KeyPairGenerator keyPairGenerator = null;
        SecureRandom secureRandom = new SecureRandom();
        ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
        keyPairGenerator = KeyPairGenerator.getInstance("EC", new BouncyCastleProvider());
        keyPairGenerator.initialize(sm2Spec);
        keyPairGenerator.initialize(sm2Spec, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String[] result = new String[]{new String(Base64.encode(privateKey.getEncoded())), new String(Base64.encode(publicKey.getEncoded()))};
        return result;
    }

    public static PublicKey createPublicKey(String publicKey) {
        PublicKey publickey = null;
        try {
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decode(publicKey));
            KeyFactory keyFactory = KeyFactory.getInstance("EC", new BouncyCastleProvider());
            publickey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return publickey;
    }

    public static PrivateKey createPrivateKey(String privateKey) {
        PrivateKey privateKeyUse = null;
        try {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
            KeyFactory keyFactory = KeyFactory.getInstance("EC", new BouncyCastleProvider());
            privateKeyUse = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return privateKeyUse;
    }

    public static X509Certificate getCert() throws IOException {
        int offset;
        File file = new File("./conf/openbank.cer");
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            System.out.println("file too big");
            return null;
        }
        FileInputStream fi = null;
        byte[] buffer = new byte[(int)fileSize];
        fi = new FileInputStream(file);
        int numRead = 0;
        for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        fi.close();
        if (offset != buffer.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        X509Certificate cert = null;
        try {
            cert = NetSignAgent.generateCertificate((byte[])buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cert;
    }
}

