/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class ExceptionUtil {
    public static final String EMPTY = "";

    public static String stacktraceToOneLineString(Throwable throwable) {
        return ExceptionUtil.stacktraceToOneLineString(throwable, 3000);
    }

    public static String stacktraceToOneLineString(Throwable throwable, int limit) {
        HashMap<Character, String> replaceCharToStrMap = new HashMap<Character, String>();
        replaceCharToStrMap.put(Character.valueOf('\r'), " ");
        replaceCharToStrMap.put(Character.valueOf('\n'), " ");
        replaceCharToStrMap.put(Character.valueOf('\t'), " ");
        return ExceptionUtil.stacktraceToString(throwable, limit, replaceCharToStrMap);
    }

    public static String stacktraceToString(Throwable throwable) {
        return ExceptionUtil.stacktraceToString(throwable, 3000);
    }

    public static String stacktraceToString(Throwable throwable, int limit) {
        return ExceptionUtil.stacktraceToString(throwable, limit, null);
    }

    public static String stacktraceToString(Throwable throwable, int limit, Map<Character, String> replaceCharToStrMap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(baos));
        String exceptionStr = baos.toString();
        int length = exceptionStr.length();
        if (limit < 0 || limit > length) {
            limit = length;
        }
        if (ExceptionUtil.isNotEmpty(replaceCharToStrMap)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < limit; ++i) {
                char c = exceptionStr.charAt(i);
                String value = replaceCharToStrMap.get(Character.valueOf(c));
                if (null != value) {
                    sb.append(value);
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        if (limit == length) {
            return exceptionStr;
        }
        return ExceptionUtil.subPre(exceptionStr, limit);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String subPre(CharSequence string, int toIndexExclude) {
        return ExceptionUtil.sub(string, 0, toIndexExclude);
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (ExceptionUtil.isEmpty(str)) {
            return ExceptionUtil.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }
}

