/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj.certutil;

import cn.com.infosec.asn1.x500.X500Name;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.isfj.Config;
import cn.com.infosec.isfj.cryptoutil.SM2AlgoUtil;
import cn.com.infosec.isfj.formatutil.EncodeUtil;
import cn.com.infosec.operator.ContentSigner;
import cn.com.infosec.operator.jcajce.JcaContentSignerBuilder;
import cn.com.infosec.pkcs.PKCS10CertificationRequest;
import cn.com.infosec.pkcs.PKCS10CertificationRequestBuilder;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SM2P10Util {
    public static String genSM2PKCS10CertificationRequest(String[] keyPair, String dn) throws Exception {
        PublicKey pubKey = SM2AlgoUtil.formatPublicKey(EncodeUtil.base64Decode(keyPair[1]));
        PrivateKey prvkey = SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(keyPair[0]));
        PKCS10CertificationRequest p10 = null;
        String sp10 = "";
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(new X500Name(dn), SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded()));
        JcaContentSignerBuilder jcaBuilder = new JcaContentSignerBuilder("SM3withSM2");
        jcaBuilder.setProvider(Config.getProviderName());
        ContentSigner contentSigner = jcaBuilder.build(prvkey);
        p10 = builder.build(contentSigner);
        sp10 = EncodeUtil.base64Encode(p10.getEncoded());
        return sp10;
    }
}

