/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj.certutil;

import cn.com.infosec.isfj.Config;
import cn.com.infosec.isfj.enums.SignAlgorithm;
import cn.com.infosec.isfj.formatutil.EncodeUtil;
import cn.com.infosec.util.FormatBytesUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Signature;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;

public class X509CertificateParser {
    public static X509Certificate certParser(String cert) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(EncodeUtil.base64Decode(cert));
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", Config.getProviderName());
        X509Certificate X509Cert = (X509Certificate)certificateFactory.generateCertificate(in);
        ((InputStream)in).close();
        return X509Cert;
    }

    public static String getIssuerDN(String certificate) throws Exception {
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        return cert.getIssuerDN().getName();
    }

    public static String getSigAlgName(String certificate) throws Exception {
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        return cert.getSigAlgName();
    }

    public static Date getBeginTime(String certificate) throws Exception {
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        return cert.getNotBefore();
    }

    public static Date getEndTime(String certificate) throws Exception {
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        return cert.getNotAfter();
    }

    public static String getSerialNumber(String certificate) throws Exception {
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        return FormatBytesUtil.bytesToHexString((byte[])cert.getSerialNumber().toByteArray());
    }

    public static String getCertDN(String certificate) throws Exception {
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        return cert.getSubjectDN().getName();
    }

    public static String getCertCN(String certificate) throws Exception {
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        String certDNName = cert.getSubjectDN().getName();
        String[] tmpArray = certDNName.split(",");
        String certCN = "";
        int i = 0;
        for (i = 0; i < tmpArray.length; ++i) {
            tmpArray[i] = tmpArray[i].trim();
            if (!tmpArray[i].startsWith("CN") && !tmpArray[i].startsWith("cn")) continue;
            certCN = tmpArray[i];
            break;
        }
        if (i == tmpArray.length) {
            return null;
        }
        String[] CNarray = certCN.split("=", 2);
        return CNarray[1];
    }

    public static boolean checkValidity(String certificate) throws Exception {
        boolean valid = false;
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        try {
            cert.checkValidity();
            valid = true;
        }
        catch (CertificateExpiredException e) {
            valid = false;
        }
        return valid;
    }

    public static boolean verifyCertChain(String lowerCertificate, String upperCertificate) throws Exception {
        boolean pass = false;
        X509Certificate lowerCert = X509CertificateParser.certParser(lowerCertificate);
        X509Certificate upperCert = X509CertificateParser.certParser(upperCertificate);
        try {
            lowerCert.verify(upperCert.getPublicKey());
            pass = true;
        }
        catch (Exception e) {
            pass = false;
        }
        return pass;
    }

    public static boolean verifySignature(String certificate, String tbsign, String signature, SignAlgorithm algo) throws Exception {
        X509Certificate cert = X509CertificateParser.certParser(certificate);
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new RuntimeException("Certificate Expired", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new RuntimeException("Certificate is Not Yet Valid", e);
        }
        Signature sign = Signature.getInstance(algo.getValue(), Config.getProviderName());
        sign.initVerify(cert);
        sign.update(EncodeUtil.base64Decode(tbsign));
        return sign.verify(EncodeUtil.base64Decode(signature));
    }
}

