/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj.cryptoutil;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.cert.X509CertificateHolder;
import cn.com.infosec.cert.jcajce.JcaCertStore;
import cn.com.infosec.cms.CMSAlgorithm;
import cn.com.infosec.cms.CMSEnvelopedData;
import cn.com.infosec.cms.CMSEnvelopedDataGenerator;
import cn.com.infosec.cms.CMSProcessable;
import cn.com.infosec.cms.CMSProcessableByteArray;
import cn.com.infosec.cms.CMSSignedData;
import cn.com.infosec.cms.CMSSignedDataGenerator;
import cn.com.infosec.cms.CMSTypedData;
import cn.com.infosec.cms.Recipient;
import cn.com.infosec.cms.RecipientInfoGenerator;
import cn.com.infosec.cms.RecipientInformation;
import cn.com.infosec.cms.RecipientInformationStore;
import cn.com.infosec.cms.SignerInformation;
import cn.com.infosec.cms.SignerInformationStore;
import cn.com.infosec.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import cn.com.infosec.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import cn.com.infosec.cms.jcajce.JceCMSContentEncryptorBuilder;
import cn.com.infosec.cms.jcajce.JceKeyTransEnvelopedRecipient;
import cn.com.infosec.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import cn.com.infosec.isfj.Config;
import cn.com.infosec.isfj.certutil.X509CertificateParser;
import cn.com.infosec.isfj.enums.BlockCipherModeEnum;
import cn.com.infosec.isfj.enums.HashAlgorithm;
import cn.com.infosec.isfj.enums.PaddingMethodEnum;
import cn.com.infosec.isfj.enums.SymmetricAlgorithm;
import cn.com.infosec.isfj.formatutil.EncodeUtil;
import cn.com.infosec.operator.ContentSigner;
import cn.com.infosec.operator.jcajce.JcaContentSignerBuilder;
import cn.com.infosec.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cn.com.infosec.util.Selector;
import cn.com.infosec.util.Store;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;

public class RSAAlgoUtil {
    protected static final Map CIPHER_ALG_NAMES = new HashMap();
    private static String RSA;
    private static String PROVIDER;

    public static String[] genRSAKeyPair(int keySize) {
        KeyPair kp = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(RSA, PROVIDER);
            kpg.initialize(keySize);
            kp = kpg.genKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return new String[]{EncodeUtil.base64Encode(kp.getPrivate().getEncoded()), EncodeUtil.base64Encode(kp.getPublic().getEncoded())};
    }

    public static String rsaEncrypt(String pub, String tbEnc, PaddingMethodEnum pm) throws Exception {
        if (!pm.getValue().equalsIgnoreCase(PaddingMethodEnum.NoPadding.getValue()) && !pm.getValue().equalsIgnoreCase(PaddingMethodEnum.PKCS1Padding.getValue())) {
            throw new RuntimeException((Object)((Object)pm) + " not support");
        }
        String transformation = RSA + "/" + (Object)((Object)BlockCipherModeEnum.ECB) + "/" + pm.getValue();
        PublicKey pubKey = RSAAlgoUtil.formatPublicKey(EncodeUtil.base64Decode(pub));
        Cipher cipher = Cipher.getInstance(transformation, PROVIDER);
        cipher.init(1, pubKey);
        byte[] tTemp = cipher.doFinal(EncodeUtil.base64Decode(tbEnc));
        return EncodeUtil.base64Encode(tTemp);
    }

    public static String rsaDecrypt(String prv, String tbDec, PaddingMethodEnum pm) throws Exception {
        if (!pm.getValue().equalsIgnoreCase(PaddingMethodEnum.NoPadding.getValue()) && !pm.getValue().equalsIgnoreCase(PaddingMethodEnum.PKCS1Padding.getValue())) {
            throw new RuntimeException((Object)((Object)pm) + " not support");
        }
        String transformation = RSA + "/" + (Object)((Object)BlockCipherModeEnum.ECB) + "/" + pm.getValue();
        PrivateKey prvKey = RSAAlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(prv));
        Cipher cipher = Cipher.getInstance(transformation, PROVIDER);
        cipher.init(2, prvKey);
        byte[] tTemp = cipher.doFinal(EncodeUtil.base64Decode(tbDec));
        return EncodeUtil.base64Encode(tTemp);
    }

    public static String rsaRawSign(String priKey, String tbsign, HashAlgorithm algo) throws Exception {
        if (!algo.getValue().startsWith("SHA")) {
            throw new RuntimeException(algo.getValue() + " not support");
        }
        String transformation = algo.getValue() + "with" + RSA;
        PrivateKey key = RSAAlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(priKey));
        Signature sign = Signature.getInstance(transformation, PROVIDER);
        sign.initSign(key);
        sign.update(EncodeUtil.base64Decode(tbsign));
        return EncodeUtil.base64Encode(sign.sign());
    }

    public static boolean rsaRawVerify(String pub, String tbs, String signature, HashAlgorithm algo) throws Exception {
        if (!algo.getValue().startsWith("SHA")) {
            throw new RuntimeException(algo.getValue() + " not support");
        }
        String transformation = algo.getValue() + "with" + RSA;
        PublicKey pubKey = RSAAlgoUtil.formatPublicKey(EncodeUtil.base64Decode(pub));
        Signature sign = Signature.getInstance(transformation, PROVIDER);
        sign.initVerify(pubKey);
        sign.update(EncodeUtil.base64Decode(tbs));
        return sign.verify(EncodeUtil.base64Decode(signature));
    }

    public static String rsaSignMessage(String priKey, String tbsign, String cert, HashAlgorithm algo, boolean attach) throws Exception {
        if (tbsign == null || tbsign.isEmpty()) {
            throw new RuntimeException("tbsign can not be null");
        }
        if (!algo.getValue().startsWith("SHA")) {
            throw new RuntimeException(algo.getValue() + " not support");
        }
        String transformation = algo.getValue() + "with" + RSA;
        PrivateKey key = RSAAlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(priKey));
        CMSProcessableByteArray msg = new CMSProcessableByteArray(EncodeUtil.base64Decode(tbsign));
        X509Certificate cerx509 = X509CertificateParser.certParser(cert);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(cerx509);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner rsaSigner = new JcaContentSignerBuilder(transformation).setProvider(PROVIDER).build(key);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(PROVIDER).build()).build(rsaSigner, cerx509));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, attach);
        return EncodeUtil.base64Encode(sigData.getEncoded());
    }

    public static boolean rsaVerifyMessage(String signedData, String tbsign, boolean attach) throws Exception {
        boolean verifyRet = true;
        try {
            CMSSignedData sign = null;
            if (attach) {
                sign = new CMSSignedData(EncodeUtil.base64Decode(signedData));
            } else {
                CMSProcessableByteArray msg = new CMSProcessableByteArray(EncodeUtil.base64Decode(tbsign));
                sign = new CMSSignedData((CMSProcessable)msg, EncodeUtil.base64Decode(signedData));
            }
            Store certs = sign.getCertificates();
            SignerInformationStore signers = sign.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                Collection certCollection = certs.getMatches((Selector)signer.getSID());
                Iterator certIt = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(PROVIDER).build(cert))) {
                    verifyRet = true;
                    continue;
                }
                verifyRet = false;
            }
        }
        catch (Exception e) {
            verifyRet = false;
            throw new RuntimeException(e);
        }
        return verifyRet;
    }

    public static String rsaEnvelopeMessage(String srcMsg, String cert, SymmetricAlgorithm symmAlgo) throws Exception {
        X509Certificate cerx509 = X509CertificateParser.certParser(cert);
        String publickeyAlg = cerx509.getPublicKey().getAlgorithm();
        if (!publickeyAlg.equalsIgnoreCase("RSA")) {
            throw new RuntimeException("the algorithm" + publickeyAlg + "not support");
        }
        CMSProcessableByteArray msg = new CMSProcessableByteArray(EncodeUtil.base64Decode(srcMsg));
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cerx509).setProvider(PROVIDER));
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)CIPHER_ALG_NAMES.get(symmAlgo.getValue());
        CMSEnvelopedData ed = edGen.generate((CMSTypedData)msg, new JceCMSContentEncryptorBuilder(oid).setProvider(PROVIDER).build());
        return EncodeUtil.base64Encode(ed.getEncoded());
    }

    public static String rsaOpenEnvelope(String envelopedData, String prvKey) throws Exception {
        CMSEnvelopedData ed = new CMSEnvelopedData(EncodeUtil.base64Decode(envelopedData));
        RecipientInformationStore recipients = ed.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        PrivateKey key = RSAAlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(prvKey));
        byte[] recData = null;
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            recData = recipient.getContent((Recipient)new JceKeyTransEnvelopedRecipient(key).setProvider(PROVIDER));
        }
        return EncodeUtil.base64Encode(recData);
    }

    public static PrivateKey formatPrivateKey(byte[] priKey) throws Exception {
        return KeyFactory.getInstance(RSA, PROVIDER).generatePrivate(new PKCS8EncodedKeySpec(priKey));
    }

    public static PublicKey formatPublicKey(byte[] pub) throws Exception {
        return KeyFactory.getInstance(RSA, PROVIDER).generatePublic(new X509EncodedKeySpec(pub));
    }

    static {
        CIPHER_ALG_NAMES.put("SM4", CMSAlgorithm.SM4_CBC);
        CIPHER_ALG_NAMES.put("DES", CMSAlgorithm.DES_CBC);
        CIPHER_ALG_NAMES.put("DESEDE", CMSAlgorithm.DES_EDE3_CBC);
        CIPHER_ALG_NAMES.put("AES", CMSAlgorithm.AES128_CBC);
        CIPHER_ALG_NAMES.put("RC4", PKCSObjectIdentifiers.rc4);
        RSA = "RSA";
        PROVIDER = Config.getProviderName();
    }
}

