/*
 * Decompiled with CFR 0.152.
 */
import cn.win_trust_erpc.SM3HMac;
import cn.win_trust_erpc.SM4;
import cn.win_trust_erpc.SM4_Context;
import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.bouncycastle.crypto.BlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.BufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SM3Digest;
import cn.win_trust_erpc.bouncycastle.crypto.engines.SM4Engine;
import cn.win_trust_erpc.bouncycastle.crypto.macs.HMac;
import cn.win_trust_erpc.bouncycastle.crypto.modes.CBCBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.paddings.PKCS7Padding;
import cn.win_trust_erpc.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithIV;

public class TimeTest {
    public static byte[] HMacSM3(byte[] text, byte[] key) {
        byte[] res = new byte[32];
        HMac hmac = new HMac(new SM3Digest());
        hmac.init(new KeyParameter(key));
        hmac.update(text, 0, text.length);
        hmac.doFinal(res, 0);
        return res;
    }

    public static void main(String[] args) throws Exception {
        byte[] input = new byte[0x100000];
        byte[] key = new byte[16];
        key[0] = 97;
        key[1] = 98;
        key[2] = 99;
        key[3] = 100;
        key[4] = 101;
        key[5] = 102;
        long now = 0L;
        long before = 0L;
        long used = 0L;
        now = System.currentTimeMillis();
        used = now - before;
        before = now;
        System.out.println(Util.byteToHex(SM3HMac.SM3HashMac(input, key)));
        now = System.currentTimeMillis();
        used = now - before;
        before = now;
        System.out.println(used);
        System.out.println(Util.byteToHex(TimeTest.HMacSM3(input, key)));
        now = System.currentTimeMillis();
        used = now - before;
        before = now;
        System.out.println(used);
        int ii = 0;
        while (ii < 100) {
            TimeTest.SM4Test1(true, new byte[10240]);
            ++ii;
        }
        now = System.currentTimeMillis();
        used = now - before;
        before = now;
        System.out.println(used);
        ii = 0;
        while (ii < 100) {
            TimeTest.SM4Test2(true, new byte[10240]);
            ++ii;
        }
        now = System.currentTimeMillis();
        byte[] cipher = TimeTest.SM4Crypt(new byte[16], new byte[16], true, true, new byte[31]);
        byte[] plain = TimeTest.SM4Crypt(new byte[16], new byte[16], false, true, cipher);
        used = now - before;
        before = now;
        System.out.println(used);
    }

    public static byte[] SM4Test1(boolean useCBC, byte[] plainData) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        byte[] tmpIV = new byte[16];
        byte[] tmpKEY = new byte[16];
        sm4.sm4_setkey_enc(ctx, tmpKEY);
        cipher = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, plainData) : sm4.sm4_crypt_ecb(ctx, plainData);
        return cipher;
    }

    public static byte[] SM4Test2(boolean useCBC, byte[] plainData) throws Exception {
        BlockCipher blockCipher = null;
        PaddedBufferedBlockCipher bufferedBlockCipher = null;
        byte[] tmpIV = new byte[16];
        byte[] tmpKEY = new byte[16];
        if (useCBC) {
            blockCipher = new CBCBlockCipher(new SM4Engine());
            bufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
            ((BufferedBlockCipher)bufferedBlockCipher).init(true, new ParametersWithIV(new KeyParameter(tmpKEY), tmpIV));
        } else {
            blockCipher = new SM4Engine();
            bufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
            ((BufferedBlockCipher)bufferedBlockCipher).init(true, new KeyParameter(tmpKEY));
        }
        byte[] output = new byte[((BufferedBlockCipher)bufferedBlockCipher).getOutputSize(plainData.length)];
        int processed = ((BufferedBlockCipher)bufferedBlockCipher).processBytes(plainData, 0, plainData.length, output, 0);
        ((BufferedBlockCipher)bufferedBlockCipher).doFinal(output, processed);
        return output;
    }

    public static byte[] SM4Crypt(byte[] key, byte[] iv, boolean encrypt, boolean useCBC, byte[] input) throws Exception {
        BlockCipher blockCipher = null;
        PaddedBufferedBlockCipher bufferedBlockCipher = null;
        if (useCBC) {
            blockCipher = new CBCBlockCipher(new SM4Engine());
            bufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
            ((BufferedBlockCipher)bufferedBlockCipher).init(encrypt, new ParametersWithIV(new KeyParameter(key), iv));
        } else {
            blockCipher = new SM4Engine();
            bufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
            ((BufferedBlockCipher)bufferedBlockCipher).init(encrypt, new KeyParameter(key));
        }
        byte[] output = new byte[((BufferedBlockCipher)bufferedBlockCipher).getOutputSize(input.length)];
        int processed = ((BufferedBlockCipher)bufferedBlockCipher).processBytes(input, 0, input.length, output, 0);
        int finaled = ((BufferedBlockCipher)bufferedBlockCipher).doFinal(output, processed);
        byte[] res = new byte[processed + finaled];
        System.arraycopy(output, 0, res, 0, res.length);
        return res;
    }
}

