/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Certificate;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.crypto.DataLengthException;
import cn.win_trust_erpc.bouncycastle.crypto.Signer;
import cn.win_trust_erpc.bouncycastle.crypto.digests.MD5Digest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA1Digest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA224Digest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA256Digest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA384Digest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA512Digest;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.signers.RSADigestSigner;
import cn.win_trust_erpc.bouncycastle.crypto.signers.SM2Signer;
import cn.win_trust_erpc.bouncycastle.crypto.util.PublicKeyFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CertVerifyUtil {
    public static final ASN1ObjectIdentifier sm2SignWithSM3 = new ASN1ObjectIdentifier("1.2.156.10197.1.501");

    public static Certificate[] MakeExternCertificateChain(String[] certHexArray) {
        ArrayList<byte[]> list = new ArrayList<byte[]>(certHexArray.length);
        int i = 0;
        while (i < certHexArray.length) {
            list.add(Util.hexStringToBytes(certHexArray[i]));
            ++i;
        }
        return CertVerifyUtil.MakeExternCertificateChain(list);
    }

    public static Certificate[] MakeExternCertificateChain(List<byte[]> certByteArray) {
        Certificate[] certificateList = new Certificate[certByteArray.size()];
        int i = 0;
        while (i < certificateList.length) {
            certificateList[i] = Certificate.getInstance(certByteArray.get(i));
            ++i;
        }
        return certificateList;
    }

    public static boolean isValidParent(Certificate cert, Certificate ca) {
        byte[] sigature;
        AsymmetricKeyParameter publicKey;
        Signer signer;
        byte[] tbs;
        boolean isValid;
        block11: {
            isValid = false;
            tbs = cert.getTBSCertificate().getEncoded();
            signer = null;
            SubjectPublicKeyInfo keyInfo = ca.getSubjectPublicKeyInfo();
            publicKey = PublicKeyFactory.createKey(keyInfo);
            sigature = cert.getSignature().getBytes();
            AlgorithmIdentifier algID = cert.getSignatureAlgorithm();
            AlgorithmIdentifier caAlgID = ca.getSignatureAlgorithm();
            if (caAlgID.getAlgorithm().equals(sm2SignWithSM3)) {
                signer = new SM2Signer();
                break block11;
            }
            if (algID.getAlgorithm().equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
                signer = new RSADigestSigner(new MD5Digest());
                break block11;
            }
            if (algID.getAlgorithm().equals(PKCSObjectIdentifiers.sha1WithRSAEncryption)) {
                signer = new RSADigestSigner(new SHA1Digest());
                break block11;
            }
            if (algID.getAlgorithm().equals(PKCSObjectIdentifiers.sha256WithRSAEncryption)) {
                signer = new RSADigestSigner(new SHA256Digest());
                break block11;
            }
            if (algID.getAlgorithm().equals(PKCSObjectIdentifiers.sha224WithRSAEncryption)) {
                signer = new RSADigestSigner(new SHA224Digest());
                break block11;
            }
            if (algID.getAlgorithm().equals(PKCSObjectIdentifiers.sha384WithRSAEncryption)) {
                signer = new RSADigestSigner(new SHA384Digest());
                break block11;
            }
            if (algID.getAlgorithm().equals(PKCSObjectIdentifiers.sha512WithRSAEncryption)) {
                signer = new RSADigestSigner(new SHA512Digest());
                break block11;
            }
            return false;
        }
        try {
            signer.init(false, publicKey);
            signer.update(tbs, 0, tbs.length);
            isValid = signer.verifySignature(sigature);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataLengthException e) {
            e.printStackTrace();
        }
        return isValid;
    }

    public static boolean isValidRoot(Certificate cert) {
        return CertVerifyUtil.isValidParent(cert, cert);
    }

    public static Certificate getParentCertificate(Certificate cert, Certificate[] certs) throws IOException {
        int i = 0;
        while (i < certs.length) {
            if (CertVerifyUtil.isValidParent(cert, certs[i])) {
                return certs[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isValid(Certificate[] certs, Certificate[] initedCertChain) throws IOException {
        boolean isValid = false;
        Certificate cert = certs[0];
        Certificate findParent = null;
        findParent = cert;
        do {
            if ((findParent = CertVerifyUtil.getParentCertificate(findParent, certs)) == null) continue;
            if (cert.equals(findParent)) break;
            cert = findParent;
        } while (findParent != null);
        findParent = cert;
        do {
            if ((findParent = CertVerifyUtil.getParentCertificate(findParent, initedCertChain)) == null || !CertVerifyUtil.isValidRoot(cert = findParent)) continue;
            isValid = true;
            break;
        } while (findParent != null);
        return isValid;
    }
}

