/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.sm2_cert_parse.CertUtil_SM2;
import cn.win_trust_erpc.ConfigIt;
import cn.win_trust_erpc.GMCrypto32Hmac;
import cn.win_trust_erpc.PKCS7Signer;
import cn.win_trust_erpc.SM2Utils;
import cn.win_trust_erpc.SM3Digest;
import cn.win_trust_erpc.SM3HMac;
import cn.win_trust_erpc.SM4;
import cn.win_trust_erpc.SM4_Context;
import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.bouncycastle.asn1.x500.style.BCStyle;
import cn.win_trust_erpc.bouncycastle.asn1.x500.style.IETFUtils;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Certificate;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.util.encoders.Base64;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class GMCrypto
extends GMCrypto32Hmac {
    private byte[] m_key;
    private byte[] m_iv;
    private byte[] m_mackey;
    private byte[] pubKey;
    private byte[] priKey;
    private byte[] pubCert;

    public GMCrypto() {
        ConfigIt.init("wt");
    }

    @Override
    public byte[] EncryptData(byte[] plainData, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        byte[] hmac = SM3HMac.SM3HashMac(plainData, this.m_mackey);
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        sm4.sm4_setkey_enc(ctx, this.m_key);
        cipher = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, plainData) : sm4.sm4_crypt_ecb(ctx, plainData);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        return res;
    }

    @Override
    public byte[] DecryptData(byte[] encryptedData, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] plain = null;
        byte[] hmac = new byte[32];
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        System.arraycopy(encryptedData, 0, hmac, 0, 32);
        System.arraycopy(encryptedData, 32, tmp, 0, encryptedData.length - hmac.length);
        sm4.sm4_setkey_dec(ctx, this.m_key);
        plain = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, tmp) : sm4.sm4_crypt_ecb(ctx, tmp);
        byte[] hmacTrans = SM3HMac.SM3HashMac(plain, this.m_mackey);
        if (Arrays.equals(hmacTrans, hmac)) {
            return plain;
        }
        return null;
    }

    public byte[] ExportSessionKey(byte[] sm2Pubkey) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] md = new byte[32];
        Random rd = new Random();
        byte[] keyAll = new byte[64];
        rd.nextBytes(keyAll);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(keyAll, 0, keyAll.length);
        sm3.doFinal(md, 0);
        System.arraycopy(md, 0, keyAll, 0, 32);
        sm3 = new SM3Digest();
        sm3.update(keyAll, 0, keyAll.length);
        sm3.doFinal(md, 0);
        System.arraycopy(md, 0, keyAll, 32, 32);
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[32];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 32);
        return SM2Utils.encrypt(sm2Pubkey, keyAll);
    }

    public List<byte[]> GMCrypto_SetClientCert(String cert, String pwd) throws Exception {
        CertUtil_SM2.initSignCertB64(cert, pwd);
        this.pubKey = CertUtil_SM2.sm2PubKey;
        this.priKey = CertUtil_SM2.sm2PriKey;
        this.pubCert = CertUtil_SM2.certData;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        result.add(this.pubKey);
        result.add(this.priKey);
        result.add(this.pubCert);
        return result;
    }

    public byte[] GMCrypto_ExportSessionKey(String pubKeyOrCert) throws Exception {
        byte[] cipherSK = null;
        byte[] keyOrCert = Base64.decode(pubKeyOrCert);
        if (keyOrCert.length == 65) {
            cipherSK = this.ExportSessionKey(keyOrCert);
        } else {
            Certificate cert = Certificate.getInstance(keyOrCert);
            SubjectPublicKeyInfo keyInfo = cert.getSubjectPublicKeyInfo();
            byte[] pubKey = keyInfo.getPublicKeyData().getBytes();
            System.out.println("pubKey: " + Util.byteToHex(pubKey));
            cipherSK = this.ExportSessionKey(pubKey);
        }
        return cipherSK;
    }

    public byte[] GMCrypto_EncryptMsg(byte[] plaintext) throws Exception {
        return this.EncryptData(plaintext, true);
    }

    public byte[] GMCrypto_DecryptMsg(byte[] ciphertext) throws Exception {
        return this.DecryptData(ciphertext, true);
    }

    public byte[] GMCrypto_P7Sign(boolean attach, byte[] plainData) throws Exception {
        return PKCS7Signer.generatePKCS7SignatureSM2(attach, plainData, this.pubCert, this.priKey);
    }

    public boolean GMCrypto_P7Verify(byte[] signData, byte[] plainData) throws Exception {
        return PKCS7Signer.verifyPKCS7SignatureSM2(signData, plainData);
    }

    public byte[] GMCrypto_ParseP7(byte[] signData, int type) throws Exception {
        return PKCS7Signer.getItemPKCS7SignatureSM2(signData, type);
    }

    public String[] GMCrypto_ParseCert(byte[] cert) throws Exception {
        try {
            SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Certificate certificate = Certificate.getInstance(cert);
            String Subject = IETFUtils.valueToString(certificate.getSubject().getRDNs(BCStyle.CN)[0].getFirst().getValue());
            String Issuer = IETFUtils.valueToString(certificate.getIssuer().getRDNs(BCStyle.CN)[0].getFirst().getValue());
            String serialNumber = certificate.getSerialNumber().getPositiveValue().toString(16);
            String startDate = sdfTime.format(new Long(certificate.getStartDate().getDate().getTime()));
            String endDate = sdfTime.format(new Long(certificate.getEndDate().getDate().getTime()));
            String[] out = new String[]{Subject, serialNumber, Issuer, startDate, endDate};
            return out;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main1(String[] args) throws Exception {
        String clientCert = "MIIDJAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDCcE3hV6QFzBbl9St8qFRkVw/MTWfGcuk+fpaezAAG0yjYOBUIlM26pnbrDSJFPSbAwggLUBgoqgRzPVQYBBAIBBIICxDCCAsAwggJloAMCAQICEBAAAAAAAAAAAAAAEFB3YzIwDAYIKoEcz1UBg3UFADBcMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRswGQYDVQQDDBJDRkNBIFRFU1QgU00yIE9DQTEwHhcNMjIwNzI3MDMxNTUwWhcNMjMwNzI3MDMxNTUwWjB4MQswCQYDVQQGEwJjbjEMMAoGA1UECgwDQk9DMQ8wDQYDVQQLDAZTWkJBTksxFDASBgNVBAsMC0VudGVycHJpc2VzMTQwMgYDVQQDDCswNDFANzYwMDI0NzI5MjU2QDEwMDAxODQ0MzYkMDAwMDAxQDAwMDAwMDAzMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEdW07sdMj7uRGxWmUk98PUz6DZm6vcXWBrpDExxegb135Gzuy7FgCkujSgZtDfoktAaK4MZB1UYCHV+Fs6wuZLaOB6jCB5zAfBgNVHSMEGDAWgBRr/hjaj0I6prhtsy6Igzo0osEw4TBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmwzNzM3NS5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBSCYSCsYv6KijIKWa/MZpixbh66EzATBgNVHSUEDDAKBggrBgEFBQcDAjAMBggqgRzPVQGDdQUAA0cAMEQCIABs8Zz1cZX1ip8+uic3Tssz7oanll3vrlaI9ffbG0M5AiAqhnhDgwphSoNGk6ROZYXToa93ZGAwo1sYEZRJY2OWpA==";
        String clientCertPwd = "sz654321";
        String serverPubKey = "BHVtO7HTI+7kRsVplJPfD1M+g2Zur3F1ga6QxMcXoG9d+Rs7suxYApLo0oGbQ36JLQGiuDGQdVGAh1fhbOsLmS0=";
        GMCrypto crypto = new GMCrypto();
        System.out.println("\n-----------------------------parse cfca cert-----------------------------");
        List<byte[]> result = crypto.GMCrypto_SetClientCert(clientCert, clientCertPwd);
        System.out.println("GMCrypto_SetClientCert successful.");
        System.out.println("pubKey: " + Util.byteToHex(result.get(0)));
        System.out.println("priKey: " + Util.byteToHex(result.get(1)));
        System.out.println("pubCert: " + Util.byteToHex(result.get(2)));
        byte[] cipherSK = crypto.GMCrypto_ExportSessionKey(serverPubKey);
        System.out.println("CipherSK: " + Util.byteToHex(cipherSK));
        System.out.println("\n-----------------------------encrypt and hmac-----------------------------");
        byte[] plaintext = new String("12345678").getBytes();
        byte[] ciphertext = crypto.GMCrypto_EncryptMsg(plaintext);
        System.out.println("ciphertext: " + Util.byteToHex(ciphertext));
        byte[] decryptData = crypto.GMCrypto_DecryptMsg(ciphertext);
        System.out.println("decryptData: " + new String(decryptData) + "\n");
        System.out.println("\n-----------------------------detach sign and verify-----------------------------");
        byte[] signData = crypto.GMCrypto_P7Sign(false, plaintext);
        System.out.println("signData: " + Util.byteToHex(signData) + "\n");
        byte[] plainP7 = crypto.GMCrypto_ParseP7(signData, 1);
        System.out.println("ParseP7 plainP7: " + plainP7);
        byte[] cert = crypto.GMCrypto_ParseP7(signData, 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        byte[] signature = crypto.GMCrypto_ParseP7(signData, 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        boolean verifyResult = crypto.GMCrypto_P7Verify(signData, plaintext);
        System.out.println("verifyResult: " + verifyResult + "\n");
        System.out.println("\n-----------------------------attach sign and verify-----------------------------");
        signData = crypto.GMCrypto_P7Sign(true, plaintext);
        System.out.println("signData: " + Util.byteToHex(signData) + "\n");
        plainP7 = crypto.GMCrypto_ParseP7(signData, 1);
        System.out.println("ParseP7 plainP7: " + Util.byteToHex(plainP7));
        cert = crypto.GMCrypto_ParseP7(signData, 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(signData, 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        verifyResult = crypto.GMCrypto_P7Verify(signData, null);
        System.out.println("verifyResult: " + verifyResult + "\n");
        System.out.println("\n-------------------------------------------------------------------------------");
        String attachedSignValue = "MIID6gYKKoEcz1UGAQQCAqCCA9owggPWAgEBMQ4wDAYIKoEcz1UBgxEFADAYBgoqgRzPVQYBBAIBoAoECDEyMzQ1Njc4oIICxDCCAsAwggJloAMCAQICEBAAAAAAAAAAAAAAEFB3YzIwDAYIKoEcz1UBg3UFADBcMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRswGQYDVQQDDBJDRkNBIFRFU1QgU00yIE9DQTEwHhcNMjIwNzI3MDMxNTUwWhcNMjMwNzI3MDMxNTUwWjB4MQswCQYDVQQGEwJjbjEMMAoGA1UECgwDQk9DMQ8wDQYDVQQLDAZTWkJBTksxFDASBgNVBAsMC0VudGVycHJpc2VzMTQwMgYDVQQDDCswNDFANzYwMDI0NzI5MjU2QDEwMDAxODQ0MzYkMDAwMDAxQDAwMDAwMDAzMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEdW07sdMj7uRGxWmUk98PUz6DZm6vcXWBrpDExxegb135Gzuy7FgCkujSgZtDfoktAaK4MZB1UYCHV+Fs6wuZLaOB6jCB5zAfBgNVHSMEGDAWgBRr/hjaj0I6prhtsy6Igzo0osEw4TBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmwzNzM3NS5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBSCYSCsYv6KijIKWa/MZpixbh66EzATBgNVHSUEDDAKBggrBgEFBQcDAjAMBggqgRzPVQGDdQUAA0cAMEQCIABs8Zz1cZX1ip8+uic3Tssz7oanll3vrlaI9ffbG0M5AiAqhnhDgwphSoNGk6ROZYXToa93ZGAwo1sYEZRJY2OWpDGB3jCB2wIBATBwMFwxCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxGzAZBgNVBAMMEkNGQ0EgVEVTVCBTTTIgT0NBMQIQEAAAAAAAAAAAAAAQUHdjMjAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEcwRQIhAMxh2Hr/CM2g549BPO/sUAam/PUmt7owduguvka0saP/AiBmeYQFo6S6hFtAM83/g2stP1+3Et7mRC1GJXWdLYW5tw==";
        String detachedSignValue = "MIID3wYKKoEcz1UGAQQCAqCCA88wggPLAgEBMQ4wDAYIKoEcz1UBgxEFADAMBgoqgRzPVQYBBAIBoIICxDCCAsAwggJloAMCAQICEBAAAAAAAAAAAAAAEFB3YzIwDAYIKoEcz1UBg3UFADBcMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRswGQYDVQQDDBJDRkNBIFRFU1QgU00yIE9DQTEwHhcNMjIwNzI3MDMxNTUwWhcNMjMwNzI3MDMxNTUwWjB4MQswCQYDVQQGEwJjbjEMMAoGA1UECgwDQk9DMQ8wDQYDVQQLDAZTWkJBTksxFDASBgNVBAsMC0VudGVycHJpc2VzMTQwMgYDVQQDDCswNDFANzYwMDI0NzI5MjU2QDEwMDAxODQ0MzYkMDAwMDAxQDAwMDAwMDAzMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEdW07sdMj7uRGxWmUk98PUz6DZm6vcXWBrpDExxegb135Gzuy7FgCkujSgZtDfoktAaK4MZB1UYCHV+Fs6wuZLaOB6jCB5zAfBgNVHSMEGDAWgBRr/hjaj0I6prhtsy6Igzo0osEw4TBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmwzNzM3NS5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBSCYSCsYv6KijIKWa/MZpixbh66EzATBgNVHSUEDDAKBggrBgEFBQcDAjAMBggqgRzPVQGDdQUAA0cAMEQCIABs8Zz1cZX1ip8+uic3Tssz7oanll3vrlaI9ffbG0M5AiAqhnhDgwphSoNGk6ROZYXToa93ZGAwo1sYEZRJY2OWpDGB3zCB3AIBATBwMFwxCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxGzAZBgNVBAMMEkNGQ0EgVEVTVCBTTTIgT0NBMQIQEAAAAAAAAAAAAAAQUHdjMjAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEgwRgIhAMR4NrhY5iuQJ+1izK3qw3i4QSZA+eZs/MqzsrWnCj04AiEA1stAFoPLytkih6uq32+4YBDzZorv7JjkMS3MklBRW7c=";
        verifyResult = crypto.GMCrypto_P7Verify(Base64.decode(attachedSignValue), null);
        System.out.println("verifyResult: " + verifyResult + "\n");
        plainP7 = crypto.GMCrypto_ParseP7(Base64.decode(detachedSignValue), 1);
        System.out.println("ParseP7 plainP7: " + plainP7);
        cert = crypto.GMCrypto_ParseP7(Base64.decode(detachedSignValue), 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(Base64.decode(detachedSignValue), 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        verifyResult = crypto.GMCrypto_P7Verify(Base64.decode(detachedSignValue), "12345678".getBytes());
        System.out.println("verifyResult: " + verifyResult + "\n");
        attachedSignValue = "MIID4wYJKoZIhvcNAQcCoIID1DCCA9ACAQExDjAMBggqgRzPVQGDEQUAMBcGCSqGSIb3DQEHAaAKBAgxMjM0NTY3OKCCAsowggLGMIICaqADAgECAgUgYDkCkzAMBggqgRzPVQGDdQUAMF0xCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxHDAaBgNVBAMME0NGQ0EgVEVTVCBTTTIgT0NBMTEwHhcNMjIwOTA3MDcwNzMwWhcNMjMwOTA3MTU1OTU5WjB8MQswCQYDVQQGEwJjbjEVMBMGA1UECgwMQ0ZDQSBURVNUIENBMQ4wDAYDVQQLDAVDTkFQUzEUMBIGA1UECwwLRW50ZXJwcmlzZXMxMDAuBgNVBAMMJzA0MUBaMzEzMzA1MDY2NjYxQDMxMzMwNTA2NjY2MUAwMDAwMDAwNzBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABB+B26zmqCixrzebwllSImWhX9+f0ScPSNNtKLTyf1FxHMFtGuhYRsmvoMFMglOtoKyqGoUnqGEiW/bTzE5QIFyjgfUwgfIwHwYDVR0jBBgwFoAUvqZ+TT18j6BV5sEvCS4sIEOzQn8wSAYDVR0gBEEwPzA9BghggRyG7yoBAjAxMC8GCCsGAQUFBwIBFiNodHRwOi8vd3d3LmNmY2EuY29tLmNuL3VzL3VzLTE1Lmh0bTA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vMjEwLjc0LjQyLjMvT0NBMTEvU00yL2NybDIyMDEwLmNybDALBgNVHQ8EBAMCA+gwHQYDVR0OBBYEFEQy6B4Y90YozX1/z3MiPVlxwVznMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDBDAMBggqgRzPVQGDdQUAA0gAMEUCIQCVFtXnFysOWZzWdsLDD2BZF5HrhKK/zip/0hm2zgsldwIgBgHnSDzZfKcA3aOXISO1WU3nv1t5cY2+7kDlzzyFrygxgdMwgdACAQEwZjBdMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRwwGgYDVQQDDBNDRkNBIFRFU1QgU00yIE9DQTExAgUgYDkCkzAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEYwRAIgo2oWT12gQY/tKUS36ymSLFTeRcDHeznA8CK/+9fcjSwCII/lZ+828LM/yA38x9i/Kr/UiQyO9DvDnUtEQ/MViv+C";
        plainP7 = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 1);
        System.out.println("ParseP7 plainP7: " + Util.byteToHex(plainP7));
        cert = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        verifyResult = crypto.GMCrypto_P7Verify(Base64.decode(attachedSignValue), null);
        System.out.println("verifyResult: " + verifyResult + "\n");
    }

    public static void main(String[] args) throws Exception {
        GMCrypto.main1(null);
        String clientCert = "MIIDBQIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDBI6Bh+v6I0jmAd1VOkd+QNlsezG6fgtqK2lYVl1IQUDRM2lz+qPpaH+lN5bHk0beowggK1BgoqgRzPVQYBBAIBBIICpTCCAqEwggJFoAMCAQICBROWdBcJMAwGCCqBHM9VAYN1BQAwJTELMAkGA1UEBhMCQ04xFjAUBgNVBAoMDUNGQ0EgU00yIE9DQTEwHhcNMjIxMjE5MDIxNTQ4WhcNMjQxMjE5MDIxNTQ4WjCBhjELMAkGA1UEBhMCY24xGzAZBgNVBAoMEkNGQ0EgT3BlcmF0aW9uIENBMjEOMAwGA1UECwwFRFdSQ0IxFDASBgNVBAsMC0VudGVycHJpc2VzMTQwMgYDVQQDDCswNDFAWjc3MjQ2Mzc3LTdAMTAwMDAwMDA2MDEkMDAwMDAxQDAwMDAwMDAyMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEjWigu20JRQuX39b3VewmUkisfL8IM6j8ndCdjBzp9ojdE3+bk1DvvPt+WNGjqoGJX1RJjtJ5Qkiu7IchYN9WuaOB/TCB+jAfBgNVHSMEGDAWgBRck1ggWiRzVhAbZFAQ7OmnygdBETAJBgNVHRMEAjAAMEgGA1UdIARBMD8wPQYIYIEchu8qAQEwMTAvBggrBgEFBQcCARYjaHR0cDovL3d3dy5jZmNhLmNvbS5jbi91cy91cy0xNC5odG0wNwYDVR0fBDAwLjAsoCqgKIYmaHR0cDovL2NybC5jZmNhLmNvbS5jbi9TTTIvY3JsNzMzMC5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBRFtqXf/vpAzUlCZ5oSEO8vIRUPIjAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwQwDAYIKoEcz1UBg3UFAANIADBFAiB8/JmGjaSs2KFc5jWkkVx2INSq9ezOzpM4B1JYNXKFzwIhAIt9h5y6MKzftTjb26jRCNwgLqyB63iqg+8r1svU/LLn";
        String clientCertPwd = "sz123456";
        String serverPubKey = "BHVtO7HTI+7kRsVplJPfD1M+g2Zur3F1ga6QxMcXoG9d+Rs7suxYApLo0oGbQ36JLQGiuDGQdVGAh1fhbOsLmS0=";
        GMCrypto crypto = new GMCrypto();
        System.out.println("\n-----------------------------parse cfca cert-----------------------------");
        List<byte[]> result = crypto.GMCrypto_SetClientCert(clientCert, clientCertPwd);
        System.out.println("GMCrypto_SetClientCert successful.");
        System.out.println("pubKey: " + Util.byteToHex(result.get(0)));
        System.out.println("priKey: " + Util.byteToHex(result.get(1)));
        System.out.println("pubCert: " + Util.byteToHex(result.get(2)));
        byte[] cipherSK = crypto.GMCrypto_ExportSessionKey(serverPubKey);
        System.out.println("CipherSK: " + Util.byteToHex(cipherSK));
        System.out.println("\n-----------------------------encrypt and hmac-----------------------------");
        byte[] plaintext = new String("12345678").getBytes();
        byte[] ciphertext = crypto.GMCrypto_EncryptMsg(plaintext);
        System.out.println("ciphertext: " + Util.byteToHex(ciphertext));
        byte[] decryptData = crypto.GMCrypto_DecryptMsg(ciphertext);
        System.out.println("decryptData: " + new String(decryptData) + "\n");
        System.out.println("\n-----------------------------detach sign and verify-----------------------------");
        byte[] signData = crypto.GMCrypto_P7Sign(false, plaintext);
        System.out.println("signData: " + Util.byteToHex(signData) + "\n");
        byte[] plainP7 = crypto.GMCrypto_ParseP7(signData, 1);
        System.out.println("ParseP7 plainP7: " + plainP7);
        byte[] cert = crypto.GMCrypto_ParseP7(signData, 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        byte[] signature = crypto.GMCrypto_ParseP7(signData, 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        boolean verifyResult = crypto.GMCrypto_P7Verify(signData, plaintext);
        System.out.println("verifyResult: " + verifyResult + "\n");
        System.out.println("\n-----------------------------attach sign and verify-----------------------------");
        signData = crypto.GMCrypto_P7Sign(true, plaintext);
        System.out.println("signData: " + Util.byteToHex(signData) + "\n");
        plainP7 = crypto.GMCrypto_ParseP7(signData, 1);
        System.out.println("ParseP7 plainP7: " + Util.byteToHex(plainP7));
        cert = crypto.GMCrypto_ParseP7(signData, 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(signData, 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        verifyResult = crypto.GMCrypto_P7Verify(signData, null);
        System.out.println("verifyResult: " + verifyResult + "\n");
        System.out.println("\n-------------------------------------------------------------------------------");
        String attachedSignValue = "MIID6gYKKoEcz1UGAQQCAqCCA9owggPWAgEBMQ4wDAYIKoEcz1UBgxEFADAYBgoqgRzPVQYBBAIBoAoECDEyMzQ1Njc4oIICxDCCAsAwggJloAMCAQICEBAAAAAAAAAAAAAAEFB3YzIwDAYIKoEcz1UBg3UFADBcMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRswGQYDVQQDDBJDRkNBIFRFU1QgU00yIE9DQTEwHhcNMjIwNzI3MDMxNTUwWhcNMjMwNzI3MDMxNTUwWjB4MQswCQYDVQQGEwJjbjEMMAoGA1UECgwDQk9DMQ8wDQYDVQQLDAZTWkJBTksxFDASBgNVBAsMC0VudGVycHJpc2VzMTQwMgYDVQQDDCswNDFANzYwMDI0NzI5MjU2QDEwMDAxODQ0MzYkMDAwMDAxQDAwMDAwMDAzMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEdW07sdMj7uRGxWmUk98PUz6DZm6vcXWBrpDExxegb135Gzuy7FgCkujSgZtDfoktAaK4MZB1UYCHV+Fs6wuZLaOB6jCB5zAfBgNVHSMEGDAWgBRr/hjaj0I6prhtsy6Igzo0osEw4TBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmwzNzM3NS5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBSCYSCsYv6KijIKWa/MZpixbh66EzATBgNVHSUEDDAKBggrBgEFBQcDAjAMBggqgRzPVQGDdQUAA0cAMEQCIABs8Zz1cZX1ip8+uic3Tssz7oanll3vrlaI9ffbG0M5AiAqhnhDgwphSoNGk6ROZYXToa93ZGAwo1sYEZRJY2OWpDGB3jCB2wIBATBwMFwxCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxGzAZBgNVBAMMEkNGQ0EgVEVTVCBTTTIgT0NBMQIQEAAAAAAAAAAAAAAQUHdjMjAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEcwRQIhAMxh2Hr/CM2g549BPO/sUAam/PUmt7owduguvka0saP/AiBmeYQFo6S6hFtAM83/g2stP1+3Et7mRC1GJXWdLYW5tw==";
        String detachedSignValue = "MIID3wYKKoEcz1UGAQQCAqCCA88wggPLAgEBMQ4wDAYIKoEcz1UBgxEFADAMBgoqgRzPVQYBBAIBoIICxDCCAsAwggJloAMCAQICEBAAAAAAAAAAAAAAEFB3YzIwDAYIKoEcz1UBg3UFADBcMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRswGQYDVQQDDBJDRkNBIFRFU1QgU00yIE9DQTEwHhcNMjIwNzI3MDMxNTUwWhcNMjMwNzI3MDMxNTUwWjB4MQswCQYDVQQGEwJjbjEMMAoGA1UECgwDQk9DMQ8wDQYDVQQLDAZTWkJBTksxFDASBgNVBAsMC0VudGVycHJpc2VzMTQwMgYDVQQDDCswNDFANzYwMDI0NzI5MjU2QDEwMDAxODQ0MzYkMDAwMDAxQDAwMDAwMDAzMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEdW07sdMj7uRGxWmUk98PUz6DZm6vcXWBrpDExxegb135Gzuy7FgCkujSgZtDfoktAaK4MZB1UYCHV+Fs6wuZLaOB6jCB5zAfBgNVHSMEGDAWgBRr/hjaj0I6prhtsy6Igzo0osEw4TBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmwzNzM3NS5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBSCYSCsYv6KijIKWa/MZpixbh66EzATBgNVHSUEDDAKBggrBgEFBQcDAjAMBggqgRzPVQGDdQUAA0cAMEQCIABs8Zz1cZX1ip8+uic3Tssz7oanll3vrlaI9ffbG0M5AiAqhnhDgwphSoNGk6ROZYXToa93ZGAwo1sYEZRJY2OWpDGB3zCB3AIBATBwMFwxCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxGzAZBgNVBAMMEkNGQ0EgVEVTVCBTTTIgT0NBMQIQEAAAAAAAAAAAAAAQUHdjMjAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEgwRgIhAMR4NrhY5iuQJ+1izK3qw3i4QSZA+eZs/MqzsrWnCj04AiEA1stAFoPLytkih6uq32+4YBDzZorv7JjkMS3MklBRW7c=";
        plainP7 = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 1);
        System.out.println("ParseP7 plainP7: " + Util.byteToHex(plainP7));
        cert = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        verifyResult = crypto.GMCrypto_P7Verify(Base64.decode(attachedSignValue), null);
        System.out.println("verifyResult: " + verifyResult + "\n");
        String[] certInfo = crypto.GMCrypto_ParseCert(cert);
        if (certInfo != null) {
            System.out.println("\u8bc1\u4e66\u4f7f\u7528\u8005: " + certInfo[0]);
            System.out.println("\u8bc1\u4e66\u5e8f\u53f7: " + certInfo[1]);
            System.out.println("\u8bc1\u4e66\u9881\u53d1\u8005: " + certInfo[2]);
            System.out.println("\u8bc1\u4e66\u8d77\u59cb\u65f6\u95f4: " + certInfo[3]);
            System.out.println("\u8bc1\u4e66\u7ed3\u675f\u65f6\u95f4: " + certInfo[4]);
        }
        plainP7 = crypto.GMCrypto_ParseP7(Base64.decode(detachedSignValue), 1);
        System.out.println("ParseP7 plainP7: " + plainP7);
        cert = crypto.GMCrypto_ParseP7(Base64.decode(detachedSignValue), 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(Base64.decode(detachedSignValue), 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        verifyResult = crypto.GMCrypto_P7Verify(Base64.decode(detachedSignValue), "12345678".getBytes());
        System.out.println("verifyResult: " + verifyResult + "\n");
        attachedSignValue = "MIID4wYJKoZIhvcNAQcCoIID1DCCA9ACAQExDjAMBggqgRzPVQGDEQUAMBcGCSqGSIb3DQEHAaAKBAgxMjM0NTY3OKCCAsowggLGMIICaqADAgECAgUgYDkCkzAMBggqgRzPVQGDdQUAMF0xCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxHDAaBgNVBAMME0NGQ0EgVEVTVCBTTTIgT0NBMTEwHhcNMjIwOTA3MDcwNzMwWhcNMjMwOTA3MTU1OTU5WjB8MQswCQYDVQQGEwJjbjEVMBMGA1UECgwMQ0ZDQSBURVNUIENBMQ4wDAYDVQQLDAVDTkFQUzEUMBIGA1UECwwLRW50ZXJwcmlzZXMxMDAuBgNVBAMMJzA0MUBaMzEzMzA1MDY2NjYxQDMxMzMwNTA2NjY2MUAwMDAwMDAwNzBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABB+B26zmqCixrzebwllSImWhX9+f0ScPSNNtKLTyf1FxHMFtGuhYRsmvoMFMglOtoKyqGoUnqGEiW/bTzE5QIFyjgfUwgfIwHwYDVR0jBBgwFoAUvqZ+TT18j6BV5sEvCS4sIEOzQn8wSAYDVR0gBEEwPzA9BghggRyG7yoBAjAxMC8GCCsGAQUFBwIBFiNodHRwOi8vd3d3LmNmY2EuY29tLmNuL3VzL3VzLTE1Lmh0bTA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vMjEwLjc0LjQyLjMvT0NBMTEvU00yL2NybDIyMDEwLmNybDALBgNVHQ8EBAMCA+gwHQYDVR0OBBYEFEQy6B4Y90YozX1/z3MiPVlxwVznMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDBDAMBggqgRzPVQGDdQUAA0gAMEUCIQCVFtXnFysOWZzWdsLDD2BZF5HrhKK/zip/0hm2zgsldwIgBgHnSDzZfKcA3aOXISO1WU3nv1t5cY2+7kDlzzyFrygxgdMwgdACAQEwZjBdMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRwwGgYDVQQDDBNDRkNBIFRFU1QgU00yIE9DQTExAgUgYDkCkzAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEYwRAIgo2oWT12gQY/tKUS36ymSLFTeRcDHeznA8CK/+9fcjSwCII/lZ+828LM/yA38x9i/Kr/UiQyO9DvDnUtEQ/MViv+C";
        plainP7 = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 1);
        System.out.println("ParseP7 plainP7: " + Util.byteToHex(plainP7));
        cert = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(Base64.decode(attachedSignValue), 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature) + "\n");
        verifyResult = crypto.GMCrypto_P7Verify(Base64.decode(attachedSignValue), null);
        System.out.println("verifyResult: " + verifyResult + "\n");
        String signValue = "MIID3gYKKoEcz1UGAQQCAqCCA84wggPKAgEBMQ4wDAYIKoEcz1UBgxEFADAMBgoqgRzPVQYBBAIBoIICxDCCAsAwggJloAMCAQICEBAAAAAAAAAAAAAAEFB3YzIwDAYIKoEcz1UBg3UFADBcMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRswGQYDVQQDDBJDRkNBIFRFU1QgU00yIE9DQTEwHhcNMjIwNzI3MDMxNTUwWhcNMjMwNzI3MDMxNTUwWjB4MQswCQYDVQQGEwJjbjEMMAoGA1UECgwDQk9DMQ8wDQYDVQQLDAZTWkJBTksxFDASBgNVBAsMC0VudGVycHJpc2VzMTQwMgYDVQQDDCswNDFANzYwMDI0NzI5MjU2QDEwMDAxODQ0MzYkMDAwMDAxQDAwMDAwMDAzMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEdW07sdMj7uRGxWmUk98PUz6DZm6vcXWBrpDExxegb135Gzuy7FgCkujSgZtDfoktAaK4MZB1UYCHV+Fs6wuZLaOB6jCB5zAfBgNVHSMEGDAWgBRr/hjaj0I6prhtsy6Igzo0osEw4TBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmwzNzM3NS5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBSCYSCsYv6KijIKWa/MZpixbh66EzATBgNVHSUEDDAKBggrBgEFBQcDAjAMBggqgRzPVQGDdQUAA0cAMEQCIABs8Zz1cZX1ip8+uic3Tssz7oanll3vrlaI9ffbG0M5AiAqhnhDgwphSoNGk6ROZYXToa93ZGAwo1sYEZRJY2OWpDGB3jCB2wIBATBwMFwxCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxGzAZBgNVBAMMEkNGQ0EgVEVTVCBTTTIgT0NBMQIQEAAAAAAAAAAAAAAQUHdjMjAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEcwRQIgAFwmPRHB0NCSVS81PWEZIOpX4qtAtlW1ebr4XH3f3CMCIQDUKG9RzeVwG9qaKXPD0CYZR5XX6tubt92cfqThmbPEsw==";
        String s_plaintext = "5EB2EC3E480F7BF78133D3DE50EFEB98FBFA38AC0F41A9217A6D8350C09BCC2A762EBCA21A3AEF9C54DC552C48232BE338EF148B674EFC66F877ACC85F88534D2E9192E0D491086F224B8CB652BC3F61E4A8313F7E51BB413ED1A3EF7C7CF13832CDBD8F2B7A73B4DE9F7539082F8EBC26B59231ACA6F9F578B009485A9469EF067620EE8C1D0DE2FC5C762858FF3B55";
        System.out.println("---- 20230703 ----");
        cert = crypto.GMCrypto_ParseP7(Base64.decode(signValue), 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(Base64.decode(signValue), 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature));
        verifyResult = crypto.GMCrypto_P7Verify(Base64.decode(signValue), s_plaintext.getBytes());
        System.out.println("verifyResult: " + verifyResult + "\n");
        signValue = "MIID1wYJKoZIhvcNAQcCoIIDyDCCA8QCAQExDjAMBggqgRzPVQGDEQUAMAsGCSqGSIb3DQEHAaCCAsowggLGMIICaqADAgECAgUgYDkCkzAMBggqgRzPVQGDdQUAMF0xCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxHDAaBgNVBAMME0NGQ0EgVEVTVCBTTTIgT0NBMTEwHhcNMjIwOTA3MDcwNzMwWhcNMjMwOTA3MTU1OTU5WjB8MQswCQYDVQQGEwJjbjEVMBMGA1UECgwMQ0ZDQSBURVNUIENBMQ4wDAYDVQQLDAVDTkFQUzEUMBIGA1UECwwLRW50ZXJwcmlzZXMxMDAuBgNVBAMMJzA0MUBaMzEzMzA1MDY2NjYxQDMxMzMwNTA2NjY2MUAwMDAwMDAwNzBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABB+B26zmqCixrzebwllSImWhX9+f0ScPSNNtKLTyf1FxHMFtGuhYRsmvoMFMglOtoKyqGoUnqGEiW/bTzE5QIFyjgfUwgfIwHwYDVR0jBBgwFoAUvqZ+TT18j6BV5sEvCS4sIEOzQn8wSAYDVR0gBEEwPzA9BghggRyG7yoBAjAxMC8GCCsGAQUFBwIBFiNodHRwOi8vd3d3LmNmY2EuY29tLmNuL3VzL3VzLTE1Lmh0bTA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vMjEwLjc0LjQyLjMvT0NBMTEvU00yL2NybDIyMDEwLmNybDALBgNVHQ8EBAMCA+gwHQYDVR0OBBYEFEQy6B4Y90YozX1/z3MiPVlxwVznMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDBDAMBggqgRzPVQGDdQUAA0gAMEUCIQCVFtXnFysOWZzWdsLDD2BZF5HrhKK/zip/0hm2zgsldwIgBgHnSDzZfKcA3aOXISO1WU3nv1t5cY2+7kDlzzyFrygxgdMwgdACAQEwZjBdMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRwwGgYDVQQDDBNDRkNBIFRFU1QgU00yIE9DQTExAgUgYDkCkzAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEYwRAIgAIGYTkpQG1JGKhcN7sDvbuaJBB/A2GZ9M7Hs4HrHFlwCIDvaNl9+N/IrT/Ao7ZeqN3pVig5+ytBvKgGFfheA3ucm";
        s_plaintext = "1A0EA18D228538D691309069FB426FD874E360EFD61548B3E9FE084FF8E85493025E2B7A0C95A5109B0969F30CF21C5549AD0049979A98D97AE03CAFB4FBBBA40862918F9402C389DE9856FE5DAF11A57BBF5577539BA1AA14537B839947960135B923BBEFE820746B65A01CBB9B2091742C7B569953C2AC29F1343E6F9F06F6AF6D8F77E85748BCB75BA17A1D5658098080274A62E05511C9A579BC2E225274A755BFB76EF03C3E0C0C6E69755F4FDAB8BFE1CFB92B22780466CA7B31BA954B9895C9A3F519D2B4EF623A1FAC98DFED717A8FEBA7CB8AC11CA9CCDCB81CD9446C2D28BFD6F7D64FA464F7B13E0762CD617A4FE9750A54AC35A05CA0585F1818792413ADB42CE67D4551C64C5401B91AEF54C6D37E78815A1448D1629FD9645E7B24E830F9E64943C4C4D13EE61F2D8034B6307D3DDB83E618B5D36A1C3678A14010A1FEC9A5FD7747347EBA035603A8152A8A0062EFFF681572281015245F8FDA70791F22C16271A6DD09FB50E1A1D49E19EF1C88477FADD95C7DA43DC136294AF8B6B8B56E957E822DE681C18586A9515AD20163B925E8CB175E3DDB9D74F0BADA6B13DA3B97A3F42FE1FC273C7E7DB72C58066A4D8FC55D61887956CB0642298E4D46DD54591AEC5B18C185E7CFA1375C927D4D19679C3AE0CF3A92004CD838E7935A12DD630768AE5388B7391AA204678DA5D9420A22D45FFD8883DD2956BAB528B2F1D266D80D6AD45E57B5FC3A1E7E8183C4791BD18F9B3FA9CA82DADF9DC5610E4482E85C802112E2F23B321D75A34E2C7B5B7F795355A301F1C3DD07E49AC9B49317AE4EBF2716A93C67DEAC9C8456A4C9EB8C3CDBD8A822D5D0B70B16854572E23F777023FBEC75EFC1E38B6CE086A6FA5E14E78E993D33D4B7A0593CB1F2DFBE3012B35716916C3231DA5D169EC1DAB0425F939473282EBBD15F8BAB27B9A5B5E20E0D6B9C9AC63B493B158F3485D28B2A3620CBDB5124632A38B5E99985452460E6AB3BB95D26233E6E8806D43E5ED52FE3A76FA6442C2F801C3810FE2FBF32253E26AA2AC887480D1EBD34511BB6E169550D2B0C15025A450201AEC04689DE2B05F3BB51A5A0340E7794";
        System.out.println("---- 20230705 ----");
        cert = crypto.GMCrypto_ParseP7(Base64.decode(signValue), 2);
        System.out.println("ParseP7 cert: " + Util.byteToHex(cert));
        signature = crypto.GMCrypto_ParseP7(Base64.decode(signValue), 3);
        System.out.println("ParseP7 signature: " + Util.byteToHex(signature));
        verifyResult = crypto.GMCrypto_P7Verify(Base64.decode(signValue), s_plaintext.getBytes());
        System.out.println("verifyResult: " + verifyResult + "\n");
    }
}

