/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.ASCallback;
import cn.win_trust_erpc.ASCallbackImp;
import cn.win_trust_erpc.ConfigIt;
import cn.win_trust_erpc.SM2;
import cn.win_trust_erpc.SM2Utils;
import cn.win_trust_erpc.SM3HMac;
import cn.win_trust_erpc.SM4;
import cn.win_trust_erpc.SM4_Context;
import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.math.ec.ECPoint;
import cn.win_trust_erpc.bouncycastle.util.encoders.Base64;
import cn.win_trust_erpc.gson.Gson;
import cn.win_trust_erpc.gson.reflect.TypeToken;
import com.union.api.TUnionTransInfo;
import com.union.api.UnionEsscAPI;
import com.union.api.UnionStr;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class GMCrypto16Hmac {
    private byte[] m_key;
    private byte[] m_iv;
    private byte[] m_mackey;
    List<String> ipList;
    List<Integer> portList;
    int timeout;
    String sysID;
    String appID;
    String keyName;
    int vkIndex;

    public static byte[] switch_c3_after_c2(byte[] cipher) {
        byte[] c1 = new byte[65];
        byte[] c2 = new byte[cipher.length - 65 - 32];
        byte[] c3 = new byte[32];
        System.arraycopy(cipher, 0, c1, 0, 65);
        System.arraycopy(cipher, 65, c3, 0, 32);
        System.arraycopy(cipher, 97, c2, 0, cipher.length - 65 - 32);
        byte[] cipherNew = new byte[cipher.length];
        System.arraycopy(c1, 0, cipherNew, 0, c1.length);
        System.arraycopy(c2, 0, cipherNew, c1.length, c2.length);
        System.arraycopy(c3, 0, cipherNew, c1.length + c2.length, c3.length);
        return cipherNew;
    }

    public static byte[] switch_c3_before_c2(byte[] cipher) {
        byte[] c1 = new byte[65];
        byte[] c2 = new byte[cipher.length - 65 - 32];
        byte[] c3 = new byte[32];
        System.arraycopy(cipher, 0, c1, 0, 65);
        System.arraycopy(cipher, 65, c2, 0, cipher.length - 65 - 32);
        System.arraycopy(cipher, cipher.length - 32, c3, 0, 32);
        byte[] cipherNew = new byte[cipher.length];
        System.arraycopy(c1, 0, cipherNew, 0, c1.length);
        System.arraycopy(c3, 0, cipherNew, c1.length, c3.length);
        System.arraycopy(c2, 0, cipherNew, c1.length + c3.length, c2.length);
        return cipherNew;
    }

    public boolean SetTUnionParam(List<String> ipList, List<Integer> portList, int timeout, String sysID, String appID, String keyName, int vkIndex) {
        this.ipList = ipList;
        this.portList = portList;
        this.timeout = timeout;
        this.sysID = sysID;
        this.appID = appID;
        this.keyName = keyName;
        this.vkIndex = vkIndex;
        return true;
    }

    public boolean ImportSessionKeyTUnion(byte[] keyCipher) throws Exception {
        keyCipher = GMCrypto16Hmac.switch_c3_before_c2(keyCipher);
        String cipherSKeyHex = Util.byteToHex(keyCipher);
        cipherSKeyHex = cipherSKeyHex.substring(2, cipherSKeyHex.length());
        UnionEsscAPI shortApi = new UnionEsscAPI(this.ipList, this.portList, this.timeout, this.sysID, this.appID);
        TUnionTransInfo info = shortApi.unionAPIServiceE173(this.keyName, String.valueOf(keyCipher.length), this.vkIndex, "SM2", "00", cipherSKeyHex);
        if (1 != info.getIsSuccess()) {
            return false;
        }
        System.out.println("1< " + info.getReturnBody().getPlainData());
        byte[] keyAll = UnionStr.aschex_to_bcdhex((String)info.getReturnBody().getPlainData());
        System.out.println("2< " + Util.byteToHex(keyAll));
        if (keyAll == null || keyAll.length != 48) {
            return false;
        }
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 16);
        return true;
    }

    public byte[] GenExportSessionKey(ASCallback callback, boolean c1c3c2) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] sm2Pubkey = callback.GetSM2PubKey();
        Random rd = new Random();
        byte[] keyAll = new byte[48];
        rd.nextBytes(keyAll);
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 16);
        return SM2Utils.encrypt(sm2Pubkey, keyAll, c1c3c2);
    }

    public boolean ASImportSessionKey(ASCallback callback, byte[] keyCipher, boolean c1c3c2) throws Exception {
        ECPoint publicKey;
        byte[] tmpPubkey;
        byte[] cipherConvert;
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        byte[] keyAll = SM2Utils.decrypt(privateKey, cipherConvert = callback.ExportSessionKeyToAs(keyCipher, tmpPubkey = (publicKey = ecpub.getQ()).getEncoded(false), c1c3c2), c1c3c2);
        if (keyAll == null || keyAll.length != 48) {
            return false;
        }
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 16);
        return true;
    }

    public byte[] GenExportSessionKey(byte[] sm2Pubkey) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        Random rd = new Random();
        byte[] keyAll = new byte[48];
        rd.nextBytes(keyAll);
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 16);
        return SM2Utils.encrypt(sm2Pubkey, keyAll);
    }

    public byte[] GenExportSessionKey(byte[] sm2Pubkey, boolean c1c3c2) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        Random rd = new Random();
        byte[] keyAll = new byte[48];
        rd.nextBytes(keyAll);
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 16);
        return SM2Utils.encrypt(sm2Pubkey, keyAll, c1c3c2);
    }

    public boolean ImportSessionKey(byte[] sm2Prvkey, byte[] keyCipher) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] keyAll = SM2Utils.decrypt(sm2Prvkey, keyCipher);
        if (keyAll == null || keyAll.length != 48) {
            return false;
        }
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 16);
        return true;
    }

    public boolean ImportSessionKey(byte[] keyPlain) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] keyAll = keyPlain;
        if (keyAll == null || keyAll.length != 48) {
            return false;
        }
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 16);
        return true;
    }

    public byte[] EncryptData(byte[] plainData, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        byte[] hmac = SM3HMac.SM3HashMac(plainData, this.m_mackey);
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        sm4.sm4_setkey_enc(ctx, this.m_key);
        cipher = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, plainData) : sm4.sm4_crypt_ecb(ctx, plainData);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        return res;
    }

    public byte[] DecryptData(byte[] encryptedData, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] plain = null;
        byte[] hmac = new byte[32];
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        System.arraycopy(encryptedData, 0, hmac, 0, 32);
        System.arraycopy(encryptedData, 32, tmp, 0, encryptedData.length - hmac.length);
        sm4.sm4_setkey_dec(ctx, this.m_key);
        plain = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, tmp) : sm4.sm4_crypt_ecb(ctx, tmp);
        byte[] hmacTrans = SM3HMac.SM3HashMac(plain, this.m_mackey);
        if (Arrays.equals(hmacTrans, hmac)) {
            return plain;
        }
        return null;
    }

    public byte[] EncryptSignData(byte[] sm2Prvkey, byte[] plainData, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        byte[] hmac = SM2Utils.SignRS(sm2Prvkey, plainData);
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        sm4.sm4_setkey_enc(ctx, this.m_key);
        cipher = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, plainData) : sm4.sm4_crypt_ecb(ctx, plainData);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        return res;
    }

    public byte[] DecryptVerifySignData(byte[] sm2Pubkey, byte[] encryptedData, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] plain = null;
        byte[] hmac = new byte[64];
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        System.arraycopy(encryptedData, 0, hmac, 0, 64);
        System.arraycopy(encryptedData, 64, tmp, 0, encryptedData.length - hmac.length);
        sm4.sm4_setkey_dec(ctx, this.m_key);
        plain = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, tmp) : sm4.sm4_crypt_ecb(ctx, tmp);
        if (SM2Utils.VerifyRS(sm2Pubkey, plain, hmac)) {
            return plain;
        }
        return null;
    }

    public String EncryptSignData(byte[] sm2Cert, byte[] sm2Prvkey, byte[] plainData, boolean useCBC) throws Exception {
        Gson gson = new Gson();
        HashMap<String, String> map = new HashMap<String, String>();
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        byte[] hmac = SM2Utils.SignRS(sm2Prvkey, plainData);
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        sm4.sm4_setkey_enc(ctx, this.m_key);
        cipher = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, plainData) : sm4.sm4_crypt_ecb(ctx, plainData);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        map.put("data", Base64.toBase64String(res, 0, res.length));
        map.put("cert", Base64.toBase64String(sm2Cert, 0, sm2Cert.length));
        return gson.toJson(map);
    }

    public byte[] DecryptVerifySignData(String encryptedString, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] plain = null;
        byte[] hmac = new byte[64];
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(encryptedString, new TypeToken<Map<String, String>>(){}.getType());
        byte[] encryptedData = Base64.decode((String)map.get("data"));
        byte[] cert = Base64.decode((String)map.get("cert"));
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        System.arraycopy(encryptedData, 0, hmac, 0, 64);
        System.arraycopy(encryptedData, 64, tmp, 0, encryptedData.length - hmac.length);
        sm4.sm4_setkey_dec(ctx, this.m_key);
        plain = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, tmp) : sm4.sm4_crypt_ecb(ctx, tmp);
        if (SM2Utils.VerifyRSByCert(cert, plain, hmac)) {
            return plain;
        }
        return null;
    }

    public static void main1(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        GMCrypto16Hmac cryptoSend = new GMCrypto16Hmac();
        GMCrypto16Hmac cryptoRecv = new GMCrypto16Hmac();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(Util.hexToByte(pubk), false);
        byte[] keyPlain = SM2Utils.decrypt(Util.hexToByte(prik), keyCipher, false);
        boolean bImport = cryptoRecv.ImportSessionKey(keyPlain);
        System.out.println(bImport);
        byte[] plainData = "Hello World!".getBytes();
        byte[] encryptedData = cryptoSend.EncryptData(plainData, false);
        plainData = cryptoRecv.DecryptData(encryptedData, false);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptData(plainData, true);
        plainData = cryptoRecv.DecryptData(encryptedData, true);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptData(plainData, true);
        plainData = cryptoRecv.DecryptData(encryptedData, true);
        System.out.println(new String(plainData));
    }

    public static void main2(String[] args) throws Exception {
        ConfigIt.init("wt");
        GMCrypto16Hmac cryptoSend = new GMCrypto16Hmac();
        GMCrypto16Hmac cryptoRecv = new GMCrypto16Hmac();
        ASCallbackImp imp = new ASCallbackImp();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(imp, true);
        boolean bImport = cryptoRecv.ASImportSessionKey(imp, keyCipher, true);
        System.out.println(bImport);
        byte[] plainData = "Hello World!".getBytes();
        byte[] encryptedData = cryptoSend.EncryptData(plainData, false);
        plainData = cryptoRecv.DecryptData(encryptedData, false);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptData(plainData, true);
        plainData = cryptoRecv.DecryptData(encryptedData, true);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptData(plainData, true);
        plainData = cryptoRecv.DecryptData(encryptedData, true);
        System.out.println(new String(plainData));
    }

    public static void main3(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        String prik_s = "EFADC06E8FD16A215D530750D0785DB3838CA09844C781E07B8193EBF2ABAC8E";
        String pubk_v = "049992E87386D38E4FBAE607424C15864298A7060EBD3CD37FAD8F6180956F05C27B7BFF5331F4A41F266DE7FDB1672EB649C0D002A80AE43F5546F7DB241F333D";
        GMCrypto16Hmac cryptoSend = new GMCrypto16Hmac();
        GMCrypto16Hmac cryptoRecv = new GMCrypto16Hmac();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(Util.hexToByte(pubk), false);
        boolean bImport = cryptoRecv.ImportSessionKey(Util.hexToByte(prik), keyCipher);
        System.out.println(bImport);
        byte[] plainData = "Hello World!".getBytes();
        byte[] encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(prik_s), plainData, false);
        plainData = cryptoRecv.DecryptVerifySignData(Util.hexToByte(pubk_v), encryptedData, false);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(prik_s), plainData, true);
        plainData = cryptoRecv.DecryptVerifySignData(Util.hexToByte(pubk_v), encryptedData, true);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(prik_s), plainData, true);
        plainData = cryptoRecv.DecryptVerifySignData(Util.hexToByte(pubk_v), encryptedData, true);
        System.out.println(new String(plainData));
    }

    public static void main(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        String prik_s = "EFADC06E8FD16A215D530750D0785DB3838CA09844C781E07B8193EBF2ABAC8E";
        String cert = "308201843082012AA003020102020412345678300A06082A811CCF550183753019310B300906035504061302434E310A300806035504030C0141301E170D3232303631373033303930305A170D3234303832353033303930305A3019310B300906035504061302434E310A300806035504030C01413059301306072A8648CE3D020106082A811CCF5501822D034200049992E87386D38E4FBAE607424C15864298A7060EBD3CD37FAD8F6180956F05C27B7BFF5331F4A41F266DE7FDB1672EB649C0D002A80AE43F5546F7DB241F333DA360305E300F0603551D130101FF040530030101FF301D0603551D0E04160414312F63C7C27B36A71853094D63A05222534B2BE7301F0603551D23041830168014312F63C7C27B36A71853094D63A05222534B2BE7300B0603551D0F0404030201FE300A06082A811CCF55018375034800304502205FBB1C8895BC5D9D75C914B954CEA42569804C72D1F4F328A2F57444D9784083022100CBE25B46A2B99F3E6E2843DD90227D28ECC6497C52EB7709EEBE9D6EB514D9D3";
        GMCrypto16Hmac cryptoSend = new GMCrypto16Hmac();
        GMCrypto16Hmac cryptoRecv = new GMCrypto16Hmac();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(Util.hexToByte(pubk), false);
        boolean bImport = cryptoRecv.ImportSessionKey(Util.hexToByte(prik), keyCipher);
        System.out.println(bImport);
        byte[] plainData = "Hello World!=================================================================================================================================================================================================================".getBytes();
        String encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(cert), Util.hexToByte(prik_s), plainData, false);
        plainData = cryptoRecv.DecryptVerifySignData(encryptedData, false);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(cert), Util.hexToByte(prik_s), plainData, true);
        plainData = cryptoRecv.DecryptVerifySignData(encryptedData, true);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(cert), Util.hexToByte(prik_s), plainData, true);
        plainData = cryptoRecv.DecryptVerifySignData(encryptedData, true);
        System.out.println(new String(plainData));
    }
}

