/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.ConfigIt;
import cn.win_trust_erpc.SM2Utils;
import cn.win_trust_erpc.SM3HMac;
import cn.win_trust_erpc.SM4;
import cn.win_trust_erpc.SM4_Context;
import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.bouncycastle.crypto.BlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.BufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.engines.SM4Engine;
import cn.win_trust_erpc.bouncycastle.crypto.modes.CBCBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.paddings.PKCS7Padding;
import cn.win_trust_erpc.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithIV;
import cn.win_trust_erpc.bouncycastle.util.encoders.Base64;
import cn.win_trust_erpc.gson.Gson;
import cn.win_trust_erpc.gson.reflect.TypeToken;
import com.union.api.TUnionTransInfo;
import com.union.api.UnionEsscAPI;
import com.union.api.UnionStr;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class GMCrypto32Hmac {
    private byte[] m_key;
    private byte[] m_iv;
    private byte[] m_mackey;
    List<String> ipList;
    List<Integer> portList;
    int timeout;
    String sysID;
    String appID;
    String keyName;
    int vkIndex;

    public static byte[] SM4Crypt(byte[] key, byte[] iv, boolean encrypt, boolean useCBC, byte[] input) throws Exception {
        BlockCipher blockCipher = null;
        PaddedBufferedBlockCipher bufferedBlockCipher = null;
        if (useCBC) {
            blockCipher = new CBCBlockCipher(new SM4Engine());
            bufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
            ((BufferedBlockCipher)bufferedBlockCipher).init(encrypt, new ParametersWithIV(new KeyParameter(key), iv));
        } else {
            blockCipher = new SM4Engine();
            bufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
            ((BufferedBlockCipher)bufferedBlockCipher).init(encrypt, new KeyParameter(key));
        }
        byte[] output = new byte[((BufferedBlockCipher)bufferedBlockCipher).getOutputSize(input.length)];
        int processed = ((BufferedBlockCipher)bufferedBlockCipher).processBytes(input, 0, input.length, output, 0);
        int finaled = ((BufferedBlockCipher)bufferedBlockCipher).doFinal(output, processed);
        byte[] res = new byte[processed + finaled];
        System.arraycopy(output, 0, res, 0, res.length);
        return res;
    }

    public static byte[] switch_c3_after_c2(byte[] cipher) {
        byte[] c1 = new byte[65];
        byte[] c2 = new byte[cipher.length - 65 - 32];
        byte[] c3 = new byte[32];
        System.arraycopy(cipher, 0, c1, 0, 65);
        System.arraycopy(cipher, 65, c3, 0, 32);
        System.arraycopy(cipher, 97, c2, 0, cipher.length - 65 - 32);
        byte[] cipherNew = new byte[cipher.length];
        System.arraycopy(c1, 0, cipherNew, 0, c1.length);
        System.arraycopy(c2, 0, cipherNew, c1.length, c2.length);
        System.arraycopy(c3, 0, cipherNew, c1.length + c2.length, c3.length);
        return cipherNew;
    }

    public static byte[] switch_c3_before_c2(byte[] cipher) {
        byte[] c1 = new byte[65];
        byte[] c2 = new byte[cipher.length - 65 - 32];
        byte[] c3 = new byte[32];
        System.arraycopy(cipher, 0, c1, 0, 65);
        System.arraycopy(cipher, 65, c2, 0, cipher.length - 65 - 32);
        System.arraycopy(cipher, cipher.length - 32, c3, 0, 32);
        byte[] cipherNew = new byte[cipher.length];
        System.arraycopy(c1, 0, cipherNew, 0, c1.length);
        System.arraycopy(c3, 0, cipherNew, c1.length, c3.length);
        System.arraycopy(c2, 0, cipherNew, c1.length + c3.length, c2.length);
        return cipherNew;
    }

    public boolean SetTUnionParam(List<String> ipList, List<Integer> portList, int timeout, String sysID, String appID, String keyName, int vkIndex) {
        this.ipList = ipList;
        this.portList = portList;
        this.timeout = timeout;
        this.sysID = sysID;
        this.appID = appID;
        this.keyName = keyName;
        this.vkIndex = vkIndex;
        return true;
    }

    public boolean ImportSessionKeyTUnion(byte[] keyCipher) throws Exception {
        keyCipher = GMCrypto32Hmac.switch_c3_before_c2(keyCipher);
        String cipherSKeyHex = Util.byteToHex(keyCipher);
        cipherSKeyHex = cipherSKeyHex.substring(2, cipherSKeyHex.length());
        UnionEsscAPI shortApi = new UnionEsscAPI(this.ipList, this.portList, this.timeout, this.sysID, this.appID);
        TUnionTransInfo info = shortApi.unionAPIServiceE173(this.keyName, String.valueOf(keyCipher.length), this.vkIndex, "SM2", "00", cipherSKeyHex);
        if (1 != info.getIsSuccess()) {
            return false;
        }
        System.out.println("1< " + info.getReturnBody().getPlainData());
        byte[] keyAll = UnionStr.aschex_to_bcdhex((String)info.getReturnBody().getPlainData());
        System.out.println("2< " + Util.byteToHex(keyAll));
        if (keyAll == null || keyAll.length != 64) {
            return false;
        }
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[32];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 32);
        return true;
    }

    public byte[] GenExportSessionKey(byte[] sm2Pubkey) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        Random rd = new Random();
        byte[] keyAll = new byte[64];
        rd.nextBytes(keyAll);
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[32];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 32);
        return SM2Utils.encrypt(sm2Pubkey, keyAll);
    }

    public byte[] GenExportSessionKey(byte[] sm2Pubkey, boolean c1c3c2) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        Random rd = new Random();
        byte[] keyAll = new byte[64];
        rd.nextBytes(keyAll);
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[32];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 32);
        return SM2Utils.encrypt(sm2Pubkey, keyAll, c1c3c2);
    }

    public boolean ImportSessionKey(byte[] sm2Prvkey, byte[] keyCipher) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] keyAll = SM2Utils.decrypt(sm2Prvkey, keyCipher);
        if (keyAll == null || keyAll.length != 64) {
            return false;
        }
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[32];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 32);
        return true;
    }

    public boolean ImportSessionKey(byte[] sm2Prvkey, byte[] keyCipher, boolean c1c3c2) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] keyAll = SM2Utils.decrypt(sm2Prvkey, keyCipher, c1c3c2);
        if (keyAll == null || keyAll.length != 64) {
            return false;
        }
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[32];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 32);
        return true;
    }

    public boolean ImportSessionKey(byte[] keyPlain) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] keyAll = keyPlain;
        if (keyAll == null || keyAll.length != 64) {
            return false;
        }
        this.m_key = new byte[16];
        this.m_iv = new byte[16];
        this.m_mackey = new byte[32];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        System.arraycopy(keyAll, 16, this.m_iv, 0, 16);
        System.arraycopy(keyAll, 32, this.m_mackey, 0, 32);
        return true;
    }

    public byte[] EncryptData(byte[] plainData, boolean useCBC) throws Exception {
        byte[] cipher = GMCrypto32Hmac.SM4Crypt(this.m_key, this.m_iv, true, useCBC, plainData);
        byte[] hmac = SM3HMac.SM3HashMac(plainData, this.m_mackey);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        return res;
    }

    public byte[] DecryptData(byte[] encryptedData, boolean useCBC) throws Exception {
        byte[] plain = null;
        byte[] hmac = new byte[32];
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        System.arraycopy(encryptedData, 0, hmac, 0, 32);
        System.arraycopy(encryptedData, 32, tmp, 0, encryptedData.length - hmac.length);
        plain = GMCrypto32Hmac.SM4Crypt(this.m_key, this.m_iv, false, useCBC, tmp);
        byte[] hmacTrans = SM3HMac.SM3HashMac(plain, this.m_mackey);
        if (Arrays.equals(hmacTrans, hmac)) {
            return plain;
        }
        return null;
    }

    public byte[] EncryptSignData(byte[] sm2Prvkey, byte[] plainData, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        byte[] hmac = SM2Utils.SignRS(sm2Prvkey, plainData);
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        sm4.sm4_setkey_enc(ctx, this.m_key);
        cipher = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, plainData) : sm4.sm4_crypt_ecb(ctx, plainData);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        return res;
    }

    public byte[] DecryptVerifySignData(byte[] sm2Pubkey, byte[] encryptedData, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] plain = null;
        byte[] hmac = new byte[64];
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        System.arraycopy(encryptedData, 0, hmac, 0, 64);
        System.arraycopy(encryptedData, 64, tmp, 0, encryptedData.length - hmac.length);
        sm4.sm4_setkey_dec(ctx, this.m_key);
        plain = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, tmp) : sm4.sm4_crypt_ecb(ctx, tmp);
        if (SM2Utils.VerifyRS(sm2Pubkey, plain, hmac)) {
            return plain;
        }
        return null;
    }

    public String EncryptSignData(byte[] sm2Cert, byte[] sm2Prvkey, byte[] plainData, boolean useCBC) throws Exception {
        Gson gson = new Gson();
        HashMap<String, String> map = new HashMap<String, String>();
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        byte[] hmac = SM2Utils.SignRS(sm2Prvkey, plainData);
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        sm4.sm4_setkey_enc(ctx, this.m_key);
        cipher = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, plainData) : sm4.sm4_crypt_ecb(ctx, plainData);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        map.put("data", Base64.toBase64String(res, 0, res.length));
        map.put("cert", Base64.toBase64String(sm2Cert, 0, sm2Cert.length));
        return gson.toJson(map);
    }

    public byte[] DecryptVerifySignData(String encryptedString, boolean useCBC) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] plain = null;
        byte[] hmac = new byte[64];
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(encryptedString, new TypeToken<Map<String, String>>(){}.getType());
        byte[] encryptedData = Base64.decode((String)map.get("data"));
        byte[] cert = Base64.decode((String)map.get("cert"));
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        byte[] tmpIV = new byte[16];
        System.arraycopy(this.m_iv, 0, tmpIV, 0, 16);
        System.arraycopy(encryptedData, 0, hmac, 0, 64);
        System.arraycopy(encryptedData, 64, tmp, 0, encryptedData.length - hmac.length);
        sm4.sm4_setkey_dec(ctx, this.m_key);
        plain = useCBC ? sm4.sm4_crypt_cbc(ctx, tmpIV, tmp) : sm4.sm4_crypt_ecb(ctx, tmp);
        if (SM2Utils.VerifyRSByCert(cert, plain, hmac)) {
            return plain;
        }
        return null;
    }

    public static void main1(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "198DEB4AC8394877AA4FF563F16B9AF7F6D7F46DDE22FDA7063F235AE2A4AF85";
        GMCrypto32Hmac cryptoRecv = new GMCrypto32Hmac();
        String keyCipherHex = "04c27941757f4b55d43e23278f445246b2d4d04fe1cca963d20fa48dbbe3532d288446f10cb8423c83ac6233c7e6bb31b262c67269a423b70ee4da2b03c8b5e04e37702569a6816f6d52a170c097f08d1cb3cd1299af2a0bb5b5a0ccb8d98706acd39b196199308415f64f65839fe02ad4ead75e872779c5cb4f7e64fd89eaaec1072610f2fa891f4d6380bc15cdabd6c12b8f2aa1f7e131c2eb7647df3bfdbc29";
        boolean bImport = cryptoRecv.ImportSessionKey(Util.hexToByte(prik), Util.hexToByte(keyCipherHex), true);
        System.out.println(bImport);
        String encryptedDataHex = "6615beb5c1a78427b07b8657de316cf3c8380f37f6ff5045900071771e5150101ab13fe7d2050053a1e5315fe3ce3594";
        byte[] plainData = cryptoRecv.DecryptData(Util.hexToByte(encryptedDataHex), true);
        System.out.println(new String(plainData));
        System.out.println(new String(plainData));
    }

    public static void main(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        String prik_s = "EFADC06E8FD16A215D530750D0785DB3838CA09844C781E07B8193EBF2ABAC8E";
        String pubk_v = "049992E87386D38E4FBAE607424C15864298A7060EBD3CD37FAD8F6180956F05C27B7BFF5331F4A41F266DE7FDB1672EB649C0D002A80AE43F5546F7DB241F333D";
        GMCrypto32Hmac cryptoSend = new GMCrypto32Hmac();
        GMCrypto32Hmac cryptoRecv = new GMCrypto32Hmac();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(Util.hexToByte(pubk), false);
        boolean bImport = cryptoRecv.ImportSessionKey(Util.hexToByte(prik), keyCipher);
        System.out.println(bImport);
        byte[] plainData = "Hello World!".getBytes();
        byte[] encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(prik_s), plainData, false);
        plainData = cryptoRecv.DecryptVerifySignData(Util.hexToByte(pubk_v), encryptedData, false);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(prik_s), plainData, true);
        plainData = cryptoRecv.DecryptVerifySignData(Util.hexToByte(pubk_v), encryptedData, true);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptSignData(Util.hexToByte(prik_s), plainData, true);
        plainData = cryptoRecv.DecryptVerifySignData(Util.hexToByte(pubk_v), encryptedData, true);
        System.out.println(new String(plainData));
    }
}

