/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.SM2Utils;
import cn.win_trust_erpc.SM3Digest;
import cn.win_trust_erpc.SM4;
import cn.win_trust_erpc.SM4_Context;
import cn.win_trust_erpc.bouncycastle.util.encoders.Base64;
import cn.win_trust_erpc.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;

public class SFIImp {
    byte[] sm4_session_key;

    String SFI_GenSessionKey(String serverRandomSeed, String serverPubkey) throws Exception {
        if (this.sm4_session_key == null) {
            this.sm4_session_key = new byte[16];
        }
        byte[] sm2Pubkey = Base64.decode(serverPubkey);
        byte[] keyC1C2C3 = SM2Utils.encrypt(sm2Pubkey, this.sm4_session_key);
        String keyCipherB64 = Base64.toBase64String(keyC1C2C3);
        return keyCipherB64;
    }

    public byte[] SM4Decrypt(byte[] key, byte[] input) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        sm4.sm4_setkey_dec(ctx, key);
        cipher = sm4.sm4_crypt_ecb(ctx, input);
        return cipher;
    }

    public byte[] SM4Encrypt(byte[] key, byte[] input) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        sm4.sm4_setkey_enc(ctx, key);
        cipher = sm4.sm4_crypt_ecb(ctx, input);
        return cipher;
    }

    String SFI_DecryptDptTable(String dptInteractiveRand, String dptTable, String usrName, String deviceInfo) throws Exception {
        byte[] dptTableArray = Base64.decode(dptTable);
        byte[] dptInteractiveRandArray = Base64.decode(dptInteractiveRand);
        byte[] dptInteractiveRandBytes = this.SM4Decrypt(this.sm4_session_key, dptInteractiveRandArray);
        byte[] workKeyParam = new byte[dptInteractiveRandBytes.length + usrName.getBytes("UTF-8").length + deviceInfo.getBytes("UTF-8").length];
        System.arraycopy(dptInteractiveRandBytes, 0, workKeyParam, 0, dptInteractiveRandBytes.length);
        System.arraycopy(usrName.getBytes("UTF-8"), 0, workKeyParam, dptInteractiveRandBytes.length, usrName.getBytes("UTF-8").length);
        System.arraycopy(deviceInfo.getBytes("UTF-8"), 0, workKeyParam, dptInteractiveRandBytes.length + usrName.getBytes("UTF-8").length, deviceInfo.getBytes("UTF-8").length);
        byte[] workKeyHash = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(workKeyParam, 0, workKeyParam.length);
        sm3.doFinal(workKeyHash, 0);
        byte[] workKey = new byte[16];
        System.arraycopy(workKeyHash, 0, workKey, 0, 16);
        byte[] dptTableByte = this.SM4Decrypt(workKey, dptTableArray);
        Gson gson = new Gson();
        ArrayList lists = new ArrayList();
        int ii = 0;
        ii = 0;
        while (ii < dptTableByte.length / 2 / 96) {
            ArrayList list = new ArrayList();
            int kk = 0;
            kk = 0;
            while (kk < 96) {
                HashMap<String, String> map = new HashMap<String, String>();
                byte[] key = new byte[]{dptTableByte[ii * 2 * 96 + kk]};
                byte[] value = new byte[]{dptTableByte[ii * 2 * 96 + 96 + kk]};
                map.put(new String(key), new String(value));
                list.add(map);
                ++kk;
            }
            lists.add(list);
            ++ii;
        }
        return gson.toJson(lists);
    }

    String SFI_GetCipherPWD(String cipher, String input, int length) throws Exception {
        byte[] plainSrc = null;
        if (cipher.length() == 0) {
            plainSrc = new byte[]{};
        } else {
            byte[] cipherBytes = Base64.decode(cipher);
            plainSrc = this.SM4Decrypt(this.sm4_session_key, cipherBytes);
        }
        String total = String.valueOf(new String(plainSrc)) + input;
        byte[] plainDest = new byte[length];
        System.arraycopy(total.getBytes(), 0, plainDest, 0, length);
        System.out.println(new String(plainDest));
        byte[] cipherDest = this.SM4Encrypt(this.sm4_session_key, plainDest);
        return Base64.toBase64String(cipherDest);
    }

    public static void main(String[] args) throws Exception {
        SFIImp sfi = new SFIImp();
        String cipherKey = sfi.SFI_GenSessionKey("", "BLE5K6TCJTWs9C0rAp2ip88ObH17e0mKpSjTUARFDOCyJQxjUWvyD83MFnGzfEu6AqMw0tztSlJB6V+SSUoSN3M=");
        System.out.println(cipherKey);
        String tables = sfi.SFI_DecryptDptTable("9R8/iKILhAx0LT0i61NtCMyk4Cp8JaXeDRHxpcIeqU6oP5DMnzXKxNr2a/oHHEGC", "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", "\ufffd\ufffd\u01ff\u01ff10", "");
        System.out.println(tables);
        String res = "";
        res = sfi.SFI_GetCipherPWD(res, "1", 1);
        res = sfi.SFI_GetCipherPWD(res, "2", 2);
        res = sfi.SFI_GetCipherPWD(res, "3", 3);
        res = sfi.SFI_GetCipherPWD(res, "", 2);
        res = sfi.SFI_GetCipherPWD("", "123467", 6);
        res = sfi.SFI_GetCipherPWD(res, "1", 7);
    }
}

