/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.SM2;
import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.gm.GMNamedCurves;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Certificate;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x9.X9ECParameters;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SM3Digest;
import cn.win_trust_erpc.bouncycastle.crypto.ec.CustomNamedCurves;
import cn.win_trust_erpc.bouncycastle.crypto.engines.SM2Engine;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECDomainParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.crypto.signers.SM2CodeSigner;
import cn.win_trust_erpc.bouncycastle.crypto.signers.SM2Signer;
import cn.win_trust_erpc.bouncycastle.crypto.util.PublicKeyFactory;
import cn.win_trust_erpc.bouncycastle.math.ec.ECPoint;
import cn.win_trust_erpc.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Enumeration;

public class SM2Utils {
    public static void generateKeyPair() {
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        System.out.println("publicKey:" + Util.byteToHex(publicKey.getEncoded(false)));
        System.out.println("privateKey:" + Util.byteToHex(privateKey.toByteArray()));
    }

    public static byte[] encrypt(byte[] publicKey, byte[] data) throws Exception {
        return SM2Utils.encrypt(publicKey, data, false);
    }

    public static byte[] encrypt(byte[] publicKey, byte[] data, boolean c1c3c2) throws Exception {
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        SM2 sm2 = SM2.Instance();
        ECPoint c1 = sm2.ecdp.getCurve().decodePoint(publicKey);
        ECPublicKeyParameters ecpp = new ECPublicKeyParameters(c1, sm2.ecdp);
        ParametersWithRandom pwr = new ParametersWithRandom(ecpp, new SecureRandom());
        SM2Engine engine = null;
        engine = c1c3c2 ? new SM2Engine(new SM3Digest(), SM2Engine.Mode.C1C3C2) : new SM2Engine(new SM3Digest(), SM2Engine.Mode.C1C2C3);
        engine.init(true, pwr);
        return engine.processBlock(data, 0, data.length);
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData, boolean c1c3c2) throws Exception {
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        BigInteger userD = new BigInteger(1, privateKey);
        return SM2Utils.decrypt(userD, encryptedData, c1c3c2);
    }

    public static byte[] decrypt(BigInteger userD, byte[] encryptedData, boolean c1c3c2) throws Exception {
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        SM2 sm2 = SM2.Instance();
        ECPrivateKeyParameters ecpp = new ECPrivateKeyParameters(userD, sm2.ecdp);
        SM2Engine engine = null;
        engine = c1c3c2 ? new SM2Engine(new SM3Digest(), SM2Engine.Mode.C1C3C2) : new SM2Engine(new SM3Digest(), SM2Engine.Mode.C1C2C3);
        engine.init(false, ecpp);
        return engine.processBlock(encryptedData, 0, encryptedData.length);
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws Exception {
        return SM2Utils.decrypt(privateKey, encryptedData, false);
    }

    public static byte[] decrypt(BigInteger userD, byte[] encryptedData) throws Exception {
        return SM2Utils.decrypt(userD, encryptedData, false);
    }

    public static void main1(String[] args) throws Exception {
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        String plainText = "ererfeiisgod";
        byte[] sourceData = plainText.getBytes();
        String curveName = "sm2p256v1";
        X9ECParameters ecP = CustomNamedCurves.getByName(curveName);
        if (ecP == null) {
            ecP = GMNamedCurves.getByName(curveName);
        }
        ECDomainParameters ecdp = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        ECPoint c1 = ecdp.getCurve().decodePoint(Util.hexToByte(pubk));
        ECPublicKeyParameters ecpp = new ECPublicKeyParameters(c1, ecdp);
        ParametersWithRandom pwr = new ParametersWithRandom(ecpp, new SecureRandom());
        SM2Engine sm2 = new SM2Engine();
        sm2.init(true, pwr);
        byte[] eeeep = sm2.processBlock(sourceData, 0, sourceData.length);
        System.out.println(Util.byteToHex(eeeep));
    }

    public static boolean VerifySinatureByCert(byte[] certbytes, byte[] input, byte[] signature) throws Exception {
        boolean isValid = false;
        Certificate cert = Certificate.getInstance(certbytes);
        SM2Signer signer = new SM2Signer();
        SubjectPublicKeyInfo keyInfo = cert.getSubjectPublicKeyInfo();
        AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey(keyInfo);
        signer.init(false, publicKey);
        signer.update(input, 0, input.length);
        isValid = signer.verifySignature(signature);
        return isValid;
    }

    public static boolean VerifySinature(byte[] publicKey, byte[] input, byte[] signature) throws Exception {
        boolean isValid = false;
        SM2Signer signer = new SM2Signer();
        SM2 sm2 = SM2.Instance();
        ECPoint c1 = sm2.ecdp.getCurve().decodePoint(publicKey);
        ECPublicKeyParameters ecpp = new ECPublicKeyParameters(c1, sm2.ecdp);
        signer.init(false, ecpp);
        signer.update(input, 0, input.length);
        isValid = signer.verifySignature(signature);
        return isValid;
    }

    public static boolean VerifyCodeSinature(byte[] publicKey, byte[] input, byte[] signature) throws Exception {
        boolean isValid = false;
        SM2CodeSigner signer = new SM2CodeSigner();
        SM2 sm2 = SM2.Instance();
        if (publicKey.length == 64) {
            byte[] tmpKey = new byte[65];
            tmpKey[0] = 4;
            System.arraycopy(publicKey, 0, tmpKey, 1, 64);
            publicKey = tmpKey;
        }
        ECPoint c1 = sm2.ecdp.getCurve().decodePoint(publicKey);
        ECPublicKeyParameters ecpp = new ECPublicKeyParameters(c1, sm2.ecdp);
        signer.init(false, ecpp);
        signer.update(input, 0, input.length);
        isValid = signer.verifySignature(signature);
        return isValid;
    }

    public static byte[] constructAsn1Signature(byte[] signatureRS) throws Exception {
        ASN1EncodableVector v = new ASN1EncodableVector();
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(signatureRS, 0, r, 0, 32);
        System.arraycopy(signatureRS, 32, s, 0, 32);
        v.add(new ASN1Integer(new BigInteger(1, r)));
        v.add(new ASN1Integer(new BigInteger(1, s)));
        return new DERSequence(v).getEncoded("DER");
    }

    public static byte[] constructSignature(byte[] signature_asn1) throws Exception {
        ASN1Sequence seq = ASN1Sequence.getInstance(signature_asn1);
        Enumeration e = seq.getObjects();
        BigInteger r = ((ASN1Integer)e.nextElement()).getValue();
        BigInteger s = ((ASN1Integer)e.nextElement()).getValue();
        byte[] signatureRS = new byte[64];
        byte[] r_b = BigIntegers.asUnsignedByteArray(32, r);
        byte[] s_b = BigIntegers.asUnsignedByteArray(32, s);
        System.arraycopy(r_b, 0, signatureRS, 0, 32);
        System.arraycopy(s_b, 0, signatureRS, 32, 32);
        return signatureRS;
    }

    public static boolean VerifyRS(byte[] publicKey, byte[] input, byte[] signatureRS) throws Exception {
        byte[] signature = SM2Utils.constructAsn1Signature(signatureRS);
        return SM2Utils.VerifySinature(publicKey, input, signature);
    }

    public static boolean VerifyCodeRS(byte[] publicKey, byte[] input, byte[] signatureRS) throws Exception {
        byte[] signature = SM2Utils.constructAsn1Signature(signatureRS);
        return SM2Utils.VerifyCodeSinature(publicKey, input, signature);
    }

    public static boolean VerifyRSByCert(byte[] certbytes, byte[] input, byte[] signatureRS) throws Exception {
        byte[] signature = SM2Utils.constructAsn1Signature(signatureRS);
        return SM2Utils.VerifySinatureByCert(certbytes, input, signature);
    }

    public static byte[] Sign(byte[] privateKey, byte[] input) throws Exception {
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPrivateKeyParameters ecpp = new ECPrivateKeyParameters(userD, sm2.ecdp);
        SM2Signer signer = new SM2Signer();
        signer.init(true, ecpp);
        signer.update(input, 0, input.length);
        return signer.generateSignature();
    }

    public static byte[] SignRS(byte[] privateKey, byte[] input) throws Exception {
        byte[] signature_asn1 = SM2Utils.Sign(privateKey, input);
        return SM2Utils.constructSignature(signature_asn1);
    }

    public static void main(String[] args) throws Exception {
        String plainText = "ererfeiisgod";
        byte[] sourceData = plainText.getBytes();
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        System.out.println("plainText: " + plainText);
        System.out.println(Util.byteToHex(sourceData));
        System.out.println("encrypt: ");
        byte[] cipherText = SM2Utils.encrypt(Util.hexToByte(pubk), sourceData);
        System.out.println(Util.byteToHex(cipherText));
        System.out.println("decrypt: ");
        byte[] plain = SM2Utils.decrypt(Util.hexToByte(prik), cipherText);
        System.out.println(Util.byteToHex(plain));
        byte[] signture = SM2Utils.Sign(Util.hexToByte(prik), sourceData);
        System.out.println("signture: ");
        System.out.println(Util.byteToHex(signture));
        boolean vfy = SM2Utils.VerifySinature(Util.hexToByte(pubk), plain, signture);
        System.out.println("vfy:" + vfy);
        byte[] testcert = Util.hexToByte("308201B73082015EA00302010202021212300A06082A811CCF550183753034310B300906035504061302434E310B300906035504030C0241413118301606092A864886F70D010901160941414061612E636F6D301E170D3232303532363032323634335A170D3235303631303032323634335A3034310B300906035504061302434E310B300906035504030C0241413118301606092A864886F70D010901160941414061612E636F6D3059301306072A8648CE3D020106082A811CCF5501822D03420004B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773A360305E300F0603551D130101FF040530030101FF301D0603551D0E041604146BAFBA6F30371CB22D0EEE69955944BA9BC02836301F0603551D230418301680146BAFBA6F30371CB22D0EEE69955944BA9BC02836300B0603551D0F0404030201FE300A06082A811CCF55018375034700304402201E8082A6F684E7349C26A1CFCBD54FB07D00175B6FC9F24C05BBECDF18E345A5022031D3F6141CCF0F29028BF08A432A2B1694B0794CC92690DC1ED1820A3620A763");
        boolean vfyByCert = SM2Utils.VerifySinatureByCert(testcert, plain, signture);
        System.out.println("vfyByCert:" + vfyByCert);
        byte[] rs = Util.hexToByte("3F32622BC7FDB5836B87E6B1A8B6884EB857A9A413829956DF59724FBB058517C7F62053426B4B544AA74103AD829FCEE5864F878F46C8185ACA9FE564339E9E");
        boolean vfyRS = SM2Utils.VerifyRS(Util.hexToByte(pubk), plain, rs);
        System.out.println("vfyRS:" + vfyRS);
        boolean vfyRSByCert = SM2Utils.VerifyRSByCert(testcert, plain, rs);
        System.out.println("vfyRSByCert:" + vfyRSByCert);
        boolean vfyCodeRS = SM2Utils.VerifyCodeRS(Util.hexToByte(pubk), Util.hexToByte("31323334353637383132333435363738"), Util.hexToByte("4FE4E03D055FB52DCEE62BBBB48E107B8596DB7D2D7AE48B283EA42D8792E9965BE81773D2C727D8BA96575ECBBF118E84AC070FE5FA0F954A873AAC83515B07"));
        System.out.println("vfyCodeRS:" + vfyCodeRS);
        boolean vfyCodeRS2 = SM2Utils.VerifyCodeRS(Util.hexToByte("B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773"), Util.hexToByte("31323334353637383132333435363738"), Util.hexToByte("4FE4E03D055FB52DCEE62BBBB48E107B8596DB7D2D7AE48B283EA42D8792E9965BE81773D2C727D8BA96575ECBBF118E84AC070FE5FA0F954A873AAC83515B07"));
        System.out.println("vfyCodeRS:" + vfyCodeRS2);
    }
}

