/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1.bc;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Certificate;

public class EncryptedPrivateKeyData
extends ASN1Object {
    private final EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
    private final Certificate[] certificateChain;

    public EncryptedPrivateKeyData(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] certificateChain) {
        this.encryptedPrivateKeyInfo = encryptedPrivateKeyInfo;
        this.certificateChain = new Certificate[certificateChain.length];
        System.arraycopy(certificateChain, 0, this.certificateChain, 0, certificateChain.length);
    }

    private EncryptedPrivateKeyData(ASN1Sequence seq) {
        this.encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(seq.getObjectAt(0));
        ASN1Sequence certSeq = ASN1Sequence.getInstance(seq.getObjectAt(1));
        this.certificateChain = new Certificate[certSeq.size()];
        int i = 0;
        while (i != this.certificateChain.length) {
            this.certificateChain[i] = Certificate.getInstance(certSeq.getObjectAt(i));
            ++i;
        }
    }

    public static EncryptedPrivateKeyData getInstance(Object o) {
        if (o instanceof EncryptedPrivateKeyData) {
            return (EncryptedPrivateKeyData)o;
        }
        if (o != null) {
            return new EncryptedPrivateKeyData(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public Certificate[] getCertificateChain() {
        Certificate[] tmp = new Certificate[this.certificateChain.length];
        System.arraycopy(this.certificateChain, 0, tmp, 0, this.certificateChain.length);
        return tmp;
    }

    public EncryptedPrivateKeyInfo getEncryptedPrivateKeyInfo() {
        return this.encryptedPrivateKeyInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(this.encryptedPrivateKeyInfo);
        v.add(new DERSequence(this.certificateChain));
        return new DERSequence(v);
    }
}

