/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1.cmp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1BitString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1TaggedObject;
import cn.win_trust_erpc.bouncycastle.asn1.DERBitString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIFailureInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIFreeText;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIStatus;
import java.math.BigInteger;

public class PKIStatusInfo
extends ASN1Object {
    ASN1Integer status;
    PKIFreeText statusString;
    ASN1BitString failInfo;

    public static PKIStatusInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIStatusInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static PKIStatusInfo getInstance(Object obj) {
        if (obj instanceof PKIStatusInfo) {
            return (PKIStatusInfo)obj;
        }
        if (obj != null) {
            return new PKIStatusInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PKIStatusInfo(ASN1Sequence seq) {
        this.status = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.statusString = null;
        this.failInfo = null;
        if (seq.size() > 2) {
            this.statusString = PKIFreeText.getInstance(seq.getObjectAt(1));
            this.failInfo = DERBitString.getInstance(seq.getObjectAt(2));
        } else if (seq.size() > 1) {
            ASN1Encodable obj = seq.getObjectAt(1);
            if (obj instanceof ASN1BitString) {
                this.failInfo = ASN1BitString.getInstance(obj);
            } else {
                this.statusString = PKIFreeText.getInstance(obj);
            }
        }
    }

    public PKIStatusInfo(PKIStatus status) {
        this.status = ASN1Integer.getInstance(status.toASN1Primitive());
    }

    public PKIStatusInfo(PKIStatus status, PKIFreeText statusString) {
        this.status = ASN1Integer.getInstance(status.toASN1Primitive());
        this.statusString = statusString;
    }

    public PKIStatusInfo(PKIStatus status, PKIFreeText statusString, PKIFailureInfo failInfo) {
        this.status = ASN1Integer.getInstance(status.toASN1Primitive());
        this.statusString = statusString;
        this.failInfo = failInfo;
    }

    public BigInteger getStatus() {
        return this.status.getValue();
    }

    public PKIFreeText getStatusString() {
        return this.statusString;
    }

    public ASN1BitString getFailInfo() {
        return this.failInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add(this.status);
        if (this.statusString != null) {
            v.add(this.statusString);
        }
        if (this.failInfo != null) {
            v.add(this.failInfo);
        }
        return new DERSequence(v);
    }
}

