/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1.tsp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.tsp.ArchiveTimeStampChain;
import java.util.Enumeration;

public class ArchiveTimeStampSequence
extends ASN1Object {
    private ASN1Sequence archiveTimeStampChains;

    public static ArchiveTimeStampSequence getInstance(Object obj) {
        if (obj instanceof ArchiveTimeStampChain) {
            return (ArchiveTimeStampSequence)obj;
        }
        if (obj != null) {
            return new ArchiveTimeStampSequence(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private ArchiveTimeStampSequence(ASN1Sequence sequence) throws IllegalArgumentException {
        ASN1EncodableVector vector = new ASN1EncodableVector(sequence.size());
        Enumeration objects = sequence.getObjects();
        while (objects.hasMoreElements()) {
            vector.add(ArchiveTimeStampChain.getInstance(objects.nextElement()));
        }
        this.archiveTimeStampChains = new DERSequence(vector);
    }

    public ArchiveTimeStampSequence(ArchiveTimeStampChain archiveTimeStampChain) {
        this.archiveTimeStampChains = new DERSequence(archiveTimeStampChain);
    }

    public ArchiveTimeStampSequence(ArchiveTimeStampChain[] archiveTimeStampChains) {
        this.archiveTimeStampChains = new DERSequence(archiveTimeStampChains);
    }

    public ArchiveTimeStampChain[] getArchiveTimeStampChains() {
        ArchiveTimeStampChain[] rv = new ArchiveTimeStampChain[this.archiveTimeStampChains.size()];
        int i = 0;
        while (i != rv.length) {
            rv[i] = ArchiveTimeStampChain.getInstance(this.archiveTimeStampChains.getObjectAt(i));
            ++i;
        }
        return rv;
    }

    public int size() {
        return this.archiveTimeStampChains.size();
    }

    public ArchiveTimeStampSequence append(ArchiveTimeStampChain chain) {
        ASN1EncodableVector v = new ASN1EncodableVector(this.archiveTimeStampChains.size() + 1);
        int i = 0;
        while (i != this.archiveTimeStampChains.size()) {
            v.add(this.archiveTimeStampChains.getObjectAt(i));
            ++i;
        }
        v.add(chain);
        return new ArchiveTimeStampSequence(new DERSequence(v));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.archiveTimeStampChains;
    }
}

