/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1.x509;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1TaggedObject;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Extensions;
import cn.win_trust_erpc.bouncycastle.asn1.x509.GeneralName;
import cn.win_trust_erpc.bouncycastle.util.Strings;

public class GeneralNames
extends ASN1Object {
    private final GeneralName[] names;

    private static GeneralName[] copy(GeneralName[] names) {
        GeneralName[] result = new GeneralName[names.length];
        System.arraycopy(names, 0, result, 0, names.length);
        return result;
    }

    public static GeneralNames getInstance(Object obj) {
        if (obj instanceof GeneralNames) {
            return (GeneralNames)obj;
        }
        if (obj != null) {
            return new GeneralNames(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static GeneralNames getInstance(ASN1TaggedObject obj, boolean explicit) {
        return new GeneralNames(ASN1Sequence.getInstance(obj, explicit));
    }

    public static GeneralNames fromExtensions(Extensions extensions, ASN1ObjectIdentifier extOID) {
        return GeneralNames.getInstance(Extensions.getExtensionParsedValue(extensions, extOID));
    }

    public GeneralNames(GeneralName name) {
        this.names = new GeneralName[]{name};
    }

    public GeneralNames(GeneralName[] names) {
        this.names = GeneralNames.copy(names);
    }

    private GeneralNames(ASN1Sequence seq) {
        this.names = new GeneralName[seq.size()];
        int i = 0;
        while (i != seq.size()) {
            this.names[i] = GeneralName.getInstance(seq.getObjectAt(i));
            ++i;
        }
    }

    public GeneralName[] getNames() {
        return GeneralNames.copy(this.names);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.names);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String sep = Strings.lineSeparator();
        buf.append("GeneralNames:");
        buf.append(sep);
        int i = 0;
        while (i != this.names.length) {
            buf.append("    ");
            buf.append(this.names[i]);
            buf.append(sep);
            ++i;
        }
        return buf.toString();
    }
}

