/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cert.cmp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1GeneralizedTime;
import cn.win_trust_erpc.bouncycastle.asn1.DERBitString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.CMPCertificate;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.InfoTypeAndValue;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIBody;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIFreeText;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIHeader;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIMessage;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.GeneralName;
import cn.win_trust_erpc.bouncycastle.cert.X509CertificateHolder;
import cn.win_trust_erpc.bouncycastle.cert.cmp.CMPException;
import cn.win_trust_erpc.bouncycastle.cert.cmp.ProtectedPKIMessage;
import cn.win_trust_erpc.bouncycastle.operator.ContentSigner;
import cn.win_trust_erpc.bouncycastle.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProtectedPKIMessageBuilder {
    private PKIHeaderBuilder hdrBuilder;
    private PKIBody body;
    private List generalInfos = new ArrayList();
    private List extraCerts = new ArrayList();

    public ProtectedPKIMessageBuilder(GeneralName sender, GeneralName recipient) {
        this(2, sender, recipient);
    }

    public ProtectedPKIMessageBuilder(int pvno, GeneralName sender, GeneralName recipient) {
        this.hdrBuilder = new PKIHeaderBuilder(pvno, sender, recipient);
    }

    public ProtectedPKIMessageBuilder setTransactionID(byte[] tid) {
        this.hdrBuilder.setTransactionID(tid);
        return this;
    }

    public ProtectedPKIMessageBuilder setFreeText(PKIFreeText freeText) {
        this.hdrBuilder.setFreeText(freeText);
        return this;
    }

    public ProtectedPKIMessageBuilder addGeneralInfo(InfoTypeAndValue genInfo) {
        this.generalInfos.add(genInfo);
        return this;
    }

    public ProtectedPKIMessageBuilder setMessageTime(Date time) {
        this.hdrBuilder.setMessageTime(new ASN1GeneralizedTime(time));
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipKID(byte[] kid) {
        this.hdrBuilder.setRecipKID(kid);
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipNonce(byte[] nonce) {
        this.hdrBuilder.setRecipNonce(nonce);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderKID(byte[] kid) {
        this.hdrBuilder.setSenderKID(kid);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderNonce(byte[] nonce) {
        this.hdrBuilder.setSenderNonce(nonce);
        return this;
    }

    public ProtectedPKIMessageBuilder setBody(PKIBody body2) {
        this.body = body2;
        return this;
    }

    public ProtectedPKIMessageBuilder addCMPCertificate(X509CertificateHolder extraCert) {
        this.extraCerts.add(extraCert);
        return this;
    }

    public ProtectedPKIMessage build(MacCalculator macCalculator) throws CMPException {
        if (this.body == null) {
            throw new IllegalStateException("body must be set before building");
        }
        this.finaliseHeader(macCalculator.getAlgorithmIdentifier());
        PKIHeader header = this.hdrBuilder.build();
        try {
            DERBitString protection = new DERBitString(this.calculateMac(macCalculator, header, this.body));
            return this.finaliseMessage(header, protection);
        }
        catch (IOException e) {
            throw new CMPException("unable to encode MAC input: " + e.getMessage(), e);
        }
    }

    public ProtectedPKIMessage build(ContentSigner signer) throws CMPException {
        if (this.body == null) {
            throw new IllegalStateException("body must be set before building");
        }
        this.finaliseHeader(signer.getAlgorithmIdentifier());
        PKIHeader header = this.hdrBuilder.build();
        try {
            DERBitString protection = new DERBitString(this.calculateSignature(signer, header, this.body));
            return this.finaliseMessage(header, protection);
        }
        catch (IOException e) {
            throw new CMPException("unable to encode signature input: " + e.getMessage(), e);
        }
    }

    private void finaliseHeader(AlgorithmIdentifier algorithmIdentifier) {
        this.hdrBuilder.setProtectionAlg(algorithmIdentifier);
        if (!this.generalInfos.isEmpty()) {
            InfoTypeAndValue[] genInfos = new InfoTypeAndValue[this.generalInfos.size()];
            this.hdrBuilder.setGeneralInfo(this.generalInfos.toArray(genInfos));
        }
    }

    private ProtectedPKIMessage finaliseMessage(PKIHeader header, DERBitString protection) {
        if (!this.extraCerts.isEmpty()) {
            CMPCertificate[] cmpCerts = new CMPCertificate[this.extraCerts.size()];
            int i = 0;
            while (i != cmpCerts.length) {
                cmpCerts[i] = new CMPCertificate(((X509CertificateHolder)this.extraCerts.get(i)).toASN1Structure());
                ++i;
            }
            return new ProtectedPKIMessage(new PKIMessage(header, this.body, protection, cmpCerts));
        }
        return new ProtectedPKIMessage(new PKIMessage(header, this.body, protection));
    }

    private byte[] calculateSignature(ContentSigner signer, PKIHeader header, PKIBody body2) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(header);
        v.add(body2);
        OutputStream sOut = signer.getOutputStream();
        sOut.write(new DERSequence(v).getEncoded("DER"));
        sOut.close();
        return signer.getSignature();
    }

    private byte[] calculateMac(MacCalculator macCalculator, PKIHeader header, PKIBody body2) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(header);
        v.add(body2);
        OutputStream sOut = macCalculator.getOutputStream();
        sOut.write(new DERSequence(v).getEncoded("DER"));
        sOut.close();
        return macCalculator.getMac();
    }
}

