/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cert.ocsp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Exception;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1InputStream;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.OCSPResponse;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.ResponseBytes;
import cn.win_trust_erpc.bouncycastle.cert.CertIOException;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.BasicOCSPResp;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.OCSPException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OCSPResp {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse resp) {
        this.resp = resp;
    }

    public OCSPResp(byte[] resp) throws IOException {
        this(new ByteArrayInputStream(resp));
    }

    public OCSPResp(InputStream resp) throws IOException {
        this(new ASN1InputStream(resp));
    }

    private OCSPResp(ASN1InputStream aIn) throws IOException {
        try {
            this.resp = OCSPResponse.getInstance(aIn.readObject());
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
        catch (ASN1Exception e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
        if (this.resp == null) {
            throw new CertIOException("malformed response: no response data found");
        }
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getIntValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes rb = this.resp.getResponseBytes();
        if (rb == null) {
            return null;
        }
        if (rb.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1Primitive obj = ASN1Primitive.fromByteArray(rb.getResponse().getOctets());
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(obj));
            }
            catch (Exception e) {
                throw new OCSPException("problem decoding object: " + e, e);
            }
        }
        return rb.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCSPResp)) {
            return false;
        }
        OCSPResp r = (OCSPResp)o;
        return this.resp.equals(r.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }

    public OCSPResponse toASN1Structure() {
        return this.resp;
    }
}

