/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cert.ocsp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.ResponseData;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.SingleResponse;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Extensions;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.OCSPUtils;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.RespID;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.SingleResp;
import java.util.Date;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData data) {
        this.data = data;
    }

    public int getVersion() {
        return this.data.getVersion().intValueExact() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        int i = 0;
        while (i != rs.length) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
            ++i;
        }
        return rs;
    }

    public Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

