/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cert.ocsp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.CertStatus;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.RevokedInfo;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.SingleResponse;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Extension;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Extensions;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.CertificateID;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.CertificateStatus;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.OCSPUtils;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.RevokedStatus;
import cn.win_trust_erpc.bouncycastle.cert.ocsp.UnknownStatus;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class SingleResp {
    private SingleResponse resp;
    private Extensions extensions;

    public SingleResp(SingleResponse resp) {
        this.resp = resp;
        this.extensions = resp.getSingleExtensions();
    }

    public CertificateID getCertID() {
        return new CertificateID(this.resp.getCertID());
    }

    public CertificateStatus getCertStatus() {
        CertStatus s = this.resp.getCertStatus();
        if (s.getTagNo() == 0) {
            return null;
        }
        if (s.getTagNo() == 1) {
            return new RevokedStatus(RevokedInfo.getInstance(s.getStatus()));
        }
        return new UnknownStatus();
    }

    public Date getThisUpdate() {
        return OCSPUtils.extractDate(this.resp.getThisUpdate());
    }

    public Date getNextUpdate() {
        if (this.resp.getNextUpdate() == null) {
            return null;
        }
        return OCSPUtils.extractDate(this.resp.getNextUpdate());
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return OCSPUtils.getExtensionOIDs(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return OCSPUtils.getCriticalExtensionOIDs(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return OCSPUtils.getNonCriticalExtensionOIDs(this.extensions);
    }
}

