/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cert.path.validations;

import cn.win_trust_erpc.bouncycastle.asn1.x509.BasicConstraints;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Extension;
import cn.win_trust_erpc.bouncycastle.cert.X509CertificateHolder;
import cn.win_trust_erpc.bouncycastle.cert.path.CertPathValidation;
import cn.win_trust_erpc.bouncycastle.cert.path.CertPathValidationContext;
import cn.win_trust_erpc.bouncycastle.cert.path.CertPathValidationException;
import cn.win_trust_erpc.bouncycastle.util.BigIntegers;
import cn.win_trust_erpc.bouncycastle.util.Integers;
import cn.win_trust_erpc.bouncycastle.util.Memoable;
import java.math.BigInteger;

public class BasicConstraintsValidation
implements CertPathValidation {
    private boolean previousCertWasCA = true;
    private Integer maxPathLength = null;
    private boolean isMandatory = true;

    public BasicConstraintsValidation() {
        this(true);
    }

    public BasicConstraintsValidation(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    @Override
    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        BigInteger bigPathLen;
        context.addHandledExtension(Extension.basicConstraints);
        if (!this.previousCertWasCA) {
            throw new CertPathValidationException("Basic constraints violated: issuer is not a CA");
        }
        BasicConstraints bc = BasicConstraints.fromExtensions(certificate.getExtensions());
        boolean bl = this.previousCertWasCA = bc != null && bc.isCA() || bc == null && !this.isMandatory;
        if (this.maxPathLength != null && !certificate.getSubject().equals(certificate.getIssuer())) {
            if (this.maxPathLength < 0) {
                throw new CertPathValidationException("Basic constraints violated: path length exceeded");
            }
            this.maxPathLength = Integers.valueOf(this.maxPathLength - 1);
        }
        if (bc != null && (bigPathLen = bc.getPathLenConstraint()) != null) {
            int newPathLength = BigIntegers.intValueExact(bigPathLen);
            this.maxPathLength = this.maxPathLength == null ? Integers.valueOf(newPathLength) : Integers.valueOf(Math.min(newPathLength, this.maxPathLength));
        }
    }

    @Override
    public Memoable copy() {
        BasicConstraintsValidation result = new BasicConstraintsValidation();
        result.isMandatory = this.isMandatory;
        result.previousCertWasCA = this.previousCertWasCA;
        result.maxPathLength = this.maxPathLength;
        return result;
    }

    @Override
    public void reset(Memoable other) {
        BasicConstraintsValidation otherBCV = (BasicConstraintsValidation)other;
        this.isMandatory = otherBCV.isMandatory;
        this.previousCertWasCA = otherBCV.previousCertWasCA;
        this.maxPathLength = otherBCV.maxPathLength;
    }
}

