/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Set;
import cn.win_trust_erpc.bouncycastle.asn1.cms.AttributeTable;
import cn.win_trust_erpc.bouncycastle.asn1.cms.AuthEnvelopedData;
import cn.win_trust_erpc.bouncycastle.asn1.cms.ContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.EncryptedContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.cms.AuthAttributesProvider;
import cn.win_trust_erpc.bouncycastle.cms.CMSEnvelopedHelper;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.CMSSecureReadable;
import cn.win_trust_erpc.bouncycastle.cms.CMSUtils;
import cn.win_trust_erpc.bouncycastle.cms.OriginatorInformation;
import cn.win_trust_erpc.bouncycastle.cms.RecipientInformationStore;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.Encodable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSAuthEnvelopedData
implements Encodable {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private OriginatorInformation originatorInfo;
    private AlgorithmIdentifier authEncAlg;
    private ASN1Set authAttrs;
    private byte[] mac;
    private ASN1Set unauthAttrs;

    public CMSAuthEnvelopedData(byte[] authEnvData) throws CMSException {
        this(CMSUtils.readContentInfo(authEnvData));
    }

    public CMSAuthEnvelopedData(InputStream authEnvData) throws CMSException {
        this(CMSUtils.readContentInfo(authEnvData));
    }

    public CMSAuthEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        AuthEnvelopedData authEnvData = AuthEnvelopedData.getInstance(contentInfo.getContent());
        if (authEnvData.getOriginatorInfo() != null) {
            this.originatorInfo = new OriginatorInformation(authEnvData.getOriginatorInfo());
        }
        ASN1Set recipientInfos = authEnvData.getRecipientInfos();
        final EncryptedContentInfo authEncInfo = authEnvData.getAuthEncryptedContentInfo();
        this.authEncAlg = authEncInfo.getContentEncryptionAlgorithm();
        this.mac = authEnvData.getMac().getOctets();
        CMSSecureReadable secureReadable = new CMSSecureReadable(){

            @Override
            public ASN1ObjectIdentifier getContentType() {
                return authEncInfo.getContentType();
            }

            @Override
            public InputStream getInputStream() throws IOException, CMSException {
                return new ByteArrayInputStream(Arrays.concatenate(authEncInfo.getEncryptedContent().getOctets(), CMSAuthEnvelopedData.this.mac));
            }
        };
        this.authAttrs = authEnvData.getAuthAttrs();
        this.unauthAttrs = authEnvData.getUnauthAttrs();
        this.recipientInfoStore = this.authAttrs != null ? CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.authEncAlg, secureReadable, new AuthAttributesProvider(){

            @Override
            public ASN1Set getAuthAttributes() {
                return CMSAuthEnvelopedData.this.authAttrs;
            }

            @Override
            public boolean isAead() {
                return true;
            }
        }) : CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.authEncAlg, secureReadable);
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.originatorInfo;
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public AttributeTable getAuthAttrs() {
        if (this.authAttrs == null) {
            return null;
        }
        return new AttributeTable(this.authAttrs);
    }

    public AttributeTable getUnauthAttrs() {
        if (this.unauthAttrs == null) {
            return null;
        }
        return new AttributeTable(this.unauthAttrs);
    }

    public byte[] getMac() {
        return Arrays.clone(this.mac);
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

