/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms.bc;

import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.RecipientOperator;
import cn.win_trust_erpc.bouncycastle.cms.bc.BcKEKRecipient;
import cn.win_trust_erpc.bouncycastle.cms.bc.EnvelopedDataHelper;
import cn.win_trust_erpc.bouncycastle.crypto.BufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.StreamCipher;
import cn.win_trust_erpc.bouncycastle.crypto.io.CipherInputStream;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.operator.InputDecryptor;
import cn.win_trust_erpc.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;
import java.io.InputStream;

public class BcKEKEnvelopedRecipient
extends BcKEKRecipient {
    public BcKEKEnvelopedRecipient(BcSymmetricKeyUnwrapper unwrapper) {
        super(unwrapper);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        KeyParameter secretKey = (KeyParameter)this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataOut) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataOut, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataOut, (StreamCipher)dataCipher);
            }
        });
    }
}

