/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.digests;

import cn.win_trust_erpc.bouncycastle.util.Arrays;

public class XofUtils {
    public static byte[] leftEncode(long strLen) {
        int n = 1;
        long v = strLen;
        while ((v >>= 8) != 0L) {
            n = (byte)(n + 1);
        }
        byte[] b = new byte[n + 1];
        b[0] = n;
        int i = 1;
        while (i <= n) {
            b[i] = (byte)(strLen >> 8 * (n - i));
            ++i;
        }
        return b;
    }

    public static byte[] rightEncode(long strLen) {
        int n = 1;
        long v = strLen;
        while ((v >>= 8) != 0L) {
            n = (byte)(n + 1);
        }
        byte[] b = new byte[n + 1];
        b[n] = n;
        int i = 0;
        while (i < n) {
            b[i] = (byte)(strLen >> 8 * (n - i - 1));
            ++i;
        }
        return b;
    }

    static byte[] encode(byte X) {
        return Arrays.concatenate(XofUtils.leftEncode(8L), new byte[]{X});
    }

    static byte[] encode(byte[] in, int inOff, int len) {
        if (in.length == len) {
            return Arrays.concatenate(XofUtils.leftEncode(len * 8), in);
        }
        return Arrays.concatenate(XofUtils.leftEncode(len * 8), Arrays.copyOfRange(in, inOff, inOff + len));
    }
}

