/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.engines;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.crypto.engines.GOST28147Engine;
import cn.win_trust_erpc.bouncycastle.crypto.engines.GOST28147WrapEngine;
import cn.win_trust_erpc.bouncycastle.crypto.modes.GCFBBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithIV;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithSBox;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithUKM;
import cn.win_trust_erpc.bouncycastle.util.Pack;

public class CryptoProWrapEngine
extends GOST28147WrapEngine {
    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        KeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom pr = (ParametersWithRandom)param;
            param = pr.getParameters();
        }
        ParametersWithUKM pU = (ParametersWithUKM)param;
        byte[] sBox = null;
        if (pU.getParameters() instanceof ParametersWithSBox) {
            kParam = (KeyParameter)((ParametersWithSBox)pU.getParameters()).getParameters();
            sBox = ((ParametersWithSBox)pU.getParameters()).getSBox();
        } else {
            kParam = (KeyParameter)pU.getParameters();
        }
        kParam = new KeyParameter(CryptoProWrapEngine.cryptoProDiversify(kParam.getKey(), pU.getUKM(), sBox));
        if (sBox != null) {
            super.init(forWrapping, new ParametersWithUKM(new ParametersWithSBox(kParam, sBox), pU.getUKM()));
        } else {
            super.init(forWrapping, new ParametersWithUKM(kParam, pU.getUKM()));
        }
    }

    private static byte[] cryptoProDiversify(byte[] K, byte[] ukm, byte[] sBox) {
        int i = 0;
        while (i != 8) {
            int sOn = 0;
            int sOff = 0;
            int j = 0;
            while (j != 8) {
                int kj = Pack.littleEndianToInt(K, j * 4);
                if (CryptoProWrapEngine.bitSet(ukm[i], j)) {
                    sOn += kj;
                } else {
                    sOff += kj;
                }
                ++j;
            }
            byte[] s = new byte[8];
            Pack.intToLittleEndian(sOn, s, 0);
            Pack.intToLittleEndian(sOff, s, 4);
            GCFBBlockCipher c = new GCFBBlockCipher(new GOST28147Engine());
            c.init(true, new ParametersWithIV(new ParametersWithSBox(new KeyParameter(K), sBox), s));
            c.processBlock(K, 0, K, 0);
            c.processBlock(K, 8, K, 8);
            c.processBlock(K, 16, K, 16);
            c.processBlock(K, 24, K, 24);
            ++i;
        }
        return K;
    }

    private static boolean bitSet(byte v, int bitNo) {
        return (v & 1 << bitNo) != 0;
    }
}

