/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.generators;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

