/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.params;

import cn.win_trust_erpc.bouncycastle.crypto.params.DESParameters;

public class DESedeParameters
extends DESParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public DESedeParameters(byte[] key) {
        super(key);
        if (DESedeParameters.isWeakKey(key, 0, key.length)) {
            throw new IllegalArgumentException("attempt to create weak DESede key");
        }
    }

    public static boolean isWeakKey(byte[] key, int offset, int length) {
        int i = offset;
        while (i < length) {
            if (DESParameters.isWeakKey(key, i)) {
                return true;
            }
            i += 8;
        }
        return false;
    }

    public static boolean isWeakKey(byte[] key, int offset) {
        return DESedeParameters.isWeakKey(key, offset, key.length - offset);
    }

    public static boolean isRealEDEKey(byte[] key, int offset) {
        return key.length == 16 ? DESedeParameters.isReal2Key(key, offset) : DESedeParameters.isReal3Key(key, offset);
    }

    public static boolean isReal2Key(byte[] key, int offset) {
        boolean isValid = false;
        int i = offset;
        while (i != offset + 8) {
            if (key[i] != key[i + 8]) {
                isValid = true;
            }
            ++i;
        }
        return isValid;
    }

    public static boolean isReal3Key(byte[] key, int offset) {
        boolean diff12 = false;
        boolean diff13 = false;
        boolean diff23 = false;
        int i = offset;
        while (i != offset + 8) {
            diff12 |= key[i] != key[i + 8];
            diff13 |= key[i] != key[i + 16];
            diff23 |= key[i + 8] != key[i + 16];
            ++i;
        }
        return diff12 && diff13 && diff23;
    }
}

