/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.params;

import cn.win_trust_erpc.SM2;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1OctetString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECDomainParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECKeyParameters;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECPrivateKeyParameters
extends ECKeyParameters {
    private final BigInteger d;

    public ECPrivateKeyParameters(BigInteger d, ECDomainParameters parameters) {
        super(true, parameters);
        this.d = parameters.validatePrivateScalar(d);
    }

    public BigInteger getD() {
        return this.d;
    }

    public ECPrivateKeyParameters(byte[] asn1) {
        super(true, SM2.Instance().ecdp);
        ASN1Sequence seq = ASN1Sequence.getInstance(asn1);
        Enumeration e = seq.getObjects();
        BigInteger version = ((ASN1Integer)e.nextElement()).getValue();
        BigInteger d = BigInteger.ONE;
        try {
            ASN1OctetString octestString = (ASN1OctetString)e.nextElement();
            byte[] tt = octestString.getOctets();
            d = new BigInteger(tt);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.d = d;
    }
}

