/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.util;

import cn.win_trust_erpc.bouncycastle.crypto.AlphabetMapper;
import java.util.HashMap;
import java.util.Map;

public class BasicAlphabetMapper
implements AlphabetMapper {
    private Map<Character, Integer> indexMap = new HashMap<Character, Integer>();
    private Map<Integer, Character> charMap = new HashMap<Integer, Character>();

    public BasicAlphabetMapper(String alphabet) {
        this(alphabet.toCharArray());
    }

    public BasicAlphabetMapper(char[] alphabet) {
        int i = 0;
        while (i != alphabet.length) {
            if (this.indexMap.containsKey(Character.valueOf(alphabet[i]))) {
                throw new IllegalArgumentException("duplicate key detected in alphabet: " + alphabet[i]);
            }
            this.indexMap.put(Character.valueOf(alphabet[i]), i);
            this.charMap.put(i, Character.valueOf(alphabet[i]));
            ++i;
        }
    }

    @Override
    public int getRadix() {
        return this.indexMap.size();
    }

    @Override
    public byte[] convertToIndexes(char[] input) {
        byte[] out;
        if (this.indexMap.size() <= 256) {
            out = new byte[input.length];
            int i = 0;
            while (i != input.length) {
                out[i] = this.indexMap.get(Character.valueOf(input[i])).byteValue();
                ++i;
            }
        } else {
            out = new byte[input.length * 2];
            int i = 0;
            while (i != input.length) {
                int idx = this.indexMap.get(Character.valueOf(input[i]));
                out[i * 2] = (byte)(idx >> 8 & 0xFF);
                out[i * 2 + 1] = (byte)(idx & 0xFF);
                ++i;
            }
        }
        return out;
    }

    @Override
    public char[] convertToChars(byte[] input) {
        char[] out;
        if (this.charMap.size() <= 256) {
            out = new char[input.length];
            int i = 0;
            while (i != input.length) {
                out[i] = this.charMap.get(input[i] & 0xFF).charValue();
                ++i;
            }
        } else {
            if ((input.length & 1) != 0) {
                throw new IllegalArgumentException("two byte radix and input string odd length");
            }
            out = new char[input.length / 2];
            int i = 0;
            while (i != input.length) {
                out[i / 2] = this.charMap.get(input[i] << 8 & 0xFF00 | input[i + 1] & 0xFF).charValue();
                i += 2;
            }
        }
        return out;
    }
}

