/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.edec;

import cn.win_trust_erpc.bouncycastle.crypto.DerivationFunction;
import cn.win_trust_erpc.bouncycastle.crypto.RawAgreement;
import cn.win_trust_erpc.bouncycastle.crypto.agreement.X25519Agreement;
import cn.win_trust_erpc.bouncycastle.crypto.agreement.X448Agreement;
import cn.win_trust_erpc.bouncycastle.crypto.agreement.XDHUnifiedAgreement;
import cn.win_trust_erpc.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.generators.KDF2BytesGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.X448PrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.XDHUPrivateParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.XDHUPublicParameters;
import cn.win_trust_erpc.bouncycastle.crypto.util.DigestFactory;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import cn.win_trust_erpc.bouncycastle.jcajce.spec.DHUParameterSpec;
import cn.win_trust_erpc.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private RawAgreement agreement;
    private DHUParameterSpec dhuSpec;
    private byte[] result;

    KeyAgreementSpi(String algorithm) {
        super(algorithm, null);
    }

    KeyAgreementSpi(String algorithm, DerivationFunction kdf) {
        super(algorithm, kdf);
    }

    @Override
    protected byte[] calcSecret() {
        return this.result;
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        AsymmetricKeyParameter priv = KeyAgreementSpi.getLwXDHKeyPrivate(key);
        if (priv instanceof X25519PrivateKeyParameters) {
            this.agreement = this.getAgreement("X25519");
        } else if (priv instanceof X448PrivateKeyParameters) {
            this.agreement = this.getAgreement("X448");
        } else {
            throw new IllegalStateException("unsupported private key type");
        }
        this.agreement.init(priv);
        this.ukmParameters = (byte[])(this.kdf != null ? new byte[0] : null);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter priv = KeyAgreementSpi.getLwXDHKeyPrivate(key);
        if (priv instanceof X25519PrivateKeyParameters) {
            this.agreement = this.getAgreement("X25519");
        } else if (priv instanceof X448PrivateKeyParameters) {
            this.agreement = this.getAgreement("X448");
        } else {
            throw new IllegalStateException("unsupported private key type");
        }
        this.ukmParameters = null;
        if (params instanceof DHUParameterSpec) {
            if (this.kaAlgorithm.indexOf(85) < 0) {
                throw new InvalidAlgorithmParameterException("agreement algorithm not DHU based");
            }
            this.dhuSpec = (DHUParameterSpec)params;
            this.ukmParameters = this.dhuSpec.getUserKeyingMaterial();
            this.agreement.init(new XDHUPrivateParameters(priv, ((BCXDHPrivateKey)this.dhuSpec.getEphemeralPrivateKey()).engineGetKeyParameters(), ((BCXDHPublicKey)this.dhuSpec.getEphemeralPublicKey()).engineGetKeyParameters()));
        } else {
            this.agreement.init(priv);
            if (params instanceof UserKeyingMaterialSpec) {
                if (this.kdf == null) {
                    throw new InvalidAlgorithmParameterException("no KDF specified for UserKeyingMaterialSpec");
                }
                this.ukmParameters = ((UserKeyingMaterialSpec)params).getUserKeyingMaterial();
            } else {
                throw new InvalidAlgorithmParameterException("unknown ParameterSpec");
            }
        }
        if (this.kdf != null && this.ukmParameters == null) {
            this.ukmParameters = new byte[0];
        }
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.agreement == null) {
            throw new IllegalStateException(String.valueOf(this.kaAlgorithm) + " not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException(String.valueOf(this.kaAlgorithm) + " can only be between two parties.");
        }
        AsymmetricKeyParameter pub = this.getLwXDHKeyPublic(key);
        this.result = new byte[this.agreement.getAgreementSize()];
        if (this.dhuSpec != null) {
            this.agreement.calculateAgreement(new XDHUPublicParameters(pub, ((BCXDHPublicKey)this.dhuSpec.getOtherPartyEphemeralKey()).engineGetKeyParameters()), this.result, 0);
        } else {
            this.agreement.calculateAgreement(pub, this.result, 0);
        }
        return null;
    }

    private RawAgreement getAgreement(String alg) throws InvalidKeyException {
        if (!this.kaAlgorithm.equals("XDH") && !this.kaAlgorithm.startsWith(alg)) {
            throw new InvalidKeyException("inappropriate key for " + this.kaAlgorithm);
        }
        if (this.kaAlgorithm.indexOf(85) > 0) {
            if (alg.startsWith("X448")) {
                return new XDHUnifiedAgreement(new X448Agreement());
            }
            return new XDHUnifiedAgreement(new X25519Agreement());
        }
        if (alg.startsWith("X448")) {
            return new X448Agreement();
        }
        return new X25519Agreement();
    }

    private static AsymmetricKeyParameter getLwXDHKeyPrivate(Key key) throws InvalidKeyException {
        if (key instanceof BCXDHPrivateKey) {
            return ((BCXDHPrivateKey)key).engineGetKeyParameters();
        }
        throw new InvalidKeyException("cannot identify XDH private key");
    }

    private AsymmetricKeyParameter getLwXDHKeyPublic(Key key) throws InvalidKeyException {
        if (key instanceof BCXDHPublicKey) {
            return ((BCXDHPublicKey)key).engineGetKeyParameters();
        }
        throw new InvalidKeyException("cannot identify XDH public key");
    }

    public static final class X25519
    extends KeyAgreementSpi {
        public X25519() {
            super("X25519");
        }
    }

    public static class X25519UwithSHA256CKDF
    extends KeyAgreementSpi {
        public X25519UwithSHA256CKDF() {
            super("X25519UwithSHA256CKDF", new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class X25519UwithSHA256KDF
    extends KeyAgreementSpi {
        public X25519UwithSHA256KDF() {
            super("X25519UwithSHA256KDF", new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static final class X25519withSHA256CKDF
    extends KeyAgreementSpi {
        public X25519withSHA256CKDF() {
            super("X25519withSHA256CKDF", new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static final class X25519withSHA256KDF
    extends KeyAgreementSpi {
        public X25519withSHA256KDF() {
            super("X25519withSHA256KDF", new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class X25519withSHA384CKDF
    extends KeyAgreementSpi {
        public X25519withSHA384CKDF() {
            super("X25519withSHA384CKDF", new ConcatenationKDFGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class X25519withSHA512CKDF
    extends KeyAgreementSpi {
        public X25519withSHA512CKDF() {
            super("X25519withSHA512CKDF", new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static final class X448
    extends KeyAgreementSpi {
        public X448() {
            super("X448");
        }
    }

    public static class X448UwithSHA512CKDF
    extends KeyAgreementSpi {
        public X448UwithSHA512CKDF() {
            super("X448UwithSHA512CKDF", new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class X448UwithSHA512KDF
    extends KeyAgreementSpi {
        public X448UwithSHA512KDF() {
            super("X448UwithSHA512KDF", new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static final class X448withSHA256CKDF
    extends KeyAgreementSpi {
        public X448withSHA256CKDF() {
            super("X448withSHA256CKDF", new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class X448withSHA384CKDF
    extends KeyAgreementSpi {
        public X448withSHA384CKDF() {
            super("X448withSHA384CKDF", new ConcatenationKDFGenerator(DigestFactory.createSHA384()));
        }
    }

    public static final class X448withSHA512CKDF
    extends KeyAgreementSpi {
        public X448withSHA512CKDF() {
            super("X448withSHA512CKDF", new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static final class X448withSHA512KDF
    extends KeyAgreementSpi {
        public X448withSHA512KDF() {
            super("X448withSHA512KDF", new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static final class XDH
    extends KeyAgreementSpi {
        public XDH() {
            super("XDH");
        }
    }
}

