/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.digest;

import cn.win_trust_erpc.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA384Digest;
import cn.win_trust_erpc.bouncycastle.crypto.macs.HMac;
import cn.win_trust_erpc.bouncycastle.crypto.macs.OldHMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class SHA384 {
    private SHA384() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA384Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new SHA384Digest((SHA384Digest)this.digest);
            return d;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA384Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA384", 384, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA384.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SHA-384", String.valueOf(PREFIX) + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA384", "SHA-384");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha384, "SHA-384");
            provider.addAlgorithm("Mac.OLDHMACSHA384", String.valueOf(PREFIX) + "$OldSHA384");
            provider.addAlgorithm("Mac.PBEWITHHMACSHA384", String.valueOf(PREFIX) + "$HashMac");
            this.addHMACAlgorithm(provider, "SHA384", String.valueOf(PREFIX) + "$HashMac", String.valueOf(PREFIX) + "$KeyGenerator");
            this.addHMACAlias(provider, "SHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        }
    }

    public static class OldSHA384
    extends BaseMac {
        public OldSHA384() {
            super(new OldHMac(new SHA384Digest()));
        }
    }
}

