/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric;

import cn.win_trust_erpc.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.engines.BlowfishEngine;
import cn.win_trust_erpc.bouncycastle.crypto.macs.CMac;
import cn.win_trust_erpc.bouncycastle.crypto.modes.CBCBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Blowfish {
    private Blowfish() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Blowfish IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new BlowfishEngine()), 64);
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new BlowfishEngine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlowfishEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Blowfish", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Blowfish.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Mac.BLOWFISHCMAC", String.valueOf(PREFIX) + "$CMAC");
            provider.addAlgorithm("Cipher.BLOWFISH", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("KeyGenerator.BLOWFISH", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("Alg.Alias.KeyGenerator", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
            provider.addAlgorithm("AlgorithmParameters.BLOWFISH", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
        }
    }
}

