/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric;

import cn.win_trust_erpc.bouncycastle.crypto.BlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.CryptoServicesRegistrar;
import cn.win_trust_erpc.bouncycastle.crypto.engines.SM4Engine;
import cn.win_trust_erpc.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.macs.CMac;
import cn.win_trust_erpc.bouncycastle.crypto.macs.GMac;
import cn.win_trust_erpc.bouncycastle.crypto.modes.GCMBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class SM4 {
    private SM4() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SM4 parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance("SM4");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "SM4 IV";
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new SM4Engine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new SM4Engine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new SM4Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SM4", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = SM4.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.SM4", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.SM4", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("Cipher.SM4", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.SM4", String.valueOf(PREFIX) + "$KeyGen");
            this.addCMacAlgorithm(provider, "SM4", String.valueOf(PREFIX) + "$CMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addGMacAlgorithm(provider, "SM4", String.valueOf(PREFIX) + "$GMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addPoly1305Algorithm(provider, "SM4", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new cn.win_trust_erpc.bouncycastle.crypto.macs.Poly1305(new SM4Engine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-SM4", 256, new Poly1305KeyGenerator());
        }
    }
}

