/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric;

import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.engines.Zuc128Engine;
import cn.win_trust_erpc.bouncycastle.crypto.engines.Zuc256Engine;
import cn.win_trust_erpc.bouncycastle.crypto.macs.Zuc128Mac;
import cn.win_trust_erpc.bouncycastle.crypto.macs.Zuc256Mac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public class Zuc {
    private Zuc() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Zuc IV";
        }
    }

    public static class KeyGen128
    extends BaseKeyGenerator {
        public KeyGen128() {
            super("ZUC128", 128, new CipherKeyGenerator());
        }
    }

    public static class KeyGen256
    extends BaseKeyGenerator {
        public KeyGen256() {
            super("ZUC256", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Zuc.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.ZUC-128", String.valueOf(PREFIX) + "$Zuc128");
            provider.addAlgorithm("KeyGenerator.ZUC-128", String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("AlgorithmParameters.ZUC-128", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("Cipher.ZUC-256", String.valueOf(PREFIX) + "$Zuc256");
            provider.addAlgorithm("KeyGenerator.ZUC-256", String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("AlgorithmParameters.ZUC-256", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("Mac.ZUC-128", String.valueOf(PREFIX) + "$ZucMac128");
            provider.addAlgorithm("Mac.ZUC-256", String.valueOf(PREFIX) + "$ZucMac256");
            provider.addAlgorithm("Alg.Alias.Mac.ZUC-256-128", "ZUC-256");
            provider.addAlgorithm("Mac.ZUC-256-64", String.valueOf(PREFIX) + "$ZucMac256_64");
            provider.addAlgorithm("Mac.ZUC-256-32", String.valueOf(PREFIX) + "$ZucMac256_32");
        }
    }

    public static class Zuc128
    extends BaseStreamCipher {
        public Zuc128() {
            super(new Zuc128Engine(), 16, 128);
        }
    }

    public static class Zuc256
    extends BaseStreamCipher {
        public Zuc256() {
            super(new Zuc256Engine(), 25, 256);
        }
    }

    public static class ZucMac128
    extends BaseMac {
        public ZucMac128() {
            super(new Zuc128Mac());
        }
    }

    public static class ZucMac256
    extends BaseMac {
        public ZucMac256() {
            super(new Zuc256Mac(128));
        }
    }

    public static class ZucMac256_32
    extends BaseMac {
        public ZucMac256_32() {
            super(new Zuc256Mac(32));
        }
    }

    public static class ZucMac256_64
    extends BaseMac {
        public ZucMac256_64() {
            super(new Zuc256Mac(64));
        }
    }
}

