/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse;

import cn.win_trust_erpc.bouncycastle.jsse.BCSNIMatcher;
import cn.win_trust_erpc.bouncycastle.jsse.BCSNIServerName;
import cn.win_trust_erpc.bouncycastle.jsse.provider.IDNUtil;
import cn.win_trust_erpc.bouncycastle.tls.NameType;
import cn.win_trust_erpc.bouncycastle.util.Strings;
import java.util.Locale;
import java.util.regex.Pattern;

public final class BCSNIHostName
extends BCSNIServerName {
    private final String hostName;

    public static BCSNIMatcher createSNIMatcher(String regex) {
        if (regex == null) {
            throw new NullPointerException("'regex' cannot be null");
        }
        return new BCSNIHostNameMatcher(regex);
    }

    public BCSNIHostName(String hostName) {
        hostName = BCSNIHostName.normalizeHostName(hostName);
        super(0, Strings.toByteArray(hostName));
        this.hostName = hostName;
    }

    public BCSNIHostName(byte[] utf8Encoding) {
        super(0, utf8Encoding);
        this.hostName = BCSNIHostName.normalizeHostName(Strings.fromUTF8ByteArray(utf8Encoding));
    }

    public String getAsciiName() {
        return this.hostName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BCSNIHostName)) {
            return false;
        }
        BCSNIHostName other = (BCSNIHostName)obj;
        return this.hostName.equalsIgnoreCase(other.hostName);
    }

    @Override
    public int hashCode() {
        return this.hostName.toUpperCase(Locale.ENGLISH).hashCode();
    }

    @Override
    public String toString() {
        return "{type=" + NameType.getText((short)0) + ", value=" + this.hostName + "}";
    }

    private static String normalizeHostName(String hostName) {
        if (hostName == null) {
            throw new NullPointerException("'hostName' cannot be null");
        }
        if ((hostName = IDNUtil.toASCII(hostName, IDNUtil.USE_STD3_ASCII_RULES)).length() < 1) {
            throw new IllegalArgumentException("SNI host_name cannot be empty");
        }
        if (hostName.endsWith(".")) {
            throw new IllegalArgumentException("SNI host_name cannot end with a separator");
        }
        return hostName;
    }

    private static final class BCSNIHostNameMatcher
    extends BCSNIMatcher {
        private final Pattern pattern;

        BCSNIHostNameMatcher(String regex) {
            super(0);
            this.pattern = Pattern.compile(regex, 2);
        }

        @Override
        public boolean matches(BCSNIServerName serverName) {
            String asciiName;
            if (serverName == null) {
                throw new NullPointerException("'serverName' cannot be null");
            }
            if (serverName.getType() != 0) {
                return false;
            }
            try {
                asciiName = this.getAsciiHostName(serverName);
            }
            catch (RuntimeException e) {
                return false;
            }
            if (this.pattern.matcher(asciiName).matches()) {
                return true;
            }
            String unicodeName = IDNUtil.toUnicode(asciiName, 0);
            return !asciiName.equals(unicodeName) && this.pattern.matcher(unicodeName).matches();
        }

        private String getAsciiHostName(BCSNIServerName serverName) {
            if (serverName instanceof BCSNIHostName) {
                return ((BCSNIHostName)serverName).getAsciiName();
            }
            return BCSNIHostName.normalizeHostName(Strings.fromUTF8ByteArray(serverName.getEncoded()));
        }
    }
}

