/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import cn.win_trust_erpc.bouncycastle.jsse.provider.AlgorithmDecomposer;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class AbstractAlgorithmConstraints
implements BCAlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    AbstractAlgorithmConstraints(AlgorithmDecomposer decomposer) {
        this.decomposer = decomposer;
    }

    protected void checkAlgorithmName(String algorithm) {
        if (!JsseUtils.isNameSpecified(algorithm)) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
    }

    protected void checkKey(Key key) {
        if (key == null) {
            throw new NullPointerException("'key' cannot be null");
        }
    }

    protected void checkPrimitives(Set<BCCryptoPrimitive> primitives) {
        if (!this.isPrimitivesSpecified(primitives)) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
    }

    protected boolean containsAnyPartIgnoreCase(Set<String> elements, String algorithm) {
        if (elements.isEmpty()) {
            return false;
        }
        if (this.containsIgnoreCase(elements, algorithm)) {
            return true;
        }
        if (this.decomposer != null) {
            for (String part : this.decomposer.decompose(algorithm)) {
                if (!this.containsIgnoreCase(elements, part)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean containsIgnoreCase(Set<String> elements, String s) {
        for (String element : elements) {
            if (!element.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPrimitivesSpecified(Set<BCCryptoPrimitive> primitives) {
        return primitives != null && !primitives.isEmpty();
    }

    protected static Set<String> asUnmodifiableSet(String[] algorithms) {
        Set<String> result;
        if (algorithms != null && algorithms.length > 0 && !(result = AbstractAlgorithmConstraints.asSet(algorithms)).isEmpty()) {
            return Collections.unmodifiableSet(result);
        }
        return Collections.emptySet();
    }

    protected static Set<String> asSet(String[] algorithms) {
        HashSet<String> result = new HashSet<String>();
        if (algorithms != null) {
            String[] stringArray = algorithms;
            int n = algorithms.length;
            int n2 = 0;
            while (n2 < n) {
                String algorithm = stringArray[n2];
                if (algorithm != null) {
                    result.add(algorithm);
                }
                ++n2;
            }
        }
        return result;
    }
}

