/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import cn.win_trust_erpc.bouncycastle.jsse.provider.AbstractAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.provider.AlgorithmDecomposer;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.PropertyUtils;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.spec.DHParameterSpec;

class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Logger LOG = Logger.getLogger(DisabledAlgorithmConstraints.class.getName());
    private static final String INCLUDE_PREFIX = "include ";
    private static final String KEYWORD_KEYSIZE = "keySize";
    private final Set<String> disabledAlgorithms;
    private final Map<String, List<Constraint>> constraintsMap;

    static DisabledAlgorithmConstraints create(AlgorithmDecomposer decomposer, String propertyName, String defaultValue) {
        String[] entries = PropertyUtils.getStringArraySecurityProperty(propertyName, defaultValue);
        if (entries == null) {
            return null;
        }
        HashSet<String> disabledAlgorithms = new HashSet<String>();
        HashMap<String, List<Constraint>> constraintsMap = new HashMap<String, List<Constraint>>();
        int i = 0;
        while (i < entries.length) {
            if (!DisabledAlgorithmConstraints.addConstraint(disabledAlgorithms, constraintsMap, entries[i])) {
                LOG.warning("Ignoring unsupported entry in '" + propertyName + "': " + entries[i]);
            }
            ++i;
        }
        return new DisabledAlgorithmConstraints(decomposer, Collections.unmodifiableSet(disabledAlgorithms), Collections.unmodifiableMap(constraintsMap));
    }

    private static boolean addConstraint(Set<String> disabledAlgorithms, Map<String, List<Constraint>> constraintsMap, String entry) {
        if (entry.regionMatches(true, 0, INCLUDE_PREFIX, 0, INCLUDE_PREFIX.length())) {
            return false;
        }
        int spacePos = entry.indexOf(32);
        if (spacePos < 0) {
            String algorithm = DisabledAlgorithmConstraints.getCanonicalAlgorithm(entry);
            disabledAlgorithms.add(algorithm);
            DisabledAlgorithmConstraints.addConstraint(constraintsMap, algorithm, DisabledConstraint.INSTANCE);
            return true;
        }
        String algorithm = DisabledAlgorithmConstraints.getCanonicalAlgorithm(entry.substring(0, spacePos));
        String policy = entry.substring(spacePos + 1).trim();
        int ampPos = policy.indexOf(38);
        if (ampPos >= 0) {
            return false;
        }
        if (policy.startsWith(KEYWORD_KEYSIZE)) {
            StringTokenizer tokenizer = new StringTokenizer(policy);
            if (!KEYWORD_KEYSIZE.equals(tokenizer.nextToken())) {
                return false;
            }
            BinOp op = BinOp.parse(tokenizer.nextToken());
            int constraint = Integer.parseInt(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                return false;
            }
            DisabledAlgorithmConstraints.addConstraint(constraintsMap, algorithm, new KeySizeConstraint(op, constraint));
            return true;
        }
        return false;
    }

    private static void addConstraint(Map<String, List<Constraint>> constraintsMap, String algorithm, Constraint constraint) {
        List<Constraint> constraintList = constraintsMap.get(algorithm);
        if (constraintList == null) {
            constraintList = new ArrayList<Constraint>(1);
            constraintsMap.put(algorithm, constraintList);
        }
        constraintList.add(constraint);
    }

    private static String getCanonicalAlgorithm(String algorithm) {
        if ("DiffieHellman".equalsIgnoreCase(algorithm)) {
            return "DH";
        }
        return algorithm.toUpperCase(Locale.ENGLISH).replace("SHA-", "SHA");
    }

    private static String getConstraintsAlgorithm(String algorithm, AlgorithmParameters parameters) {
        String canonicalAlgorithm;
        String parametersAlgorithm;
        if (parameters != null && (parametersAlgorithm = parameters.getAlgorithm()) != null && (canonicalAlgorithm = DisabledAlgorithmConstraints.getCanonicalAlgorithm(algorithm)).equalsIgnoreCase(DisabledAlgorithmConstraints.getCanonicalAlgorithm(parametersAlgorithm))) {
            return canonicalAlgorithm;
        }
        return null;
    }

    private static String getConstraintsAlgorithm(Key key) {
        String keyAlgorithm;
        if (key != null && (keyAlgorithm = JsseUtils.getKeyAlgorithm(key)) != null) {
            return DisabledAlgorithmConstraints.getCanonicalAlgorithm(keyAlgorithm);
        }
        return null;
    }

    private DisabledAlgorithmConstraints(AlgorithmDecomposer decomposer, Set<String> disabledAlgorithms, Map<String, List<Constraint>> constraintsMap) {
        super(decomposer);
        this.disabledAlgorithms = disabledAlgorithms;
        this.constraintsMap = constraintsMap;
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        this.checkPrimitives(primitives);
        this.checkAlgorithmName(algorithm);
        if (this.containsAnyPartIgnoreCase(this.disabledAlgorithms, algorithm)) {
            return false;
        }
        for (Constraint constraint : this.getConstraints(DisabledAlgorithmConstraints.getConstraintsAlgorithm(algorithm, parameters))) {
            if (constraint.permits(parameters)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> primitives, Key key) {
        return this.checkConstraints(primitives, null, key, null);
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        this.checkAlgorithmName(algorithm);
        return this.checkConstraints(primitives, algorithm, key, parameters);
    }

    private boolean checkConstraints(Set<BCCryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        this.checkPrimitives(primitives);
        this.checkKey(key);
        if (JsseUtils.isNameSpecified(algorithm) && !this.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (!this.permits(primitives, JsseUtils.getKeyAlgorithm(key), null)) {
            return false;
        }
        for (Constraint constraint : this.getConstraints(DisabledAlgorithmConstraints.getConstraintsAlgorithm(key))) {
            if (constraint.permits(key)) continue;
            return false;
        }
        return true;
    }

    private List<Constraint> getConstraints(String algorithm) {
        List<Constraint> result;
        if (algorithm != null && (result = this.constraintsMap.get(algorithm)) != null) {
            return result;
        }
        return Collections.emptyList();
    }

    private static enum BinOp {
        EQ("=="),
        GE(">="),
        GT(">"),
        LE("<="),
        LT("<"),
        NE("!=");

        private final String s;

        static boolean eval(BinOp op, int lhs, int rhs) {
            switch (op) {
                case EQ: {
                    return lhs == rhs;
                }
                case GE: {
                    return lhs >= rhs;
                }
                case GT: {
                    return lhs > rhs;
                }
                case LE: {
                    return lhs <= rhs;
                }
                case LT: {
                    return lhs < rhs;
                }
                case NE: {
                    return lhs != rhs;
                }
            }
            return true;
        }

        static BinOp parse(String s) {
            BinOp[] binOpArray = BinOp.values();
            int n = binOpArray.length;
            int n2 = 0;
            while (n2 < n) {
                BinOp op = binOpArray[n2];
                if (op.s.equals(s)) {
                    return op;
                }
                ++n2;
            }
            throw new IllegalArgumentException("'s' is not a valid operator: " + s);
        }

        private BinOp(String s) {
            this.s = s;
        }
    }

    private static abstract class Constraint {
        private Constraint() {
        }

        boolean permits(AlgorithmParameters parameters) {
            return true;
        }

        boolean permits(Key key) {
            return true;
        }
    }

    private static class DisabledConstraint
    extends Constraint {
        static final DisabledConstraint INSTANCE = new DisabledConstraint();

        private DisabledConstraint() {
        }

        @Override
        public boolean permits(Key key) {
            return false;
        }
    }

    private static class KeySizeConstraint
    extends Constraint {
        private final BinOp op;
        private final int constraint;

        private static int getKeySize(AlgorithmParameters parameters) {
            String algorithm = parameters.getAlgorithm();
            if ("EC".equals(algorithm)) {
                try {
                    ECParameterSpec spec = parameters.getParameterSpec(ECParameterSpec.class);
                    if (spec != null) {
                        return spec.getOrder().bitLength();
                    }
                }
                catch (InvalidParameterSpecException spec) {}
            } else if ("DiffieHellman".equals(algorithm)) {
                try {
                    DHParameterSpec spec = parameters.getParameterSpec(DHParameterSpec.class);
                    if (spec != null) {
                        return spec.getP().bitLength();
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
            }
            return -1;
        }

        private static int getKeySize(Key key) {
            if (key instanceof RSAKey) {
                RSAKey rsaKey = (RSAKey)((Object)key);
                return rsaKey.getModulus().bitLength();
            }
            if (key instanceof ECKey) {
                ECKey ecKey = (ECKey)((Object)key);
                return ecKey.getParams().getOrder().bitLength();
            }
            if (key instanceof DSAKey) {
                DSAKey dsaKey = (DSAKey)((Object)key);
                DSAParams dsaParams = dsaKey.getParams();
                if (dsaParams != null) {
                    return dsaParams.getP().bitLength();
                }
            } else {
                byte[] raw;
                SecretKey secretKey;
                String format;
                if (key instanceof DHKey) {
                    DHKey dhKey = (DHKey)((Object)key);
                    return dhKey.getParams().getP().bitLength();
                }
                if (key instanceof SecretKey && "RAW".equals(format = (secretKey = (SecretKey)key).getFormat()) && (raw = secretKey.getEncoded()) != null) {
                    int byteLen = raw.length;
                    return byteLen > 0xFFFFFFF ? 0 : 8 * raw.length;
                }
            }
            return -1;
        }

        KeySizeConstraint(BinOp op, int constraint) {
            this.op = op;
            this.constraint = constraint;
        }

        @Override
        boolean permits(AlgorithmParameters parameters) {
            return this.checkKeySize(KeySizeConstraint.getKeySize(parameters));
        }

        @Override
        boolean permits(Key key) {
            return this.checkKeySize(KeySizeConstraint.getKeySize(key));
        }

        private boolean checkKeySize(int keySize) {
            if (keySize < 1) {
                return keySize < 0;
            }
            return !BinOp.eval(this.op, keySize, this.constraint);
        }
    }
}

