/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.OCSPResponse;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x500.X500Name;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.jsse.BCSNIHostName;
import cn.win_trust_erpc.bouncycastle.jsse.BCSNIMatcher;
import cn.win_trust_erpc.bouncycastle.jsse.BCSNIServerName;
import cn.win_trust_erpc.bouncycastle.jsse.BCX509ExtendedTrustManager;
import cn.win_trust_erpc.bouncycastle.jsse.BCX509Key;
import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import cn.win_trust_erpc.bouncycastle.jsse.provider.PropertyUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLContextSpi;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsManager;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SignatureSchemeInfo;
import cn.win_trust_erpc.bouncycastle.tls.AlertDescription;
import cn.win_trust_erpc.bouncycastle.tls.AlertLevel;
import cn.win_trust_erpc.bouncycastle.tls.CertificateEntry;
import cn.win_trust_erpc.bouncycastle.tls.CertificateStatus;
import cn.win_trust_erpc.bouncycastle.tls.NamedGroup;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolName;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.ServerName;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.TlsContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedDecryptor;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedSigner;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.TrustedAuthority;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

abstract class JsseUtils {
    private static final boolean provTlsAllowLegacyMasterSecret = PropertyUtils.getBooleanSystemProperty("jdk.tls.allowLegacyMasterSecret", true);
    private static final boolean provTlsAllowLegacyResumption = PropertyUtils.getBooleanSystemProperty("jdk.tls.allowLegacyResumption", false);
    private static final int provTlsMaxCertificateChainLength = PropertyUtils.getIntegerSystemProperty("jdk.tls.maxCertificateChainLength", 10, 1, Integer.MAX_VALUE);
    private static final int provTlsMaxHandshakeMessageSize = PropertyUtils.getIntegerSystemProperty("jdk.tls.maxHandshakeMessageSize", 32768, 1024, Integer.MAX_VALUE);
    private static final boolean provTlsRequireCloseNotify = PropertyUtils.getBooleanSystemProperty("com.sun.net.ssl.requireCloseNotify", true);
    private static final boolean provTlsUseExtendedMasterSecret = PropertyUtils.getBooleanSystemProperty("jdk.tls.useExtendedMasterSecret", true);
    static final Set<BCCryptoPrimitive> KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC = Collections.unmodifiableSet(EnumSet.of(BCCryptoPrimitive.KEY_AGREEMENT));
    static final Set<BCCryptoPrimitive> KEY_ENCAPSULATION_CRYPTO_PRIMITIVES_BC = Collections.unmodifiableSet(EnumSet.of(BCCryptoPrimitive.KEY_ENCAPSULATION));
    static final Set<BCCryptoPrimitive> SIGNATURE_CRYPTO_PRIMITIVES_BC = Collections.unmodifiableSet(EnumSet.of(BCCryptoPrimitive.SIGNATURE));
    static String EMPTY_STRING = "";
    static X509Certificate[] EMPTY_X509CERTIFICATES = new X509Certificate[0];

    JsseUtils() {
    }

    static boolean allowLegacyMasterSecret() {
        return provTlsAllowLegacyMasterSecret;
    }

    static boolean allowLegacyResumption() {
        return provTlsAllowLegacyResumption;
    }

    static String getSignatureAlgorithmsReport(String title, List<SignatureSchemeInfo> signatureSchemes) {
        String[] names = SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(signatureSchemes);
        StringBuilder sb = new StringBuilder(title);
        sb.append(':');
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            sb.append(' ');
            sb.append(name);
            ++n2;
        }
        return sb.toString();
    }

    static void checkSessionCreationEnabled(ProvTlsManager manager) {
        if (!manager.getEnableSessionCreation()) {
            throw new IllegalStateException("Cannot resume session and session creation is disabled");
        }
    }

    static <T> T[] clone(T[] ts) {
        return ts == null ? null : (Object[])ts.clone();
    }

    static boolean contains(String[] values, String value) {
        int i = 0;
        while (i < values.length) {
            if (value.equals(values[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static <T> boolean containsNull(T[] ts) {
        int i = 0;
        while (i < ts.length) {
            if (ts[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String[] copyOf(String[] data, int newLength) {
        String[] tmp = new String[newLength];
        System.arraycopy(data, 0, tmp, 0, Math.min(data.length, newLength));
        return tmp;
    }

    static TlsCredentialedDecryptor createCredentialedDecryptor(TlsCrypto tlsCrypto, BCX509Key x509Key) {
        PrivateKey privateKey = x509Key.getPrivateKey();
        cn.win_trust_erpc.bouncycastle.tls.Certificate certificate = JsseUtils.getCertificateMessage(tlsCrypto, x509Key.getCertificateChain());
        return new JceDefaultTlsCredentialedDecryptor(tlsCrypto, certificate, privateKey);
    }

    static TlsCredentialedSigner createCredentialedSigner(TlsContext context, TlsCrypto crypto, BCX509Key x509Key, SignatureAndHashAlgorithm sigAndHashAlg) {
        TlsCryptoParameters cryptoParams = new TlsCryptoParameters(context);
        PrivateKey privateKey = x509Key.getPrivateKey();
        cn.win_trust_erpc.bouncycastle.tls.Certificate certificate = JsseUtils.getCertificateMessage(crypto, x509Key.getCertificateChain());
        return new JcaDefaultTlsCredentialedSigner(cryptoParams, crypto, privateKey, certificate, sigAndHashAlg);
    }

    static TlsCredentialedSigner createCredentialedSigner13(TlsContext context, TlsCrypto crypto, BCX509Key x509Key, SignatureAndHashAlgorithm sigAndHashAlg, byte[] certificateRequestContext) {
        TlsCryptoParameters cryptoParams = new TlsCryptoParameters(context);
        PrivateKey privateKey = x509Key.getPrivateKey();
        cn.win_trust_erpc.bouncycastle.tls.Certificate certificate = JsseUtils.getCertificateMessage13(crypto, x509Key.getCertificateChain(), certificateRequestContext);
        return new JcaDefaultTlsCredentialedSigner(cryptoParams, crypto, privateKey, certificate, sigAndHashAlg);
    }

    static boolean equals(Object a, Object b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    static int getMaxCertificateChainLength() {
        return provTlsMaxCertificateChainLength;
    }

    static int getMaxHandshakeMessageSize() {
        return provTlsMaxHandshakeMessageSize;
    }

    static ASN1ObjectIdentifier getNamedCurveOID(PublicKey publicKey) {
        try {
            ASN1Primitive primitive;
            ASN1Encodable parameters;
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            AlgorithmIdentifier algID = spki.getAlgorithm();
            if (X9ObjectIdentifiers.id_ecPublicKey.equals(algID.getAlgorithm()) && (parameters = algID.getParameters()) != null && (primitive = parameters.toASN1Primitive()) instanceof ASN1ObjectIdentifier) {
                return (ASN1ObjectIdentifier)primitive;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static String[] resize(String[] data, int count) {
        if (count < data.length) {
            data = JsseUtils.copyOf(data, count);
        }
        return data;
    }

    static String getApplicationProtocol(SecurityParameters securityParameters) {
        if (securityParameters == null || !securityParameters.isApplicationProtocolSet()) {
            return null;
        }
        ProtocolName applicationProtocol = securityParameters.getApplicationProtocol();
        if (applicationProtocol == null) {
            return "";
        }
        return applicationProtocol.getUtf8Decoding();
    }

    static String getAuthTypeClient(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "DSA";
            }
            case 3: 
            case 26: 
            case 27: 
            case 28: {
                return "EC";
            }
            case 7: {
                return "Ed25519";
            }
            case 8: {
                return "Ed448";
            }
            case 4: 
            case 5: 
            case 6: {
                return "RSA";
            }
            case 9: 
            case 10: 
            case 11: {
                return "RSASSA-PSS";
            }
        }
        throw new IllegalArgumentException();
    }

    static String getAuthTypeServer(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 7: {
                return "DH_DSS";
            }
            case 9: {
                return "DH_RSA";
            }
            case 3: {
                return "DHE_DSS";
            }
            case 5: {
                return "DHE_RSA";
            }
            case 16: {
                return "ECDH_ECDSA";
            }
            case 18: {
                return "ECDH_RSA";
            }
            case 17: {
                return "ECDHE_ECDSA";
            }
            case 19: {
                return "ECDHE_RSA";
            }
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "KE:RSA";
            }
            case 22: {
                return "SRP_DSS";
            }
            case 23: {
                return "SRP_RSA";
            }
            case 25: {
                return "SM2";
            }
        }
        throw new IllegalArgumentException();
    }

    static Vector<X500Name> getCertificateAuthorities(BCX509ExtendedTrustManager x509TrustManager) {
        HashSet<X500Principal> caSubjects = new HashSet<X500Principal>();
        X509Certificate[] x509CertificateArray = x509TrustManager.getAcceptedIssuers();
        int n = x509CertificateArray.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate acceptedIssuer = x509CertificateArray[n2];
            if (acceptedIssuer.getBasicConstraints() >= 0) {
                caSubjects.add(acceptedIssuer.getSubjectX500Principal());
            } else {
                caSubjects.add(acceptedIssuer.getIssuerX500Principal());
            }
            ++n2;
        }
        if (caSubjects.isEmpty()) {
            return null;
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>(caSubjects.size());
        for (X500Principal caSubject : caSubjects) {
            certificateAuthorities.add(X500Name.getInstance(caSubject.getEncoded()));
        }
        return certificateAuthorities;
    }

    static cn.win_trust_erpc.bouncycastle.tls.Certificate getCertificateMessage(TlsCrypto crypto, X509Certificate[] chain) {
        if (TlsUtils.isNullOrEmpty(chain)) {
            throw new IllegalArgumentException();
        }
        TlsCertificate[] certificateList = new TlsCertificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            certificateList[i] = new JcaTlsCertificate(crypto, chain[i]);
            ++i;
        }
        return new cn.win_trust_erpc.bouncycastle.tls.Certificate(certificateList);
    }

    static cn.win_trust_erpc.bouncycastle.tls.Certificate getCertificateMessage13(TlsCrypto crypto, X509Certificate[] chain, byte[] certificateRequestContext) {
        if (TlsUtils.isNullOrEmpty(chain)) {
            throw new IllegalArgumentException();
        }
        CertificateEntry[] certificateEntryList = new CertificateEntry[chain.length];
        int i = 0;
        while (i < chain.length) {
            JcaTlsCertificate certificate = new JcaTlsCertificate(crypto, chain[i]);
            Hashtable extensions = null;
            certificateEntryList[i] = new CertificateEntry(certificate, extensions);
            ++i;
        }
        return new cn.win_trust_erpc.bouncycastle.tls.Certificate(certificateRequestContext, certificateEntryList);
    }

    static X509Certificate getEndEntity(JcaTlsCrypto crypto, cn.win_trust_erpc.bouncycastle.tls.Certificate certificateMessage) throws IOException {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return null;
        }
        return JsseUtils.getX509Certificate(crypto, certificateMessage.getCertificateAt(0));
    }

    static String getJcaSignatureAlgorithmBC(String jcaSignatureAlgorithm, String keyAlgorithm) {
        if (!jcaSignatureAlgorithm.endsWith("withRSAandMGF1")) {
            return jcaSignatureAlgorithm;
        }
        return String.valueOf(jcaSignatureAlgorithm) + ":" + keyAlgorithm;
    }

    static String getKeyType13(String keyAlgorithm, int namedGroup13) {
        if (namedGroup13 < 0) {
            return keyAlgorithm;
        }
        return String.valueOf(keyAlgorithm) + "/" + NamedGroup.getStandardName(namedGroup13);
    }

    static String getKeyTypeLegacyClient(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return "DSA";
            }
            case 64: {
                return "EC";
            }
            case 1: {
                return "RSA";
            }
        }
        throw new IllegalArgumentException();
    }

    static String getKeyTypeLegacyServer(int keyExchangeAlgorithm) {
        return JsseUtils.getAuthTypeServer(keyExchangeAlgorithm);
    }

    static Vector<ProtocolName> getProtocolNames(String[] applicationProtocols) {
        if (TlsUtils.isNullOrEmpty(applicationProtocols)) {
            return null;
        }
        Vector<ProtocolName> result = new Vector<ProtocolName>(applicationProtocols.length);
        String[] stringArray = applicationProtocols;
        int n = applicationProtocols.length;
        int n2 = 0;
        while (n2 < n) {
            String applicationProtocol = stringArray[n2];
            result.add(ProtocolName.asUtf8Encoding(applicationProtocol));
            ++n2;
        }
        return result;
    }

    static List<String> getProtocolNames(Vector<ProtocolName> applicationProtocols) {
        if (applicationProtocols == null || applicationProtocols.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(applicationProtocols.size());
        for (ProtocolName applicationProtocol : applicationProtocols) {
            result.add(applicationProtocol.getUtf8Decoding());
        }
        return result;
    }

    static byte[] getStatusResponse(OCSPResponse ocspResponse) throws IOException {
        return ocspResponse == null ? TlsUtils.EMPTY_BYTES : ocspResponse.getEncoded("DER");
    }

    static List<byte[]> getStatusResponses(CertificateStatus certificateStatus) throws IOException {
        if (certificateStatus != null) {
            switch (certificateStatus.getStatusType()) {
                case 1: {
                    OCSPResponse ocspResponse = certificateStatus.getOCSPResponse();
                    return Collections.singletonList(JsseUtils.getStatusResponse(ocspResponse));
                }
                case 2: {
                    Vector ocspResponseList = certificateStatus.getOCSPResponseList();
                    int count = ocspResponseList.size();
                    ArrayList<byte[]> statusResponses = new ArrayList<byte[]>(count);
                    int i = 0;
                    while (i < count) {
                        OCSPResponse ocspResponse = (OCSPResponse)ocspResponseList.elementAt(i);
                        statusResponses.add(JsseUtils.getStatusResponse(ocspResponse));
                        ++i;
                    }
                    return Collections.unmodifiableList(statusResponses);
                }
            }
        }
        return null;
    }

    static X500Principal[] getTrustedIssuers(Vector<TrustedAuthority> trustedCAKeys) throws IOException {
        if (trustedCAKeys == null || trustedCAKeys.isEmpty()) {
            return null;
        }
        int count = trustedCAKeys.size();
        X500Principal[] principals = new X500Principal[count];
        int i = 0;
        while (i < count) {
            TrustedAuthority trustedAuthority = trustedCAKeys.get(i);
            if (2 != trustedAuthority.getIdentifierType()) {
                return null;
            }
            principals[i] = JsseUtils.toX500Principal(trustedAuthority.getX509Name());
            ++i;
        }
        return principals;
    }

    static X509Certificate getX509Certificate(TlsCrypto crypto, TlsCertificate tlsCertificate) throws IOException {
        return JcaTlsCertificate.convert(crypto, tlsCertificate).getX509Certificate();
    }

    static X509Certificate[] getX509CertificateChain(TlsCrypto crypto, cn.win_trust_erpc.bouncycastle.tls.Certificate certificateMessage) {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return EMPTY_X509CERTIFICATES;
        }
        try {
            X509Certificate[] chain = new X509Certificate[certificateMessage.getLength()];
            int i = 0;
            while (i < chain.length) {
                chain[i] = JcaTlsCertificate.convert(crypto, certificateMessage.getCertificateAt(i)).getX509Certificate();
                ++i;
            }
            return chain;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static X509Certificate[] getX509CertificateChain(Certificate[] chain) {
        if (chain == null) {
            return null;
        }
        if (chain instanceof X509Certificate[]) {
            return JsseUtils.containsNull(chain) ? null : (X509Certificate[])chain;
        }
        X509Certificate[] x509Chain = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            Certificate c = chain[i];
            if (!(c instanceof X509Certificate)) {
                return null;
            }
            x509Chain[i] = (X509Certificate)c;
            ++i;
        }
        return x509Chain;
    }

    static X500Principal getSubject(TlsCrypto crypto, cn.win_trust_erpc.bouncycastle.tls.Certificate certificateMessage) {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return null;
        }
        try {
            return JsseUtils.getX509Certificate(crypto, certificateMessage.getCertificateAt(0)).getSubjectX500Principal();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String getAlertLogMessage(String root, short alertLevel, short alertDescription) {
        return String.valueOf(root) + " " + AlertLevel.getText(alertLevel) + " " + AlertDescription.getText(alertDescription) + " alert";
    }

    static String getKeyAlgorithm(Key key) {
        if (key instanceof PrivateKey) {
            return JsseUtils.getPrivateKeyAlgorithm((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return JsseUtils.getPublicKeyAlgorithm((PublicKey)key);
        }
        return key.getAlgorithm();
    }

    static String getPrivateKeyAlgorithm(PrivateKey privateKey) {
        PrivateKeyInfo pki;
        String algorithm = privateKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(algorithm) && PKCSObjectIdentifiers.id_RSASSA_PSS.equals((pki = PrivateKeyInfo.getInstance(privateKey.getEncoded())).getPrivateKeyAlgorithm().getAlgorithm())) {
            return "RSASSA-PSS";
        }
        return algorithm;
    }

    static String getPublicKeyAlgorithm(PublicKey publicKey) {
        SubjectPublicKeyInfo spki;
        String algorithm = publicKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(algorithm) && PKCSObjectIdentifiers.id_RSASSA_PSS.equals((spki = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded())).getAlgorithm().getAlgorithm())) {
            return "RSASSA-PSS";
        }
        return algorithm;
    }

    static boolean isNameSpecified(String name) {
        return !JsseUtils.isNullOrEmpty(name);
    }

    static boolean isNullOrEmpty(String s) {
        return s == null || s.length() < 1;
    }

    static boolean isTLSv12(String protocol) {
        ProtocolVersion protocolVersion = ProvSSLContextSpi.getProtocolVersion(protocol);
        return protocolVersion != null && TlsUtils.isTLSv12(protocolVersion);
    }

    static boolean isTLSv13(String protocol) {
        ProtocolVersion protocolVersion = ProvSSLContextSpi.getProtocolVersion(protocol);
        return protocolVersion != null && TlsUtils.isTLSv13(protocolVersion);
    }

    static X500Principal toX500Principal(X500Name name) throws IOException {
        return name == null ? null : new X500Principal(name.getEncoded("DER"));
    }

    static X500Principal[] toX500Principals(Vector<X500Name> names) throws IOException {
        if (names == null) {
            return null;
        }
        LinkedHashSet<X500Principal> principals = new LinkedHashSet<X500Principal>();
        int count = names.size();
        int i = 0;
        while (i < count) {
            X500Principal principal = JsseUtils.toX500Principal(names.get(i));
            if (principal != null) {
                principals.add(principal);
            }
            ++i;
        }
        return principals.toArray(new X500Principal[0]);
    }

    static BCSNIServerName convertSNIServerName(ServerName serverName) {
        short nameType = serverName.getNameType();
        byte[] nameData = serverName.getNameData();
        switch (nameType) {
            case 0: {
                return new BCSNIHostName(nameData);
            }
        }
        return new BCUnknownServerName(nameType, nameData);
    }

    static List<BCSNIServerName> convertSNIServerNames(Vector<ServerName> serverNameList) {
        if (serverNameList == null || serverNameList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIServerName> result = new ArrayList<BCSNIServerName>(serverNameList.size());
        Enumeration<ServerName> serverNames = serverNameList.elements();
        while (serverNames.hasMoreElements()) {
            result.add(JsseUtils.convertSNIServerName(serverNames.nextElement()));
        }
        return Collections.unmodifiableList(result);
    }

    static BCSNIServerName findMatchingSNIServerName(Vector<ServerName> serverNameList, Collection<BCSNIMatcher> sniMatchers) {
        if (!serverNameList.isEmpty()) {
            List<BCSNIServerName> sniServerNames = JsseUtils.convertSNIServerNames(serverNameList);
            block0: for (BCSNIMatcher sniMatcher : sniMatchers) {
                if (sniMatcher == null) continue;
                int nameType = sniMatcher.getType();
                for (BCSNIServerName sniServerName : sniServerNames) {
                    if (sniServerName == null || sniServerName.getType() != nameType) continue;
                    if (!sniMatcher.matches(sniServerName)) continue block0;
                    return sniServerName;
                }
            }
        }
        return null;
    }

    static BCSNIHostName getSNIHostName(List<BCSNIServerName> serverNames) {
        if (serverNames != null) {
            for (BCSNIServerName serverName : serverNames) {
                if (serverName == null || serverName.getType() != 0) continue;
                if (serverName instanceof BCSNIHostName) {
                    return (BCSNIHostName)serverName;
                }
                try {
                    return new BCSNIHostName(serverName.getEncoded());
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
        }
        return null;
    }

    static String removeAllWhitespace(String s) {
        if (JsseUtils.isNullOrEmpty(s)) {
            return s;
        }
        int originalLength = s.length();
        char[] buf = new char[originalLength];
        int bufPos = 0;
        int i = 0;
        while (i < originalLength) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                buf[bufPos++] = c;
            }
            ++i;
        }
        if (bufPos == 0) {
            return EMPTY_STRING;
        }
        if (bufPos == originalLength) {
            return s;
        }
        return new String(buf, 0, bufPos);
    }

    static boolean requireCloseNotify() {
        return provTlsRequireCloseNotify;
    }

    static String stripDoubleQuotes(String s) {
        return JsseUtils.stripOuterChars(s, '\"', '\"');
    }

    static String stripSquareBrackets(String s) {
        return JsseUtils.stripOuterChars(s, '[', ']');
    }

    private static String stripOuterChars(String s, char openChar, char closeChar) {
        int sLast;
        if (s != null && (sLast = s.length() - 1) > 0 && s.charAt(0) == openChar && s.charAt(sLast) == closeChar) {
            return s.substring(1, sLast);
        }
        return s;
    }

    static boolean useExtendedMasterSecret() {
        return provTlsUseExtendedMasterSecret;
    }

    static class BCUnknownServerName
    extends BCSNIServerName {
        BCUnknownServerName(int nameType, byte[] encoded) {
            super(nameType, encoded);
        }
    }
}

