/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import cn.win_trust_erpc.bouncycastle.jsse.provider.AbstractAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.provider.DisabledAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvAlgorithmDecomposer;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ProvAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Logger LOG = Logger.getLogger(ProvAlgorithmConstraints.class.getName());
    private static final String PROPERTY_CERTPATH_DISABLED_ALGORITHMS = "jdk.certpath.disabledAlgorithms";
    private static final String PROPERTY_TLS_DISABLED_ALGORITHMS = "jdk.tls.disabledAlgorithms";
    private static final String DEFAULT_CERTPATH_DISABLED_ALGORITHMS = "MD2, MD5, SHA1 jdkCA & usage TLSServer, RSA keySize < 1024, DSA keySize < 1024, EC keySize < 224, include jdk.disabled.namedCurves";
    private static final String DEFAULT_TLS_DISABLED_ALGORITHMS = "SSLv3, TLSv1, TLSv1.1, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL, include jdk.disabled.namedCurves";
    private static final DisabledAlgorithmConstraints provTlsDisabledAlgorithms = DisabledAlgorithmConstraints.create(ProvAlgorithmDecomposer.INSTANCE_TLS, "jdk.tls.disabledAlgorithms", "SSLv3, TLSv1, TLSv1.1, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL, include jdk.disabled.namedCurves");
    private static final DisabledAlgorithmConstraints provX509DisabledAlgorithms = DisabledAlgorithmConstraints.create(ProvAlgorithmDecomposer.INSTANCE_X509, "jdk.certpath.disabledAlgorithms", "MD2, MD5, SHA1 jdkCA & usage TLSServer, RSA keySize < 1024, DSA keySize < 1024, EC keySize < 224, include jdk.disabled.namedCurves");
    static final ProvAlgorithmConstraints DEFAULT = new ProvAlgorithmConstraints(null, true);
    static final ProvAlgorithmConstraints DEFAULT_TLS_ONLY = new ProvAlgorithmConstraints(null, false);
    private final BCAlgorithmConstraints configAlgorithmConstraints;
    private final Set<String> supportedSignatureAlgorithms;
    private final boolean enableX509Constraints;

    ProvAlgorithmConstraints(BCAlgorithmConstraints configAlgorithmConstraints, boolean enableX509Constraints) {
        super(null);
        this.configAlgorithmConstraints = configAlgorithmConstraints;
        this.supportedSignatureAlgorithms = null;
        this.enableX509Constraints = enableX509Constraints;
    }

    ProvAlgorithmConstraints(BCAlgorithmConstraints configAlgorithmConstraints, String[] supportedSignatureAlgorithms, boolean enableX509Constraints) {
        super(null);
        this.configAlgorithmConstraints = configAlgorithmConstraints;
        this.supportedSignatureAlgorithms = ProvAlgorithmConstraints.asUnmodifiableSet(supportedSignatureAlgorithms);
        this.enableX509Constraints = enableX509Constraints;
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        this.checkPrimitives(primitives);
        this.checkAlgorithmName(algorithm);
        if (this.supportedSignatureAlgorithms != null) {
            String algorithmBC = algorithm;
            algorithm = this.getAlgorithm(algorithmBC);
            if (!this.isSupportedSignatureAlgorithm(algorithmBC)) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Signature algorithm '" + algorithmBC + "' not in supported signature algorithms");
                }
                return false;
            }
        }
        if (this.configAlgorithmConstraints != null && !this.configAlgorithmConstraints.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (provTlsDisabledAlgorithms != null && !provTlsDisabledAlgorithms.permits(primitives, algorithm, parameters)) {
            return false;
        }
        return !this.enableX509Constraints || provX509DisabledAlgorithms == null || provX509DisabledAlgorithms.permits(primitives, algorithm, parameters);
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> primitives, Key key) {
        this.checkPrimitives(primitives);
        this.checkKey(key);
        if (this.configAlgorithmConstraints != null && !this.configAlgorithmConstraints.permits(primitives, key)) {
            return false;
        }
        if (provTlsDisabledAlgorithms != null && !provTlsDisabledAlgorithms.permits(primitives, key)) {
            return false;
        }
        return !this.enableX509Constraints || provX509DisabledAlgorithms == null || provX509DisabledAlgorithms.permits(primitives, key);
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        this.checkPrimitives(primitives);
        this.checkAlgorithmName(algorithm);
        this.checkKey(key);
        if (this.supportedSignatureAlgorithms != null) {
            String algorithmBC = algorithm;
            algorithm = this.getAlgorithm(algorithmBC);
            if (!this.isSupportedSignatureAlgorithm(algorithmBC)) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Signature algorithm '" + algorithmBC + "' not in supported signature algorithms");
                }
                return false;
            }
        }
        if (this.configAlgorithmConstraints != null && !this.configAlgorithmConstraints.permits(primitives, algorithm, key, parameters)) {
            return false;
        }
        if (provTlsDisabledAlgorithms != null && !provTlsDisabledAlgorithms.permits(primitives, algorithm, key, parameters)) {
            return false;
        }
        return !this.enableX509Constraints || provX509DisabledAlgorithms == null || provX509DisabledAlgorithms.permits(primitives, algorithm, key, parameters);
    }

    private String getAlgorithm(String algorithmBC) {
        int colonPos = algorithmBC.indexOf(58);
        return colonPos < 0 ? algorithmBC : algorithmBC.substring(0, colonPos);
    }

    private boolean isSupportedSignatureAlgorithm(String algorithmBC) {
        return this.containsIgnoreCase(this.supportedSignatureAlgorithms, algorithmBC);
    }
}

