/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.provider.CipherSuiteInfo;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JcaAlgorithmDecomposer;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLContextSpi;
import cn.win_trust_erpc.bouncycastle.tls.CipherSuite;
import java.util.Set;

class ProvAlgorithmDecomposer
extends JcaAlgorithmDecomposer {
    static final ProvAlgorithmDecomposer INSTANCE_TLS = new ProvAlgorithmDecomposer(true);
    static final ProvAlgorithmDecomposer INSTANCE_X509 = new ProvAlgorithmDecomposer(false);
    private final boolean enableTLSAlgorithms;

    private ProvAlgorithmDecomposer(boolean enableTLSAlgorithms) {
        this.enableTLSAlgorithms = enableTLSAlgorithms;
    }

    @Override
    public Set<String> decompose(String algorithm) {
        CipherSuiteInfo cipherSuiteInfo;
        if (algorithm.startsWith("TLS_") && (cipherSuiteInfo = ProvSSLContextSpi.getCipherSuiteInfo(algorithm)) != null && !CipherSuite.isSCSV(cipherSuiteInfo.getCipherSuite())) {
            return this.enableTLSAlgorithms ? cipherSuiteInfo.getDecompositionTLS() : cipherSuiteInfo.getDecompositionX509();
        }
        return super.decompose(algorithm);
    }
}

