/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCExtendedSSLSession;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseSecurityParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseSessionParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLContextSpi;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionContext;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SSLSessionUtil;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;

abstract class ProvSSLSessionBase
extends BCExtendedSSLSession {
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final AtomicReference<ProvSSLSessionContext> sslSessionContext;
    protected final boolean isFips;
    protected final TlsCrypto crypto;
    protected final String peerHost;
    protected final int peerPort;
    protected final long creationTime;
    protected final SSLSession exportSSLSession;
    protected final AtomicLong lastAccessedTime;

    ProvSSLSessionBase(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort) {
        this.sslSessionContext = new AtomicReference<ProvSSLSessionContext>(sslSessionContext);
        this.isFips = sslSessionContext == null ? false : sslSessionContext.getSSLContext().isFips();
        this.crypto = sslSessionContext == null ? null : sslSessionContext.getCrypto();
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.creationTime = System.currentTimeMillis();
        this.exportSSLSession = SSLSessionUtil.exportSSLSession(this);
        this.lastAccessedTime = new AtomicLong(this.creationTime);
    }

    protected abstract int getCipherSuiteTLS();

    protected abstract byte[] getIDArray();

    protected abstract JsseSecurityParameters getJsseSecurityParameters();

    protected abstract JsseSessionParameters getJsseSessionParameters();

    protected abstract cn.win_trust_erpc.bouncycastle.tls.Certificate getLocalCertificateTLS();

    protected abstract cn.win_trust_erpc.bouncycastle.tls.Certificate getPeerCertificateTLS();

    protected abstract ProtocolVersion getProtocolTLS();

    protected abstract void invalidateTLS();

    SSLSession getExportSSLSession() {
        return this.exportSSLSession;
    }

    void accessedAt(long accessTime) {
        long current = this.lastAccessedTime.get();
        if (accessTime > current) {
            this.lastAccessedTime.compareAndSet(current, accessTime);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProvSSLSessionBase)) {
            return false;
        }
        ProvSSLSessionBase other = (ProvSSLSessionBase)obj;
        return Arrays.areEqual(this.getIDArray(), other.getIDArray());
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    @Override
    public String getCipherSuite() {
        return ProvSSLContextSpi.getCipherSuiteName(this.getCipherSuiteTLS());
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public byte[] getId() {
        byte[] id = this.getIDArray();
        return TlsUtils.isNullOrEmpty(id) ? TlsUtils.EMPTY_BYTES : (byte[])id.clone();
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime.get();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        Certificate[] chain;
        if (this.crypto != null && (chain = JsseUtils.getX509CertificateChain(this.crypto, this.getLocalCertificateTLS())) != null && chain.length > 0) {
            return chain;
        }
        return null;
    }

    @Override
    public Principal getLocalPrincipal() {
        if (this.crypto != null) {
            return JsseUtils.getSubject(this.crypto, this.getLocalCertificateTLS());
        }
        return null;
    }

    @Override
    public int getPacketBufferSize() {
        ProtocolVersion protocolVersion = this.getProtocolTLS();
        if (protocolVersion == null || !TlsUtils.isTLSv12(protocolVersion)) {
            return 18443;
        }
        if (TlsUtils.isTLSv13(protocolVersion)) {
            return 16911;
        }
        return 17413;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        java.security.cert.X509Certificate[] peerCertificates = (java.security.cert.X509Certificate[])this.getPeerCertificates();
        X509Certificate[] chain = new X509Certificate[peerCertificates.length];
        try {
            int i = 0;
            while (i < peerCertificates.length) {
                chain[i] = this.isFips ? new X509CertificateWrapper(peerCertificates[i]) : X509Certificate.getInstance(peerCertificates[i].getEncoded());
                ++i;
            }
        }
        catch (Exception e) {
            throw new SSLPeerUnverifiedException(e.getMessage());
        }
        return chain;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        Certificate[] chain;
        if (this.crypto != null && (chain = JsseUtils.getX509CertificateChain(this.crypto, this.getPeerCertificateTLS())) != null && chain.length > 0) {
            return chain;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal principal;
        if (this.crypto != null && (principal = JsseUtils.getSubject(this.crypto, this.getPeerCertificateTLS())) != null) {
            return principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public String getProtocol() {
        return ProvSSLContextSpi.getProtocolVersionName(this.getProtocolTLS());
    }

    @Override
    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.sslSessionContext.get();
    }

    @Override
    public Object getValue(String name) {
        return this.valueMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.getIDArray());
    }

    @Override
    public final void invalidate() {
        this.implInvalidate(true);
    }

    final void invalidatedBySessionContext() {
        this.implInvalidate(false);
    }

    @Override
    public boolean isValid() {
        if (this.sslSessionContext.get() == null) {
            return false;
        }
        return !TlsUtils.isNullOrEmpty(this.getIDArray());
    }

    @Override
    public void putValue(String name, Object value) {
        this.notifyUnbound(name, this.valueMap.put(name, value));
        this.notifyBound(name, value);
    }

    @Override
    public void removeValue(String name) {
        this.notifyUnbound(name, this.valueMap.remove(name));
    }

    public String toString() {
        return "Session(" + this.getCreationTime() + "|" + this.getCipherSuite() + ")";
    }

    protected void notifyBound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    protected void notifyUnbound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    private void implInvalidate(boolean removeFromSessionContext) {
        if (removeFromSessionContext) {
            ProvSSLSessionContext context = this.sslSessionContext.getAndSet(null);
            if (context != null) {
                context.removeSession(this.getIDArray());
            }
        } else {
            this.sslSessionContext.set(null);
        }
        this.invalidateTLS();
    }

    private static class X509CertificateWrapper
    extends X509Certificate {
        private final java.security.cert.X509Certificate c;

        private X509CertificateWrapper(java.security.cert.X509Certificate c) {
            this.c = c;
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            try {
                this.c.checkValidity();
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            try {
                this.c.checkValidity(date);
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
        }

        @Override
        public int getVersion() {
            return this.c.getVersion() - 1;
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.c.getSerialNumber();
        }

        @Override
        public Principal getIssuerDN() {
            return this.c.getIssuerX500Principal();
        }

        @Override
        public Principal getSubjectDN() {
            return this.c.getSubjectX500Principal();
        }

        @Override
        public Date getNotBefore() {
            return this.c.getNotBefore();
        }

        @Override
        public Date getNotAfter() {
            return this.c.getNotAfter();
        }

        @Override
        public String getSigAlgName() {
            return this.c.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return this.c.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return this.c.getSigAlgParams();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            try {
                return this.c.getEncoded();
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            try {
                this.c.verify(key);
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
            catch (CertificateParsingException e) {
                throw new javax.security.cert.CertificateParsingException(e.getMessage());
            }
            catch (java.security.cert.CertificateException e) {
                throw new CertificateException(e.getMessage());
            }
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            try {
                this.c.verify(key, sigProvider);
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
            catch (CertificateParsingException e) {
                throw new javax.security.cert.CertificateParsingException(e.getMessage());
            }
            catch (java.security.cert.CertificateException e) {
                throw new CertificateException(e.getMessage());
            }
        }

        @Override
        public String toString() {
            return this.c.toString();
        }

        @Override
        public PublicKey getPublicKey() {
            return this.c.getPublicKey();
        }
    }
}

