/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCSNIServerName;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseSecurityParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseSessionParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionBase;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionContext;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SignatureSchemeInfo;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

class ProvSSLSessionHandshake
extends ProvSSLSessionBase {
    protected final SecurityParameters securityParameters;
    protected final JsseSecurityParameters jsseSecurityParameters;

    ProvSSLSessionHandshake(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters) {
        super(sslSessionContext, peerHost, peerPort);
        this.securityParameters = securityParameters;
        this.jsseSecurityParameters = jsseSecurityParameters;
    }

    String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.securityParameters);
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.securityParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.securityParameters.getSessionID();
    }

    @Override
    protected JsseSecurityParameters getJsseSecurityParameters() {
        return this.jsseSecurityParameters;
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return null;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.securityParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.jsseSecurityParameters.localSigSchemesCert);
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithmsBC() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(this.jsseSecurityParameters.localSigSchemesCert);
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.securityParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.jsseSecurityParameters.peerSigSchemesCert);
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithmsBC() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(this.jsseSecurityParameters.peerSigSchemesCert);
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.securityParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        Vector clientServerNames = this.securityParameters.getClientServerNames();
        return JsseUtils.convertSNIServerNames(clientServerNames);
    }

    @Override
    public List<byte[]> getStatusResponses() {
        List<byte[]> statusResponses = this.jsseSecurityParameters.statusResponses;
        if (statusResponses == null || statusResponses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(statusResponses.size());
        for (byte[] statusResponse : statusResponses) {
            result.add((byte[])statusResponse.clone());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    protected void invalidateTLS() {
    }
}

