/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCApplicationProtocolSelector;
import cn.win_trust_erpc.bouncycastle.jsse.BCExtendedSSLSession;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLConnection;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.BCX509Key;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ContextData;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseSecurityParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLConnection;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSession;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionContext;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSocketBase;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsClient;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsClientProtocol;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsManager;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsPeer;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsServer;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsServerProtocol;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SSLParametersUtil;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

class ProvSSLSocketWrap
extends ProvSSLSocketBase
implements ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLSocketWrap.class.getName());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ContextData contextData;
    protected final Socket wrapSocket;
    protected final InputStream consumed;
    protected final boolean autoClose;
    protected final ProvSSLParameters sslParameters;
    protected String peerHost = null;
    protected String peerHostSNI = null;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;

    private static Socket checkSocket(Socket s) throws SocketException {
        if (s == null) {
            throw new NullPointerException("'s' cannot be null");
        }
        if (!s.isConnected()) {
            throw new SocketException("'s' is not a connected socket");
        }
        return s;
    }

    protected ProvSSLSocketWrap(ContextData contextData, Socket s, InputStream consumed, boolean autoClose) throws IOException {
        this.contextData = contextData;
        this.wrapSocket = ProvSSLSocketWrap.checkSocket(s);
        this.consumed = consumed;
        this.autoClose = autoClose;
        this.useClientMode = false;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
        this.notifyConnected();
    }

    protected ProvSSLSocketWrap(ContextData contextData, Socket s, String host, int port, boolean autoClose) throws IOException {
        this.contextData = contextData;
        this.wrapSocket = ProvSSLSocketWrap.checkSocket(s);
        this.consumed = null;
        this.peerHost = host;
        this.autoClose = autoClose;
        this.useClientMode = true;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
        this.notifyConnected();
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new SocketException("Wrapped socket should already be bound");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted((X509Certificate[])chain.clone(), authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted((X509Certificate[])chain.clone(), authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public BCX509Key chooseClientKey(String[] keyTypes, Principal[] issuers) {
        return this.getContextData().getX509KeyManager().chooseClientKeyBC(keyTypes, JsseUtils.clone(issuers), this);
    }

    @Override
    public BCX509Key chooseServerKey(String[] keyTypes, Principal[] issuers) {
        return this.getContextData().getX509KeyManager().chooseServerKeyBC(keyTypes, JsseUtils.clone(issuers), this);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    @Override
    protected void closeSocket() throws IOException {
        if (this.autoClose) {
            this.wrapSocket.close();
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        throw new SocketException("Wrapped socket should already be connected");
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.close();
            }
            catch (IOException iOException) {
                super.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return this.connection == null ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLSocket> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getSocketAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public BCExtendedSSLSession getBCSession() {
        return this.getSessionImpl();
    }

    @Override
    public SocketChannel getChannel() {
        return this.wrapSocket.getChannel();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Failed to establish connection", e);
        }
        return this.connection;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return this.handshakeSession == null ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession == null ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.wrapSocket.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.wrapSocket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.wrapSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.wrapSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.wrapSocket.getLocalSocketAddress();
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    @Override
    public int getPort() {
        return this.wrapSocket.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.wrapSocket.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.wrapSocket.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.wrapSocket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.wrapSocket.getSendBufferSize();
    }

    @Override
    public SSLSession getSession() {
        return this.getSessionImpl().getExportSSLSession();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.wrapSocket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.wrapSocket.getSoTimeout();
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.contextData.getContext().getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.contextData.getContext().getSupportedProtocols();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.wrapSocket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.wrapSocket.getTrafficClass();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public boolean isBound() {
        return this.wrapSocket.isBound();
    }

    @Override
    public boolean isConnected() {
        return this.wrapSocket.isConnected();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.protocol != null && this.protocol.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.wrapSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.wrapSocket.isOutputShutdown();
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLSocket> selector) {
        this.sslParameters.setSocketAPSelector(selector);
    }

    @Override
    public synchronized void setBCSessionToResume(BCExtendedSSLSession session) {
        if (session == null) {
            throw new NullPointerException("'session' cannot be null");
        }
        if (!(session instanceof ProvSSLSession)) {
            throw new IllegalArgumentException("Session-to-resume must be a session returned from 'getBCSession'");
        }
        if (this.protocol != null) {
            throw new IllegalArgumentException("Session-to-resume cannot be set after the handshake has begun");
        }
        this.sslParameters.setSessionToResume((ProvSSLSession)session);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setHost(String host) {
        this.peerHost = host;
        this.peerHostSNI = host;
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.wrapSocket.setKeepAlive(on);
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.wrapSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.wrapSocket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.wrapSocket.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.wrapSocket.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.wrapSocket.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.wrapSocket.setSoTimeout(timeout);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.wrapSocket.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.wrapSocket.setTrafficClass(tc);
    }

    @Override
    public synchronized void setUseClientMode(boolean useClientMode) {
        if (this.protocol != null) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != useClientMode) {
            this.contextData.getContext().updateDefaultSSLParameters(this.sslParameters, useClientMode);
            this.useClientMode = useClientMode;
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.wrapSocket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.wrapSocket.shutdownOutput();
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean resumable) throws IOException {
        if (this.protocol == null) {
            InputStream input = this.wrapSocket.getInputStream();
            if (this.consumed != null) {
                input = new SequenceInputStream(this.consumed, input);
            }
            OutputStream output = this.wrapSocket.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol clientProtocol = new ProvTlsClientProtocol(input, output, this.socketCloser);
                clientProtocol.setResumableHandshake(resumable);
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters);
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                ProvTlsServerProtocol serverProtocol = new ProvTlsServerProtocol(input, output, this.socketCloser);
                serverProtocol.setResumableHandshake(resumable);
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters);
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(resumable);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    @Override
    public String toString() {
        return this.wrapSocket.toString();
    }

    @Override
    public synchronized String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public synchronized String getPeerHostSNI() {
        return this.peerHostSNI;
    }

    @Override
    public int getPeerPort() {
        return this.getPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        if (this.handshakeSession != null) {
            if (!this.handshakeSession.isValid()) {
                connection.getSession().invalidate();
            }
            this.handshakeSession.getJsseSecurityParameters().clear();
        }
        this.handshakeSession = null;
        this.connection = connection;
        this.notifyHandshakeCompletedListeners(connection.getSession().exportSSLSession);
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionContext sslSessionContext, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters, ProvSSLSession resumedSession) {
        String peerHost = this.getPeerHost();
        int peerPort = this.getPeerPort();
        this.handshakeSession = resumedSession != null ? new ProvSSLSessionResumed(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters, resumedSession.getTlsSession(), resumedSession.getJsseSessionParameters()) : new ProvSSLSessionHandshake(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters);
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> protocols) {
        return this.sslParameters.getSocketAPSelector().select(this, protocols);
    }

    synchronized ProvSSLSession getSessionImpl() {
        this.getConnection();
        return this.connection == null ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
    }

    synchronized void handshakeIfNecessary(boolean resumable) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(resumable);
        }
    }

    synchronized void notifyConnected() {
        if (JsseUtils.isNameSpecified(this.peerHost)) {
            this.peerHostSNI = this.peerHost;
            return;
        }
        InetAddress peerAddress = this.getInetAddress();
        if (peerAddress == null) {
            return;
        }
        if (this.useClientMode && provAssumeOriginalHostName) {
            String originalHostName;
            this.peerHost = originalHostName = peerAddress.getHostName();
            this.peerHostSNI = originalHostName;
            return;
        }
        this.peerHost = this.useClientMode && provJdkTlsTrustNameService ? peerAddress.getHostName() : peerAddress.getHostAddress();
        this.peerHostSNI = null;
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                return ProvSSLSocketWrap.this.protocol == null ? 0 : ProvSSLSocketWrap.this.protocol.applicationDataAvailable();
            }
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        @Override
        public int read() throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            byte[] buf = new byte[1];
            int ret = ProvSSLSocketWrap.this.protocol.readApplicationData(buf, 0, 1);
            return ret < 0 ? -1 : buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            return ProvSSLSocketWrap.this.protocol.readApplicationData(b, off, len);
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketWrap.this.handshakeIfNecessary(true);
                ProvSSLSocketWrap.this.protocol.writeApplicationData(b, off, len);
            }
        }
    }
}

