/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jcajce.util.JcaJceHelper;
import cn.win_trust_erpc.bouncycastle.jsse.provider.PropertyUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvX509TrustManager;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathParameters;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

class ProvTrustManagerFactorySpi
extends TrustManagerFactorySpi {
    private static final Logger LOG = Logger.getLogger(ProvTrustManagerFactorySpi.class.getName());
    private static final boolean provKeyStoreTypeCompat = PropertyUtils.getBooleanSecurityProperty("keystore.type.compat", false);
    protected final boolean isInFipsMode;
    protected final JcaJceHelper helper;
    protected ProvX509TrustManager x509TrustManager;

    static KeyStore getDefaultTrustStore() throws Exception {
        String defaultType = KeyStore.getDefaultType();
        boolean defaultCacertsToJKS = provKeyStoreTypeCompat && "pkcs12".equalsIgnoreCase(defaultType);
        String tsPath = null;
        char[] tsPassword = null;
        String tsPathProp = PropertyUtils.getStringSystemProperty("javax.net.ssl.trustStore");
        if (!"NONE".equals(tsPathProp)) {
            if (tsPathProp != null) {
                if (new File(tsPathProp).exists()) {
                    tsPath = tsPathProp;
                }
            } else {
                String javaHome = PropertyUtils.getStringSystemProperty("java.home");
                if (javaHome != null) {
                    String jsseCacertsPath = String.valueOf(javaHome) + "/lib/security/jssecacerts".replace("/", File.separator);
                    if (new File(jsseCacertsPath).exists()) {
                        if (defaultCacertsToJKS) {
                            defaultType = "jks";
                        }
                        tsPath = jsseCacertsPath;
                    } else {
                        String cacertsPath = String.valueOf(javaHome) + "/lib/security/cacerts".replace("/", File.separator);
                        if (new File(cacertsPath).exists()) {
                            if (defaultCacertsToJKS) {
                                defaultType = "jks";
                            }
                            tsPath = cacertsPath;
                        }
                    }
                }
            }
        }
        KeyStore ks = ProvTrustManagerFactorySpi.createTrustStore(defaultType);
        String tsPasswordProp = PropertyUtils.getSensitiveStringSystemProperty("javax.net.ssl.trustStorePassword");
        if (tsPasswordProp != null) {
            tsPassword = tsPasswordProp.toCharArray();
        }
        InputStream tsInput = null;
        try {
            if (tsPath == null) {
                LOG.config("Initializing default trust store as empty");
            } else {
                LOG.config("Initializing default trust store from path: " + tsPath);
                tsInput = new BufferedInputStream(new FileInputStream(tsPath));
            }
            try {
                ks.load(tsInput, tsPassword);
            }
            catch (NullPointerException e) {
                ks = KeyStore.getInstance("BCFKS");
                ks.load(null, null);
            }
        }
        finally {
            if (tsInput != null) {
                tsInput.close();
            }
        }
        return ks;
    }

    ProvTrustManagerFactorySpi(boolean isInFipsMode, JcaJceHelper helper) {
        this.isInFipsMode = isInFipsMode;
        this.helper = helper;
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        if (this.x509TrustManager == null) {
            throw new IllegalStateException("TrustManagerFactory not initialized");
        }
        return new TrustManager[]{this.x509TrustManager.getExportX509TrustManager()};
    }

    @Override
    protected void engineInit(KeyStore ks) throws KeyStoreException {
        if (ks == null) {
            try {
                ks = ProvTrustManagerFactorySpi.getDefaultTrustStore();
            }
            catch (SecurityException e) {
                LOG.log(Level.WARNING, "Skipped default trust store", e);
            }
            catch (Error e) {
                LOG.log(Level.WARNING, "Skipped default trust store", e);
                throw e;
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Skipped default trust store", e);
                throw e;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Skipped default trust store", e);
                throw new KeyStoreException("Failed to load default trust store", e);
            }
        }
        Set<TrustAnchor> trustAnchors = ProvTrustManagerFactorySpi.getTrustAnchors(ks);
        try {
            this.x509TrustManager = new ProvX509TrustManager(this.isInFipsMode, this.helper, trustAnchors);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new KeyStoreException("Failed to create trust manager", e);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        CertPathParameters certPathParameters;
        if (spec instanceof CertPathTrustManagerParameters) {
            certPathParameters = ((CertPathTrustManagerParameters)spec).getParameters();
            if (!(certPathParameters instanceof PKIXParameters)) {
                throw new InvalidAlgorithmParameterException("parameters must inherit from PKIXParameters");
            }
        } else {
            if (spec == null) {
                throw new InvalidAlgorithmParameterException("spec cannot be null");
            }
            throw new InvalidAlgorithmParameterException("unknown spec: " + spec.getClass().getName());
        }
        this.x509TrustManager = new ProvX509TrustManager(this.isInFipsMode, this.helper, (PKIXParameters)certPathParameters);
    }

    private static void collectTrustAnchor(Set<TrustAnchor> trustAnchors, Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            trustAnchors.add(new TrustAnchor((X509Certificate)certificate, null));
        }
    }

    private static KeyStore createTrustStore(String defaultType) throws NoSuchProviderException, KeyStoreException {
        String tsType = ProvTrustManagerFactorySpi.getTrustStoreType(defaultType);
        String tsProv = PropertyUtils.getStringSystemProperty("javax.net.ssl.trustStoreProvider");
        return TlsUtils.isNullOrEmpty(tsProv) ? KeyStore.getInstance(tsType) : KeyStore.getInstance(tsType, tsProv);
    }

    private static Set<TrustAnchor> getTrustAnchors(KeyStore trustStore) throws KeyStoreException {
        if (trustStore == null) {
            return Collections.emptySet();
        }
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        Enumeration<String> en = trustStore.aliases();
        while (en.hasMoreElements()) {
            Certificate[] chain;
            String alias = en.nextElement();
            if (trustStore.isCertificateEntry(alias)) {
                ProvTrustManagerFactorySpi.collectTrustAnchor(trustAnchors, trustStore.getCertificate(alias));
                continue;
            }
            if (!trustStore.isKeyEntry(alias) || (chain = trustStore.getCertificateChain(alias)) == null || chain.length <= 0) continue;
            ProvTrustManagerFactorySpi.collectTrustAnchor(trustAnchors, chain[0]);
        }
        return trustAnchors;
    }

    private static String getTrustStoreType(String defaultType) {
        String tsType = PropertyUtils.getStringSystemProperty("javax.net.ssl.trustStoreType");
        return tsType == null ? defaultType : tsType;
    }
}

