/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCX509Key;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

class ProvX509Key
implements BCX509Key {
    private final String keyType;
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;

    static ProvX509Key from(X509KeyManager x509KeyManager, String keyType, String alias) {
        if (x509KeyManager == null) {
            throw new NullPointerException("'x509KeyManager' cannot be null");
        }
        if (keyType == null || alias == null) {
            return null;
        }
        PrivateKey privateKey = x509KeyManager.getPrivateKey(alias);
        if (privateKey == null) {
            return null;
        }
        Object[] certificateChain = x509KeyManager.getCertificateChain(alias);
        if (TlsUtils.isNullOrEmpty(certificateChain)) {
            return null;
        }
        if (JsseUtils.containsNull(certificateChain = (X509Certificate[])certificateChain.clone())) {
            return null;
        }
        return new ProvX509Key(keyType, privateKey, (X509Certificate[])certificateChain);
    }

    ProvX509Key(String keyType, PrivateKey privateKey, X509Certificate[] certificateChain) {
        this.keyType = keyType;
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

