/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.KeyPurposeId;
import cn.win_trust_erpc.bouncycastle.asn1.x9.ECNamedCurveTable;
import cn.win_trust_erpc.bouncycastle.jcajce.util.JcaJceHelper;
import cn.win_trust_erpc.bouncycastle.jsse.BCExtendedSSLSession;
import cn.win_trust_erpc.bouncycastle.jsse.BCSNIHostName;
import cn.win_trust_erpc.bouncycastle.jsse.BCX509ExtendedKeyManager;
import cn.win_trust_erpc.bouncycastle.jsse.BCX509Key;
import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvX509Key;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvX509KeyManager;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvX509TrustManager;
import cn.win_trust_erpc.bouncycastle.jsse.provider.TransportData;
import cn.win_trust_erpc.bouncycastle.tls.NamedGroup;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

class ProvX509KeyManagerSimple
extends BCX509ExtendedKeyManager {
    private static final Logger LOG = Logger.getLogger(ProvX509KeyManagerSimple.class.getName());
    private final boolean isInFipsMode;
    private final JcaJceHelper helper;
    private final Map<String, Credential> credentials;
    private static final Map<String, PublicKeyFilter> FILTERS_CLIENT = ProvX509KeyManagerSimple.createFiltersClient();
    private static final Map<String, PublicKeyFilter> FILTERS_SERVER = ProvX509KeyManagerSimple.createFiltersServer();

    private static void addECFilter13(Map<String, PublicKeyFilter> filters, int namedGroup13) {
        ASN1ObjectIdentifier standardOID;
        if (!NamedGroup.canBeNegotiated(namedGroup13, ProtocolVersion.TLSv13)) {
            throw new IllegalStateException("Invalid named group for TLS 1.3 EC filter");
        }
        String curveName = NamedGroup.getCurveName(namedGroup13);
        if (curveName != null && (standardOID = ECNamedCurveTable.getOID(curveName)) != null) {
            String keyType = JsseUtils.getKeyType13("EC", namedGroup13);
            ECPublicKeyFilter13 filter = new ECPublicKeyFilter13(standardOID);
            ProvX509KeyManagerSimple.addFilterToMap(filters, keyType, filter);
            return;
        }
        LOG.warning("Failed to register public key filter for EC with " + NamedGroup.getText(namedGroup13));
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, String keyType) {
        String algorithm = keyType;
        ProvX509KeyManagerSimple.addFilter(filters, 0, algorithm, null, keyType);
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, Class<? extends PublicKey> clazz, String ... keyTypes) {
        ProvX509KeyManagerSimple.addFilter(filters, 0, null, clazz, keyTypes);
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, Class<? extends PublicKey> clazz, String ... keyTypes) {
        DefaultPublicKeyFilter filter = new DefaultPublicKeyFilter(algorithm, clazz, keyUsageBit);
        String[] stringArray = keyTypes;
        int n = keyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String keyType = stringArray[n2];
            ProvX509KeyManagerSimple.addFilterToMap(filters, keyType, filter);
            ++n2;
        }
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, String algorithm, int ... keyExchangeAlgorithms) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, 0, algorithm, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, int ... keyExchangeAlgorithms) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, keyUsageBit, algorithm, null, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, Class<? extends PublicKey> clazz, int ... keyExchangeAlgorithms) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, 0, null, clazz, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, Class<? extends PublicKey> clazz, int ... keyExchangeAlgorithms) {
        ProvX509KeyManagerSimple.addFilter(filters, keyUsageBit, algorithm, clazz, ProvX509KeyManagerSimple.getKeyTypesLegacyServer(keyExchangeAlgorithms));
    }

    private static void addFilterToMap(Map<String, PublicKeyFilter> filters, String keyType, PublicKeyFilter filter) {
        if (filters.put(keyType, filter) != null) {
            throw new IllegalStateException("Duplicate keys in filters");
        }
    }

    private static Map<String, PublicKeyFilter> createFiltersClient() {
        HashMap<String, PublicKeyFilter> filters = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManagerSimple.addFilter(filters, "Ed25519");
        ProvX509KeyManagerSimple.addFilter(filters, "Ed448");
        ProvX509KeyManagerSimple.addECFilter13(filters, 31);
        ProvX509KeyManagerSimple.addECFilter13(filters, 32);
        ProvX509KeyManagerSimple.addECFilter13(filters, 33);
        ProvX509KeyManagerSimple.addECFilter13(filters, 23);
        ProvX509KeyManagerSimple.addECFilter13(filters, 24);
        ProvX509KeyManagerSimple.addECFilter13(filters, 25);
        ProvX509KeyManagerSimple.addFilter(filters, "RSA");
        ProvX509KeyManagerSimple.addFilter(filters, "RSASSA-PSS");
        ProvX509KeyManagerSimple.addFilter(filters, DSAPublicKey.class, "DSA");
        ProvX509KeyManagerSimple.addFilter(filters, ECPublicKey.class, "EC");
        return Collections.unmodifiableMap(filters);
    }

    private static Map<String, PublicKeyFilter> createFiltersServer() {
        HashMap<String, PublicKeyFilter> filters = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManagerSimple.addFilter(filters, "Ed25519");
        ProvX509KeyManagerSimple.addFilter(filters, "Ed448");
        ProvX509KeyManagerSimple.addECFilter13(filters, 31);
        ProvX509KeyManagerSimple.addECFilter13(filters, 32);
        ProvX509KeyManagerSimple.addECFilter13(filters, 33);
        ProvX509KeyManagerSimple.addECFilter13(filters, 23);
        ProvX509KeyManagerSimple.addECFilter13(filters, 24);
        ProvX509KeyManagerSimple.addECFilter13(filters, 25);
        ProvX509KeyManagerSimple.addFilter(filters, "RSA");
        ProvX509KeyManagerSimple.addFilter(filters, "RSASSA-PSS");
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, DSAPublicKey.class, 3, 22);
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, ECPublicKey.class, 17);
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, "RSA", 5, 19, 23);
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, 2, "RSA", 1);
        return Collections.unmodifiableMap(filters);
    }

    private static String[] getKeyTypesLegacyServer(int ... keyExchangeAlgorithms) {
        int count = keyExchangeAlgorithms.length;
        String[] keyTypes = new String[count];
        int i = 0;
        while (i < count) {
            keyTypes[i] = JsseUtils.getKeyTypeLegacyServer(keyExchangeAlgorithms[i]);
            ++i;
        }
        return keyTypes;
    }

    private static Map<String, Credential> loadCredentials(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, Credential> credentials = new HashMap<String, Credential>(4);
        if (ks != null) {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Object[] certificateChain;
                PrivateKey privateKey;
                String alias = aliases.nextElement();
                if (!ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || (privateKey = (PrivateKey)ks.getKey(alias, password)) == null || TlsUtils.isNullOrEmpty(certificateChain = JsseUtils.getX509CertificateChain(ks.getCertificateChain(alias)))) continue;
                credentials.put(alias, new Credential(alias, privateKey, (X509Certificate[])certificateChain));
            }
        }
        return Collections.unmodifiableMap(credentials);
    }

    ProvX509KeyManagerSimple(boolean isInFipsMode, JcaJceHelper helper, KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.isInFipsMode = isInFipsMode;
        this.helper = helper;
        this.credentials = ProvX509KeyManagerSimple.loadCredentials(ks, password);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public BCX509Key chooseClientKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public BCX509Key chooseEngineClientKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, TransportData.from(engine), true);
    }

    @Override
    public BCX509Key chooseEngineServerKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(engine), true);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, TransportData.from(socket), true);
    }

    @Override
    public BCX509Key chooseServerKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(socket), true);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        Credential credential = this.getCredential(alias);
        return credential == null ? null : (X509Certificate[])credential.certificateChain.clone();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, null, false);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        Credential credential = this.getCredential(alias);
        return credential == null ? null : credential.privateKey;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, null, true);
    }

    @Override
    protected BCX509Key getKeyBC(String keyType, String alias) {
        Credential credential = this.getCredential(alias);
        return this.createKeyBC(keyType, credential);
    }

    private String chooseAlias(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (bestMatch.compareTo(Match.NOTHING) < 0) {
            String keyType = keyTypes.get(bestMatch.keyTypeIndex);
            String alias = ProvX509KeyManagerSimple.getAlias(bestMatch);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found matching key of type: " + keyType + ", returning alias: " + alias);
            }
            return alias;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key chooseKeyBC(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        String keyType;
        BCX509Key keyBC;
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (bestMatch.compareTo(Match.NOTHING) < 0 && (keyBC = this.createKeyBC(keyType = keyTypes.get(bestMatch.keyTypeIndex), bestMatch.credential)) != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found matching key of type: " + keyType + ", from alias: " + ProvX509KeyManagerSimple.getAlias(bestMatch));
            }
            return keyBC;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key createKeyBC(String keyType, Credential credential) {
        return credential == null ? null : new ProvX509Key(keyType, credential.privateKey, credential.certificateChain);
    }

    private String[] getAliases(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        if (!this.credentials.isEmpty() && !keyTypes.isEmpty()) {
            int keyTypeLimit = keyTypes.size();
            Set<Principal> uniqueIssuers = ProvX509KeyManagerSimple.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManagerSimple.getRequestedHostName(transportData, forServer);
            List<Match> matches = null;
            for (Credential credential : this.credentials.values()) {
                Match match = this.getPotentialMatch(credential, keyTypes, keyTypeLimit, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
                if (match.compareTo(Match.NOTHING) >= 0) continue;
                matches = ProvX509KeyManagerSimple.addToMatches(matches, match);
            }
            if (matches != null && !matches.isEmpty()) {
                Collections.sort(matches);
                return ProvX509KeyManagerSimple.getAliases(matches);
            }
        }
        return null;
    }

    private Match getBestMatch(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatchSoFar = Match.NOTHING;
        if (!this.credentials.isEmpty() && !keyTypes.isEmpty()) {
            int keyTypeLimit = keyTypes.size();
            Set<Principal> uniqueIssuers = ProvX509KeyManagerSimple.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManagerSimple.getRequestedHostName(transportData, forServer);
            for (Credential credential : this.credentials.values()) {
                Match match = this.getPotentialMatch(credential, keyTypes, keyTypeLimit, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
                if (match.compareTo(bestMatchSoFar) >= 0) continue;
                bestMatchSoFar = match;
                if (bestMatchSoFar.isIdeal()) {
                    return bestMatchSoFar;
                }
                if (!bestMatchSoFar.isValid()) continue;
                keyTypeLimit = Math.min(keyTypeLimit, bestMatchSoFar.keyTypeIndex + 1);
            }
        }
        return bestMatchSoFar;
    }

    private Match getPotentialMatch(Credential credential, List<String> keyTypes, int keyTypeLimit, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) {
        int keyTypeIndex;
        Object[] chain = credential.certificateChain;
        if (!TlsUtils.isNullOrEmpty(chain) && ProvX509KeyManagerSimple.isSuitableChainForIssuers((X509Certificate[])chain, uniqueIssuers) && (keyTypeIndex = ProvX509KeyManagerSimple.getSuitableKeyTypeForEECert((X509Certificate)chain[0], keyTypes, keyTypeLimit, algorithmConstraints, forServer)) >= 0) {
            String keyType = keyTypes.get(keyTypeIndex);
            LOG.finer("EE cert potentially usable for key type: " + keyType);
            if (this.isSuitableChain((X509Certificate[])chain, algorithmConstraints, forServer)) {
                Match.Quality quality = ProvX509KeyManagerSimple.getCertificateQuality((X509Certificate)chain[0], atDate, requestedHostName);
                return new Match(quality, keyTypeIndex, credential);
            }
            LOG.finer("Unsuitable chain for key type: " + keyType);
        }
        return Match.NOTHING;
    }

    private Credential getCredential(String alias) {
        return alias == null ? null : this.credentials.get(alias);
    }

    private boolean isSuitableChain(X509Certificate[] chain, BCAlgorithmConstraints algorithmConstraints, boolean forServer) {
        try {
            Set<X509Certificate> trustedCerts = Collections.emptySet();
            KeyPurposeId ekuOID = ProvX509KeyManager.getRequiredExtendedKeyUsage(forServer);
            int kuBit = -1;
            ProvAlgorithmChecker.checkChain(this.isInFipsMode, this.helper, algorithmConstraints, trustedCerts, chain, ekuOID, kuBit);
            return true;
        }
        catch (CertPathValidatorException e) {
            LOG.log(Level.FINEST, "Certificate chain check failed", e);
            return false;
        }
    }

    private static List<Match> addToMatches(List<Match> matches, Match match) {
        if (matches == null) {
            matches = new ArrayList<Match>();
        }
        matches.add(match);
        return matches;
    }

    private static String getAlias(Match match) {
        return match.credential.alias;
    }

    private static String[] getAliases(List<Match> matches) {
        int count = matches.size();
        int pos = 0;
        String[] result = new String[count];
        for (Match match : matches) {
            result[pos++] = ProvX509KeyManagerSimple.getAlias(match);
        }
        return result;
    }

    private static Match.Quality getCertificateQuality(X509Certificate certificate, Date atDate, String requestedHostName) {
        boolean[] keyUsage;
        try {
            certificate.checkValidity(atDate);
        }
        catch (CertificateException e) {
            return Match.Quality.EXPIRED;
        }
        if (requestedHostName != null) {
            try {
                ProvX509TrustManager.checkEndpointID(requestedHostName, certificate, "HTTPS");
            }
            catch (CertificateException e) {
                return Match.Quality.MISMATCH_SNI;
            }
        }
        if ("RSA".equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(certificate.getPublicKey())) && ProvAlgorithmChecker.supportsKeyUsage(keyUsage = certificate.getKeyUsage(), 0) && ProvAlgorithmChecker.supportsKeyUsage(keyUsage, 2)) {
            return Match.Quality.RSA_MULTI_USE;
        }
        return Match.Quality.OK;
    }

    private static List<String> getKeyTypes(String ... keyTypes) {
        if (keyTypes != null && keyTypes.length > 0) {
            ArrayList<String> result = new ArrayList<String>(keyTypes.length);
            String[] stringArray = keyTypes;
            int n = keyTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String keyType = stringArray[n2];
                if (keyType == null) {
                    throw new IllegalArgumentException("Key types cannot be null");
                }
                if (!result.contains(keyType)) {
                    result.add(keyType);
                }
                ++n2;
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private static String getRequestedHostName(TransportData transportData, boolean forServer) {
        BCSNIHostName sniHostName;
        BCExtendedSSLSession sslSession;
        if (transportData != null && forServer && (sslSession = transportData.getHandshakeSession()) != null && (sniHostName = JsseUtils.getSNIHostName(sslSession.getRequestedServerNames())) != null) {
            return sniHostName.getAsciiName();
        }
        return null;
    }

    private static int getSuitableKeyTypeForEECert(X509Certificate eeCert, List<String> keyTypes, int keyTypeLimit, BCAlgorithmConstraints algorithmConstraints, boolean forServer) {
        Map<String, PublicKeyFilter> filters = forServer ? FILTERS_SERVER : FILTERS_CLIENT;
        PublicKey publicKey = eeCert.getPublicKey();
        boolean[] keyUsage = eeCert.getKeyUsage();
        int keyTypeIndex = 0;
        while (keyTypeIndex < keyTypeLimit) {
            String keyType = keyTypes.get(keyTypeIndex);
            PublicKeyFilter filter = filters.get(keyType);
            if (filter != null && filter.accepts(publicKey, keyUsage, algorithmConstraints)) {
                return keyTypeIndex;
            }
            ++keyTypeIndex;
        }
        return -1;
    }

    private static Set<Principal> getUniquePrincipals(Principal[] principals) {
        if (principals == null) {
            return null;
        }
        if (principals.length > 0) {
            HashSet<Principal> result = new HashSet<Principal>();
            int i = 0;
            while (i < principals.length) {
                Principal principal = principals[i];
                if (principal != null) {
                    result.add(principal);
                }
                ++i;
            }
            if (!result.isEmpty()) {
                return Collections.unmodifiableSet(result);
            }
        }
        return Collections.emptySet();
    }

    private static boolean isSuitableChainForIssuers(X509Certificate[] chain, Set<Principal> uniqueIssuers) {
        if (uniqueIssuers == null || uniqueIssuers.isEmpty()) {
            return true;
        }
        int pos = chain.length;
        while (--pos >= 0) {
            if (!uniqueIssuers.contains(chain[pos].getIssuerX500Principal())) continue;
            return true;
        }
        X509Certificate eeCert = chain[0];
        return eeCert.getBasicConstraints() >= 0 && uniqueIssuers.contains(eeCert.getSubjectX500Principal());
    }

    private static class Credential {
        private final String alias;
        private final PrivateKey privateKey;
        private final X509Certificate[] certificateChain;

        Credential(String alias, PrivateKey privateKey, X509Certificate[] certificateChain) {
            this.alias = alias;
            this.privateKey = privateKey;
            this.certificateChain = certificateChain;
        }
    }

    private static final class DefaultPublicKeyFilter
    implements PublicKeyFilter {
        final String algorithm;
        final Class<? extends PublicKey> clazz;
        final int keyUsageBit;

        DefaultPublicKeyFilter(String algorithm, Class<? extends PublicKey> clazz, int keyUsageBit) {
            this.algorithm = algorithm;
            this.clazz = clazz;
            this.keyUsageBit = keyUsageBit;
        }

        @Override
        public boolean accepts(PublicKey publicKey, boolean[] keyUsage, BCAlgorithmConstraints algorithmConstraints) {
            return this.appliesTo(publicKey) && ProvAlgorithmChecker.permitsKeyUsage(publicKey, keyUsage, this.keyUsageBit, algorithmConstraints);
        }

        private boolean appliesTo(PublicKey publicKey) {
            return this.algorithm != null && this.algorithm.equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(publicKey)) || this.clazz != null && this.clazz.isInstance(publicKey);
        }
    }

    private static final class ECPublicKeyFilter13
    implements PublicKeyFilter {
        final ASN1ObjectIdentifier standardOID;

        ECPublicKeyFilter13(ASN1ObjectIdentifier standardOID) {
            this.standardOID = standardOID;
        }

        @Override
        public boolean accepts(PublicKey publicKey, boolean[] keyUsage, BCAlgorithmConstraints algorithmConstraints) {
            return this.appliesTo(publicKey) && ProvAlgorithmChecker.permitsKeyUsage(publicKey, keyUsage, 0, algorithmConstraints);
        }

        private boolean appliesTo(PublicKey publicKey) {
            ASN1ObjectIdentifier oid;
            return ("EC".equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(publicKey)) || ECPublicKey.class.isInstance(publicKey)) && this.standardOID.equals(oid = JsseUtils.getNamedCurveOID(publicKey));
        }
    }

    private static final class Match
    implements Comparable<Match> {
        static final Quality INVALID = Quality.MISMATCH_SNI;
        static final Match NOTHING = new Match(Quality.NONE, Integer.MAX_VALUE, null);
        final Quality quality;
        final int keyTypeIndex;
        final Credential credential;

        Match(Quality quality, int keyTypeIndex, Credential credential) {
            this.quality = quality;
            this.keyTypeIndex = keyTypeIndex;
            this.credential = credential;
        }

        @Override
        public int compareTo(Match that) {
            int cmp = Boolean.compare(that.isValid(), this.isValid());
            if (cmp == 0 && (cmp = Integer.compare(this.keyTypeIndex, that.keyTypeIndex)) == 0) {
                cmp = this.quality.compareTo(that.quality);
            }
            return cmp;
        }

        boolean isIdeal() {
            return Quality.OK == this.quality && this.keyTypeIndex == 0;
        }

        boolean isValid() {
            return this.quality.compareTo(INVALID) < 0;
        }

        static enum Quality {
            OK,
            RSA_MULTI_USE,
            MISMATCH_SNI,
            EXPIRED,
            NONE;

        }
    }

    private static interface PublicKeyFilter {
        public boolean accepts(PublicKey var1, boolean[] var2, BCAlgorithmConstraints var3);
    }
}

