/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCSNIMatcher;
import cn.win_trust_erpc.bouncycastle.jsse.BCSNIServerName;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils_7;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;

abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getApplicationProtocols;
    private static final Method setApplicationProtocols;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getSNIMatchers;
    private static final Method setSNIMatchers;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    static {
        Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.SSLParameters");
        getAlgorithmConstraints = ReflectionUtil.findMethod(methods, "getAlgorithmConstraints");
        setAlgorithmConstraints = ReflectionUtil.findMethod(methods, "setAlgorithmConstraints");
        getApplicationProtocols = ReflectionUtil.findMethod(methods, "getApplicationProtocols");
        setApplicationProtocols = ReflectionUtil.findMethod(methods, "setApplicationProtocols");
        getEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methods, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methods, "setEndpointIdentificationAlgorithm");
        getServerNames = ReflectionUtil.findMethod(methods, "getServerNames");
        setServerNames = ReflectionUtil.findMethod(methods, "setServerNames");
        getSNIMatchers = ReflectionUtil.findMethod(methods, "getSNIMatchers");
        setSNIMatchers = ReflectionUtil.findMethod(methods, "setSNIMatchers");
        getUseCipherSuitesOrder = ReflectionUtil.findMethod(methods, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = ReflectionUtil.findMethod(methods, "setUseCipherSuitesOrder");
    }

    SSLParametersUtil() {
    }

    static BCSSLParameters getParameters(ProvSSLParameters prov) {
        BCSSLParameters ssl = new BCSSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else if (prov.getWantClientAuth()) {
            ssl.setWantClientAuth(true);
        } else {
            ssl.setWantClientAuth(false);
        }
        ssl.setAlgorithmConstraints(prov.getAlgorithmConstraints());
        ssl.setEndpointIdentificationAlgorithm(prov.getEndpointIdentificationAlgorithm());
        ssl.setUseCipherSuitesOrder(prov.getUseCipherSuitesOrder());
        ssl.setServerNames(prov.getServerNames());
        ssl.setSNIMatchers(prov.getSNIMatchers());
        ssl.setApplicationProtocols(prov.getApplicationProtocols());
        return ssl;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters prov) {
        String[] applicationProtocols;
        SSLParameters ssl = new SSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else if (prov.getWantClientAuth()) {
            ssl.setWantClientAuth(true);
        } else {
            ssl.setWantClientAuth(false);
        }
        if (setAlgorithmConstraints != null) {
            SSLParametersUtil.set(ssl, setAlgorithmConstraints, JsseUtils_7.exportAlgorithmConstraintsDynamic(prov.getAlgorithmConstraints()));
        }
        if (setEndpointIdentificationAlgorithm != null) {
            SSLParametersUtil.set(ssl, setEndpointIdentificationAlgorithm, prov.getEndpointIdentificationAlgorithm());
        }
        if (setUseCipherSuitesOrder != null) {
            SSLParametersUtil.set(ssl, setUseCipherSuitesOrder, prov.getUseCipherSuitesOrder());
        }
        if (setApplicationProtocols != null && (applicationProtocols = prov.getApplicationProtocols()) != null) {
            SSLParametersUtil.set(ssl, setApplicationProtocols, applicationProtocols);
        }
        return ssl;
    }

    static BCSSLParameters importSSLParameters(SSLParameters ssl) {
        String[] applicationProtocols;
        String endpointIdentificationAlgorithm;
        Object constraints;
        BCSSLParameters bc = new BCSSLParameters(ssl.getCipherSuites(), ssl.getProtocols());
        if (ssl.getNeedClientAuth()) {
            bc.setNeedClientAuth(true);
        } else if (ssl.getWantClientAuth()) {
            bc.setWantClientAuth(true);
        } else {
            bc.setWantClientAuth(false);
        }
        if (getAlgorithmConstraints != null && (constraints = SSLParametersUtil.get(ssl, getAlgorithmConstraints)) != null) {
            bc.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraintsDynamic(constraints));
        }
        if (getEndpointIdentificationAlgorithm != null && (endpointIdentificationAlgorithm = (String)SSLParametersUtil.get(ssl, getEndpointIdentificationAlgorithm)) != null) {
            bc.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (getUseCipherSuitesOrder != null) {
            bc.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(ssl, getUseCipherSuitesOrder));
        }
        if (getApplicationProtocols != null && (applicationProtocols = (String[])SSLParametersUtil.get(ssl, getApplicationProtocols)) != null) {
            bc.setApplicationProtocols(applicationProtocols);
        }
        return bc;
    }

    static void setParameters(ProvSSLParameters prov, BCSSLParameters ssl) {
        String[] applicationProtocols;
        Collection<BCSNIMatcher> sniMatchers;
        String endpointIdentificationAlgorithm;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (cipherSuites != null) {
            prov.setCipherSuites(cipherSuites);
        }
        if ((protocols = ssl.getProtocols()) != null) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else if (ssl.getWantClientAuth()) {
            prov.setWantClientAuth(true);
        } else {
            prov.setWantClientAuth(false);
        }
        BCAlgorithmConstraints algorithmConstraints = ssl.getAlgorithmConstraints();
        if (algorithmConstraints != null) {
            prov.setAlgorithmConstraints(algorithmConstraints);
        }
        if ((endpointIdentificationAlgorithm = ssl.getEndpointIdentificationAlgorithm()) != null) {
            prov.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        prov.setUseCipherSuitesOrder(ssl.getUseCipherSuitesOrder());
        List<BCSNIServerName> serverNames = ssl.getServerNames();
        if (serverNames != null) {
            prov.setServerNames(serverNames);
        }
        if ((sniMatchers = ssl.getSNIMatchers()) != null) {
            prov.setSNIMatchers(sniMatchers);
        }
        if ((applicationProtocols = ssl.getApplicationProtocols()) != null) {
            prov.setApplicationProtocols(applicationProtocols);
        }
    }

    static void setSSLParameters(ProvSSLParameters prov, SSLParameters ssl) {
        String[] applicationProtocols;
        String endpointIdentificationAlgorithm;
        Object constraints;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (cipherSuites != null) {
            prov.setCipherSuites(cipherSuites);
        }
        if ((protocols = ssl.getProtocols()) != null) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else if (ssl.getWantClientAuth()) {
            prov.setWantClientAuth(true);
        } else {
            prov.setWantClientAuth(false);
        }
        if (getAlgorithmConstraints != null && (constraints = SSLParametersUtil.get(ssl, getAlgorithmConstraints)) != null) {
            prov.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraintsDynamic(constraints));
        }
        if (getEndpointIdentificationAlgorithm != null && (endpointIdentificationAlgorithm = (String)SSLParametersUtil.get(ssl, getEndpointIdentificationAlgorithm)) != null) {
            prov.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (getUseCipherSuitesOrder != null) {
            prov.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(ssl, getUseCipherSuitesOrder));
        }
        if (getApplicationProtocols != null && (applicationProtocols = (String[])SSLParametersUtil.get(ssl, getApplicationProtocols)) != null) {
            prov.setApplicationProtocols(applicationProtocols);
        }
    }

    private static Object get(Object obj, Method method) {
        return ReflectionUtil.invokeGetter(obj, method);
    }

    private static void set(Object obj, Method method, Object arg) {
        ReflectionUtil.invokeSetter(obj, method, arg);
    }
}

